/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBPreviewCutterStatusDelegate;
import com.apple.itunes.epubtoolkit.EPUBPreviewCutterThreshold;
import com.apple.itunes.epubtoolkit.XHTMLAnalyzer;
import com.apple.itunes.epubtoolkit.XHTMLCutter;
import com.apple.itunes.epubtoolkit.itemproperties.ItemProperty;
import com.apple.itunes.epubtoolkit.itemproperties.ItemPropertyFactory;
import com.apple.itunes.epubtoolkit.model.EPUBGuide;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.GuideItem;
import com.apple.itunes.epubtoolkit.model.NavDocument;
import com.apple.itunes.epubtoolkit.model.NavDocumentBuilder;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.XHTMLAnalysis;
import com.apple.itunes.epubtoolkit.util.CommonsCompressZipUtil;
import com.apple.itunes.epubtoolkit.util.EPUBUnzipper;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class EPUBPreviewCutter {
    private File input;
    private File output;
    private Integer startIndex;
    private Integer percentage;
    private String endAnchor;
    private EPUBPreviewCutterStatusDelegate delegate;
    private Boolean fixedLayout;
    private EPUBUnzipper unzipper = new CommonsCompressZipUtil();
    private final int maximumPercentage = 15;

    public EPUBPreviewCutter(File input, File output, Integer startIndex, Integer percentage, String endAnchor, EPUBPreviewCutterStatusDelegate delegate, Boolean fixedLayout) {
        if (percentage == null) {
            percentage = 7;
        }
        if (percentage < 1) {
            throw new IllegalArgumentException("Parameter percentage must be greater than 0 but is " + percentage);
        }
        if (percentage > 100) {
            throw new IllegalArgumentException("Parameter percentage must be less than 100 but is " + percentage);
        }
        this.input = input;
        this.output = output;
        this.startIndex = startIndex == null ? 0 : startIndex;
        this.percentage = percentage;
        this.endAnchor = endAnchor == null ? "com_apple_itunes_epub_end" : endAnchor;
        this.delegate = delegate;
        this.fixedLayout = fixedLayout;
    }

    public void setUnzipper(EPUBUnzipper unzipper) {
        this.unzipper = unzipper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EPUBModel cut() throws IOException, EPUBException {
        File tempDir = FileUtilities.createTempDirectory(this.input.getName() + ".", "unpacked");
        try {
            this.unzip(tempDir);
            EPUBModel model = new EPUBModel(tempDir);
            if (this.fixedLayout.booleanValue()) {
                this.cutFixedLayout(model);
            } else {
                this.cutCharCount(model);
            }
            this.zip(tempDir);
            EPUBModel ePUBModel = model;
            return ePUBModel;
        }
        finally {
            FileUtilities.deleteRecursively(tempDir);
        }
    }

    private OPFManifestItem getBackCover(EPUBModel model) throws EPUBException {
        GuideItem backCoverGuide = model.getGuide().getBackCoverGuideItem();
        if (backCoverGuide == null) {
            return null;
        }
        String bcURI = backCoverGuide.getURI();
        if (bcURI == null) {
            return null;
        }
        return model.getOPF().getManifestItem(backCoverGuide);
    }

    private void cutFixedLayout(EPUBModel model) throws IOException, EPUBException {
        OPFDocument opf = model.getOPF();
        EPUBGuide guide = model.getGuide();
        HashSet<String> fallbackIds = new HashSet<String>();
        for (OPFManifestItem manifestItem : opf.getLocalManifestItems()) {
            if (manifestItem.getFallback() == null) continue;
            fallbackIds.add(manifestItem.getFallback());
        }
        opf.cleanup();
        OPFManifestItem backCover = this.getBackCover(model);
        List<GuideItem> guideItems = guide.getGuideItems();
        GuideItem textStart = null;
        for (GuideItem guideItem : guideItems) {
            String type = guideItem.getType();
            if (!"text".equals(type) && !"bodymatter".equals(type)) continue;
            textStart = guideItem;
            break;
        }
        int spineSkip = 0;
        List<String> spineIdentifiers = opf.getXHTMLSpineIdentifiers();
        if (spineIdentifiers.size() == 0) {
            model.saveChanges();
            return;
        }
        boolean startFound = false;
        if (textStart != null) {
            for (int y = 0; y < spineIdentifiers.size(); ++y) {
                String id = spineIdentifiers.get(y);
                OPFManifestItem gItem = opf.getManifestItem(textStart);
                if (gItem != null && id.equalsIgnoreCase(gItem.getId())) {
                    startFound = true;
                    break;
                }
                ++spineSkip;
            }
        }
        if (!startFound) {
            spineSkip = 0;
        }
        int textCutoff = (int)Math.ceil((double)((spineIdentifiers.size() - spineSkip) * this.percentage) / 100.0);
        String cutOffItem = spineIdentifiers.get(spineSkip + textCutoff - 1);
        XHTMLAnalyzer analyzer = new XHTMLAnalyzer();
        XHTMLAnalysis analysis = analyzer.analyze(model, cutOffItem);
        Threshold threshold = new Threshold(analysis, analysis.getWordCount());
        ArrayList<String> anchors = new ArrayList<String>();
        Map<NavDocumentBuilder.NavType, NavDocument> navDocs = model.getNavs();
        int maxRefCount = 1;
        for (NavDocument navDoc : navDocs.values()) {
            maxRefCount = Math.max(maxRefCount, navDoc.getAllPoints().size());
        }
        for (int j = 0; j < maxRefCount; ++j) {
            anchors.add(String.format("%s%04d", this.endAnchor, j));
        }
        boolean cut = false;
        for (int y = 0; y < spineIdentifiers.size(); ++y) {
            String id = spineIdentifiers.get(y);
            if (!cut) {
                if (!id.equals(cutOffItem)) continue;
                OPFManifestItem manifestItem = opf.getManifestItem(spineIdentifiers.get(y));
                File manifestFile = model.getManifestItemFile(manifestItem);
                cut = true;
                XHTMLCutter cutter = new XHTMLCutter(manifestFile, anchors);
                cutter.cutAtEnd();
                continue;
            }
            if (backCover != null && id.equals(backCover.getId()) || id.equals(opf.getTableOfConentsId()) || fallbackIds.contains(id)) continue;
            model.deleteManifestItem(id, false);
        }
        model.cleanup(threshold, anchors);
        model.saveChanges();
    }

    private void cutCharCount(EPUBModel model) throws IOException, EPUBException {
        OPFDocument opf = model.getOPF();
        EPUBGuide guide = model.getGuide();
        HashSet<String> fallbackIds = new HashSet<String>();
        for (OPFManifestItem manifestItem : opf.getLocalManifestItems()) {
            if (manifestItem.getFallback() == null) continue;
            fallbackIds.add(manifestItem.getFallback());
        }
        opf.cleanup();
        OPFManifestItem backCover = this.getBackCover(model);
        XHTMLAnalyzer analyzer = new XHTMLAnalyzer();
        GuideItem textStart = null;
        List<GuideItem> guideItems = guide.getGuideItems();
        for (GuideItem guideItem : guideItems) {
            String type = guideItem.getType();
            if (!"text".equals(type) && !"bodymatter".equals(type)) continue;
            textStart = guideItem;
            break;
        }
        int spineSkip = 0;
        boolean startFound = false;
        List<String> spineIdentifiers = opf.getXHTMLSpineIdentifiers();
        if (textStart != null) {
            for (int y = 0; y < spineIdentifiers.size(); ++y) {
                String id = spineIdentifiers.get(y);
                OPFManifestItem gItem = opf.getManifestItem(textStart);
                if (gItem != null && id.equalsIgnoreCase(gItem.getId())) {
                    startFound = true;
                    break;
                }
                ++spineSkip;
            }
        } else {
            GuideItem guideItem;
            String type;
            Iterator<GuideItem> i$ = guideItems.iterator();
            while (i$.hasNext() && ("cover".equals(type = (guideItem = i$.next()).getType()) || "frontmatter".equals(type) || "toc".equals(type) || "foreword".equals(type) || "introduction".equals(type) || "dedication".equals(type))) {
                for (int y = spineSkip; y < spineIdentifiers.size(); ++y) {
                    String id = spineIdentifiers.get(y);
                    int newSkip = 0;
                    startFound = false;
                    OPFManifestItem gItem = opf.getManifestItem(guideItem);
                    if (gItem == null || !id.equalsIgnoreCase(gItem.getId())) {
                        ++newSkip;
                        continue;
                    }
                    startFound = true;
                    spineSkip += ++newSkip;
                    break;
                }
                if (startFound) continue;
                break;
            }
        }
        if (!startFound) {
            spineSkip = 0;
        }
        long totalCharCount = 0L;
        HashMap<String, XHTMLAnalysis> analysisMap = new HashMap<String, XHTMLAnalysis>();
        int x = 0;
        for (String id : spineIdentifiers) {
            if (x < spineSkip) {
                ++x;
                continue;
            }
            XHTMLAnalysis analysis = analyzer.analyze(model, id);
            analysisMap.put(id, analysis);
            totalCharCount += analysis.getCharacterCount();
        }
        if (this.delegate != null) {
            this.delegate.previewCutterCalculatedCharCount(this, totalCharCount);
        }
        long charLimit = totalCharCount * (long)this.percentage.intValue() / 100L;
        long runningCharCount = 0L;
        Threshold threshold = null;
        x = 0;
        for (String id : spineIdentifiers) {
            if (x < spineSkip) {
                ++x;
                continue;
            }
            XHTMLAnalysis analysis = (XHTMLAnalysis)analysisMap.get(id);
            if ((runningCharCount += analysis.getCharacterCount()) <= charLimit) continue;
            long numberOfCharsPastLimit = runningCharCount - charLimit;
            long localCharLimit = analysis.getCharacterCount() - numberOfCharsPastLimit;
            threshold = new Threshold(analysis, localCharLimit);
            if (this.delegate == null) break;
            this.delegate.previewCutterFoundCuttoffPointInFile(this, analysis.getFile());
            break;
        }
        if (threshold == null) {
            return;
        }
        int endIndex = spineIdentifiers.size();
        ArrayList<String> anchors = new ArrayList<String>();
        Map<NavDocumentBuilder.NavType, NavDocument> navDocs = model.getNavs();
        int maxRefCount = 1;
        for (NavDocument navDoc : navDocs.values()) {
            maxRefCount = Math.max(maxRefCount, navDoc.getAllPoints().size());
        }
        for (int j = 0; j < maxRefCount; ++j) {
            anchors.add(String.format("%s%04d", this.endAnchor, j));
        }
        if (this.startIndex < spineSkip) {
            this.startIndex = spineSkip;
        }
        for (int i = this.startIndex.intValue(); i < endIndex; ++i) {
            String id = spineIdentifiers.get(i);
            XHTMLAnalysis analysis = (XHTMLAnalysis)analysisMap.get(id);
            File file = analysis.getFile();
            if (charLimit < 1L && analysis != threshold.getAnalysis()) {
                if (backCover != null && id.equals(backCover.getId()) || id.equals(opf.getTableOfConentsId()) || fallbackIds.contains(id)) continue;
                model.deleteManifestItem(id, false);
                continue;
            }
            XHTMLCutter cutter = null;
            long itemCharCount = analysis.getCharacterCount();
            if (i == this.startIndex && itemCharCount >= charLimit) {
                this.getClass();
                long maxCharLimit = totalCharCount * 15L / 100L;
                cutter = new XHTMLCutter(maxCharLimit, file, anchors);
                if (itemCharCount <= maxCharLimit) {
                    cutter.cutAtEnd();
                } else {
                    cutter.cut();
                    this.analyzeProperties(model, analysis);
                }
            } else {
                cutter = new XHTMLCutter(charLimit, file, anchors);
                cutter.cut();
            }
            if (charLimit <= itemCharCount) {
                charLimit = 0L;
                this.analyzeProperties(model, analysis);
                continue;
            }
            charLimit -= itemCharCount;
        }
        model.cleanup(threshold, anchors);
        model.saveChanges();
    }

    private void analyzeProperties(EPUBModel model, XHTMLAnalysis analysis) throws EPUBException {
        OPFManifestItem item = model.getOPF().getManifestItem(analysis.getId());
        if (!item.isXHTML()) {
            return;
        }
        List<String> properties = item.getProperties();
        String newProperties = "";
        boolean propertiesChanged = false;
        for (String property : properties) {
            ItemProperty prop = ItemPropertyFactory.getProperty(property);
            if (prop.shouldHaveProperty(model.getManifestItemFile(item))) {
                newProperties = newProperties + property + " ";
                continue;
            }
            propertiesChanged = true;
        }
        if (propertiesChanged) {
            item.setProperties(newProperties.trim());
        }
    }

    protected void unzip(File tempDir) throws IOException {
        if (this.delegate != null) {
            this.delegate.previewCutterWillOpenInput(this);
        }
        this.unzipper.unzip(this.input, tempDir);
        if (this.delegate != null) {
            this.delegate.previewCutterDidOpenInput(this);
        }
    }

    protected void zip(File tempDir) throws IOException {
        if (this.delegate != null) {
            this.delegate.previewCutterWillCreateOutput(this);
        }
        this.unzipper.zip(tempDir, this.output);
        if (this.delegate != null) {
            this.delegate.previewCutterDidCreateOutput(this);
        }
    }

    public File getInput() {
        return this.input;
    }

    public File getOutput() {
        return this.output;
    }

    private static class Threshold
    implements EPUBPreviewCutterThreshold {
        private XHTMLAnalysis analysis;
        private long localCharLimit;

        private Threshold(XHTMLAnalysis analysis, long localCharLimit) {
            this.analysis = analysis;
            this.localCharLimit = localCharLimit;
        }

        @Override
        public XHTMLAnalysis getAnalysis() {
            return this.analysis;
        }

        @Override
        public long getLocalCharLimit() {
            return this.localCharLimit;
        }
    }
}

