/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.util.CommonsCompressZipUtil;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EPUBNonTextFileStripper {
    private File completeEPubFile;
    private File strippedEPubFolder;
    private File strippedEPubFile;

    public void stripNonTextFiles(File completeEPubFile, File completeEPubFolder, boolean sourceOrPreviewSource) throws IOException, EPUBException {
        int extPos = completeEPubFile.getName().lastIndexOf(46);
        String fileExtension = completeEPubFile.getName().substring(extPos);
        this.strippedEPubFile = File.createTempFile(sourceOrPreviewSource ? "strip.source." : "strip.preview.", fileExtension);
        this.strippedEPubFolder = FileUtilities.createTempDirectory("stripnontextfiles", "snt");
        HashSet<String> stripManifestItemSet = new HashSet<String>();
        EPUBModel model = new EPUBModel(completeEPubFolder);
        OPFDocument opfDocument = model.getOPF();
        List<OPFManifestItem> manifestItems = opfDocument.getLocalManifestItems();
        for (OPFManifestItem manifestItem : manifestItems) {
            String mediaType = manifestItem.getMediaType();
            if (!mediaType.startsWith("audio/") && !mediaType.startsWith("image/") && !mediaType.startsWith("video/")) continue;
            stripManifestItemSet.add(URLDecoder.decode(manifestItem.getHref(), "UTF-8"));
        }
        String opfInUnzipped = model.getOPFFile().getCanonicalPath();
        int opfPathLength = opfInUnzipped.lastIndexOf(47) + 1;
        String completeEPubFolderPath = completeEPubFolder.getCanonicalPath();
        completeEPubFolderPath = completeEPubFolderPath.endsWith("/") ? completeEPubFolderPath : completeEPubFolderPath + "/";
        String strippedEPubFolderPath = this.strippedEPubFolder.getCanonicalPath();
        strippedEPubFolderPath = strippedEPubFolderPath.endsWith("/") ? strippedEPubFolderPath : strippedEPubFolderPath + "/";
        this.copyExcludeNonTextFiles(completeEPubFolder.listFiles(), completeEPubFolderPath, strippedEPubFolderPath, stripManifestItemSet, opfPathLength);
    }

    private void copyExcludeNonTextFiles(File[] fileList, String completeEPubFolderPath, String strippedEPubFolderPath, Set<String> stripManifestItemSet, int opfPathLength) throws IOException, EPUBException {
        if (fileList == null) {
            return;
        }
        for (File file : fileList) {
            String href;
            if (file.isDirectory()) {
                this.copyExcludeNonTextFiles(file.listFiles(), completeEPubFolderPath, strippedEPubFolderPath, stripManifestItemSet, opfPathLength);
                continue;
            }
            String sourceFilePath = file.getCanonicalPath();
            if (sourceFilePath.endsWith("iTunesArtwork")) continue;
            String string = href = sourceFilePath.length() > opfPathLength ? sourceFilePath.substring(opfPathLength) : null;
            if (href != null && stripManifestItemSet.contains(href)) continue;
            String relativePath = sourceFilePath.substring(completeEPubFolderPath.length());
            String destinationFilePath = strippedEPubFolderPath + relativePath;
            FileUtilities.copy(file, new File(destinationFilePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sealThePub() throws IOException {
        try {
            new CommonsCompressZipUtil().zip(this.strippedEPubFolder, this.strippedEPubFile);
        }
        finally {
            this.deleteStrippedEPubFolder();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMetadataAsFile(String metadataXml) throws IOException {
        File metadataFile = new File(this.strippedEPubFolder, "META-INF/com.apple.ibooks.metadata.xml");
        try (BufferedWriter writer = null;){
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(metadataFile), "UTF-8"));
            writer.write(metadataXml);
        }
    }

    public File getStrippedEPubFile() {
        return this.strippedEPubFile;
    }

    private void deleteStrippedEPubFolder() {
        if (this.strippedEPubFolder != null) {
            FileUtilities.deleteRecursively(this.strippedEPubFolder);
            this.strippedEPubFolder = null;
        }
    }

    public void cleanup() {
        if (this.strippedEPubFile != null) {
            if (this.strippedEPubFile.exists()) {
                this.strippedEPubFile.delete();
            }
            this.strippedEPubFile = null;
        }
        this.deleteStrippedEPubFolder();
    }
}

