/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInfoImpl;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidationResult;
import com.apple.itunes.epubtoolkit.EPUBInternalsValidationRule;
import com.apple.itunes.epubtoolkit.InvalidZipFileException;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.util.CommonsCompressZipUtil;
import com.apple.itunes.epubtoolkit.util.EPUBUnzipper;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class EPUBInternalsValidator {
    private File input;
    private List<EPUBInternalsValidationRule> validations;
    private EPUBUnzipper unzipper;
    private EPUBInfo info;

    public EPUBInternalsValidator(File input, EPUBUnzipper unzipper) {
        this.input = input;
        this.validations = new ArrayList<EPUBInternalsValidationRule>();
        this.unzipper = unzipper;
    }

    public EPUBInternalsValidator(EPUBInfo info, File rootDir) {
        this.input = rootDir;
        this.validations = new ArrayList<EPUBInternalsValidationRule>();
        this.info = info;
    }

    public void addRule(EPUBInternalsValidationRule rule) {
        this.validations.add(rule);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<EPUBInternalsValidationResult> execute() throws EPUBException {
        List<EPUBInternalsValidationResult> list;
        block8: {
            if (this.info != null) {
                return this.execute(this.info, this.input);
            }
            File tempDir = null;
            try {
                tempDir = FileUtilities.createTempDirectory(this.input.getName() + ".", "unpacked");
                EPUBInfo localInfo = this.extract(tempDir);
                list = this.execute(localInfo, tempDir);
                if (tempDir == null) break block8;
            }
            catch (EPUBException ep) {
                try {
                    throw ep;
                    catch (IOException ioe) {
                        throw new EPUBException("Unable to extract information from EPUB.  Possible bad ZIP file.", this.input, ioe);
                    }
                    catch (Throwable t) {
                        throw new EPUBException(t.getMessage(), this.input, t);
                    }
                }
                catch (Throwable throwable) {
                    if (tempDir != null) {
                        FileUtilities.deleteRecursively(tempDir);
                    }
                    throw throwable;
                }
            }
            FileUtilities.deleteRecursively(tempDir);
        }
        return list;
    }

    private List<EPUBInternalsValidationResult> execute(EPUBInfo info, File root) throws EPUBException {
        ArrayList<EPUBInternalsValidationResult> results = new ArrayList<EPUBInternalsValidationResult>();
        for (EPUBInternalsValidationRule rule : this.validations) {
            EPUBInternalsValidationResult result = new EPUBInternalsValidationResult(rule);
            for (EPUBInfo.EPUBFile f : info.getFiles()) {
                if (!rule.shouldValidate(root, f)) continue;
                rule.validate(root, f, result);
            }
            results.add(result);
        }
        return results;
    }

    protected EPUBInfo extract(File tempDir) throws EPUBException {
        try {
            if (this.unzipper != null) {
                this.unzipper.unzip(this.input, tempDir);
            } else {
                new CommonsCompressZipUtil().unzip(this.input, tempDir);
            }
        }
        catch (IOException e) {
            throw new InvalidZipFileException("Unable to unzip: " + this.input.getPath(), e);
        }
        EPUBModel model = null;
        try {
            model = new EPUBModel(tempDir);
            OPFDocument opf = model.getOPF();
            opf.cleanup();
        }
        catch (Exception e) {
            throw new EPUBException(e.getMessage() + " [ASSET: " + this.input.getName() + "]", e);
        }
        return new EPUBInfoImpl(model);
    }
}

