/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBInternalsValidationRule;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class EPUBInternalsValidationResult {
    private static final Logger log = Logger.getLogger(EPUBInternalsValidationResult.class);
    private List<String> errors = new ArrayList<String>();
    private List<String> warnings = new ArrayList<String>();
    private List<String> fileNames;
    private EPUBInternalsValidationRule validator;
    private boolean emailableErrorFound;

    public EPUBInternalsValidationResult(EPUBInternalsValidationRule validator) {
        this.validator = validator;
        this.fileNames = new ArrayList<String>();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public List<String> getOffenders() {
        return this.fileNames;
    }

    public boolean ticketsRequired() {
        Boolean ticketsRequired = this.validator.ticketsRequired(this);
        return ticketsRequired == null ? !this.fileNames.isEmpty() : ticketsRequired;
    }

    public boolean isFullePub() {
        return this.validator.isFullePub();
    }

    public String getMessage(boolean formatForEmailComponent) {
        return formatForEmailComponent ? this.getMessageAsFormattedList() : this.getMessage();
    }

    private String getMessage() {
        String result = "";
        if (this.fileNames.isEmpty()) {
            return result;
        }
        for (String name : this.fileNames) {
            result = result + name + ", ";
        }
        if (result.length() > 2) {
            result = result.substring(0, result.length() - 2);
        }
        String prefix = this.validator.isFullePub() ? "Full ePub: " : "Preview ePub: ";
        return this.validator.getMessage() + prefix + result;
    }

    private String getMessageAsFormattedList() {
        String pubType = this.validator.isFullePub() ? "Full ePub: " : "Preview ePub: ";
        String prefix = "<b>" + pubType + "</b>" + "<br/>";
        String result = prefix + "<ul>";
        for (String name : this.fileNames) {
            result = result + "<li>" + name + "</li>";
        }
        return result + "</ul>";
    }

    public void addFile(String fileName) {
        this.fileNames.add(fileName);
    }

    public Integer getCode() {
        return this.validator.getCode();
    }

    public String getTicketType() {
        return this.validator.getType();
    }

    public void log() {
        String message = this.getMessage();
        if (message != null && !message.trim().isEmpty()) {
            log.warn((Object)message);
        }
    }

    public void addError(String error) {
        this.errors.add(error);
    }

    public boolean emailableErrorFound() {
        return this.emailableErrorFound;
    }

    public void setEmailableErrorFound(boolean emailableErrorFound) {
        this.emailableErrorFound = emailableErrorFound;
    }
}

