/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInfoError;
import com.apple.itunes.epubtoolkit.EPUBInfoErrorEnum;
import com.apple.itunes.epubtoolkit.EPUBInfoFileImpl;
import com.apple.itunes.epubtoolkit.XHTMLAnalyzer;
import com.apple.itunes.epubtoolkit.XHTMLImageFinder;
import com.apple.itunes.epubtoolkit.model.AppleDisplayOptionsDocument;
import com.apple.itunes.epubtoolkit.model.ApplePrintableDocument;
import com.apple.itunes.epubtoolkit.model.ContainerDocument;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.EncryptionXml;
import com.apple.itunes.epubtoolkit.model.NCXDocument;
import com.apple.itunes.epubtoolkit.model.NCXNavPoint;
import com.apple.itunes.epubtoolkit.model.NavDocument;
import com.apple.itunes.epubtoolkit.model.NavDocumentBuilder;
import com.apple.itunes.epubtoolkit.model.NavPoint;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.XHTMLAnalysis;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import com.apple.itunes.epubtoolkit.util.NormalizedManifestMap;
import com.apple.itunes.epubtoolkit.util.XMLUtilities;
import com.apple.itunes.epubtoolkit.util.XPathFactory;
import java.io.File;
import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;

public class EPUBInfoImpl
implements EPUBInfo {
    private static final Logger logger = Logger.getLogger(EPUBInfoImpl.class);
    private String mimeType;
    private int rootTagCount;
    private String opfContents;
    public String encryptionXmlContents;
    private String ncxNavContents;
    private String xhtmlNavContents;
    private boolean isSignaturesXmlPresent;
    private boolean isEncryptionXmlPresent;
    private boolean hasPagelist;
    private boolean hasAdobePagemap;
    private long maxSpineItemTotalImageBytes = 0L;
    private boolean hasSpecifiedBackCover;
    private Long wordCount = null;
    private Long characterCount = null;
    private String epubSpecVersion;
    private List<EPUBInfo.EPUBFile> files;
    private int manifestItemCount = 0;
    private boolean hasAllManifestItems = true;
    private int spineItemCount = 0;
    private boolean hasAllSpineItems = true;
    private String firstChapterFile;
    private EPUBInfo.FirstChapterQuality firstChapterQuality;
    private String coverArtFile;
    private String coverArtMimeType;
    private Map<String, Map<String, String>> appleDisplayOptionsMap;
    private Map<String, Boolean> applePrintables;
    private String appleDisplayOptionsContent;
    private String applePrintablesContent;
    private String iBooksAuthorVersion;
    private List<EPUBInfoError> errorList;
    private List<XHTMLAnalysis> xhtmlAnalysisList;
    final Pattern maniPattern = Pattern.compile("/.+?[.]opf|/META-INF/(container|manifest|metadata)[.]xml|/mimetype");

    public EPUBInfoImpl(EPUBModel model) throws EPUBException {
        ApplePrintableDocument apd;
        OPFDocument opf;
        this.errorList = new ArrayList<EPUBInfoError>();
        this.mimeType = model.getMimeType();
        ContainerDocument container = model.getContainer();
        this.rootTagCount = container.getRootFiles().size();
        this.isEncryptionXmlPresent = model.isEncryptionXmlPresent();
        this.isSignaturesXmlPresent = model.isSignaturesXmlPresent();
        EncryptionXml enc = model.getEncryptionXml();
        if (enc != null) {
            this.encryptionXmlContents = XMLUtilities.documentToString(enc.getDocument());
        }
        if ((opf = model.getOPF()).getSpineElement() == null) {
            throw new EPUBException("OPF Document does not contain a spine.");
        }
        Map<NavDocumentBuilder.NavType, NavDocument> navs = model.getNavs();
        if (navs == null || navs.isEmpty()) {
            throw new EPUBException("Nav Document is not present or not referenced in the spine.");
        }
        this.epubSpecVersion = opf.getVersion();
        this.iBooksAuthorVersion = opf.getIbooksAuthorVersion();
        this.ncxNavContents = this.getNavAsString(navs.get((Object)NavDocumentBuilder.NavType.NCX));
        this.xhtmlNavContents = this.getNavAsString(navs.get((Object)NavDocumentBuilder.NavType.XHTML));
        Document opfDocument = opf.getDocument();
        this.opfContents = XMLUtilities.documentToString(opfDocument);
        OPFManifestItem coverItem = opf.getCoverItem();
        this.coverArtFile = coverItem == null ? null : coverItem.getHref();
        this.coverArtMimeType = coverItem == null ? null : coverItem.getMediaType();
        this.hasSpecifiedBackCover = model.getGuide().getBackCoverGuideItem() != null;
        NormalizedManifestMap manifestItemFiles = this.createManifestItemMap(model, opf);
        File root = model.getDirectory();
        this.takeFilesFrom(root, root, manifestItemFiles);
        for (EPUBInfo.EPUBFile file : this.files) {
            if (file.isManifestItem()) {
                ++this.manifestItemCount;
                boolean bl = this.hasAllManifestItems = this.hasAllManifestItems && file.isPresent();
            }
            if (!file.isSpineItem()) continue;
            ++this.spineItemCount;
            this.hasAllSpineItems = this.hasAllSpineItems && file.isPresent();
        }
        NavDocument ncxInEpub = navs.get((Object)NavDocumentBuilder.NavType.NCX);
        if (ncxInEpub != null) {
            if (ncxInEpub instanceof NCXDocument) {
                NCXDocument ncxDocument = (NCXDocument)ncxInEpub;
                this.takeFirstChapterFileFrom(ncxDocument, opf);
            } else {
                OPFManifestItem ncxOPFManifestItem = opf.getTableOfConentsItem();
                String ncxFileName = ncxOPFManifestItem == null ? "NCX_FILE_NAME_NOT_FOUND" : ncxOPFManifestItem.getHref();
                EPUBInfoError errorInfo = new EPUBInfoError(EPUBInfoErrorEnum.NCX_NOT_NCX_DOCUMENT, ncxFileName, "The specified NCX Document: " + ncxFileName + ", is not a valid NCX Document");
                this.addErrorToList(errorInfo);
            }
        } else {
            this.firstChapterQuality = EPUBInfo.FirstChapterQuality.NONE;
        }
        this.hasPagelist = model.getPrimaryNav().getPageList().isEmpty();
        this.hasAdobePagemap = opf.getPageMap() != null;
        AppleDisplayOptionsDocument ado = model.getADO();
        this.appleDisplayOptionsMap = new HashMap<String, Map<String, String>>();
        if (ado != null) {
            List<String> platforms = ado.getPlatforms();
            for (String platform : platforms) {
                this.appleDisplayOptionsMap.put(platform, ado.getOptionsForPlatform(platform));
            }
            this.appleDisplayOptionsContent = XMLUtilities.documentToString(ado.getDocument());
        }
        if ((apd = model.getApplePrintable()) != null) {
            this.applePrintables = apd.getPrintables();
            this.applePrintablesContent = XMLUtilities.documentToString(apd.getDocument());
        }
        XPathFactory xpathFactory = new XPathFactory();
        xpathFactory.addNamespace("xhtml", "http://www.w3.org/1999/xhtml");
        List<String> spineIdentifiers = opf.getSpineIdentifiers();
        XHTMLAnalyzer analyzer = new XHTMLAnalyzer();
        this.xhtmlAnalysisList = new ArrayList<XHTMLAnalysis>();
        this.wordCount = 0L;
        this.characterCount = 0L;
        long totalAnalysisTimeInMillis = 0L;
        for (String id : spineIdentifiers) {
            if (opf.getManifestItem(id) == null || !opf.getManifestItem(id).isXHTML()) continue;
            XHTMLAnalysis analysis = analyzer.analyze(model, id);
            this.xhtmlAnalysisList.add(analysis);
            this.wordCount = this.wordCount + (long)analysis.getWordCount();
            this.characterCount = this.characterCount + analysis.getCharacterCount();
            totalAnalysisTimeInMillis += analysis.getAnalysisTimeInMillis();
            if (analysis.getMissingReferencedFiles().size() <= 0 || this.epubSpecVersion == null || !this.epubSpecVersion.equals("2.0")) continue;
            this.addErrorToList(new EPUBInfoError(EPUBInfoErrorEnum.REFERENCED_FILE_NOT_FOUND, analysis.getFile().getName(), "Referenced resource(s) do not exist: " + analysis.getMissingReferencedFiles()));
        }
        logger.debug((Object)("XHTMLANALYZER_ANALYZE_TOTAL: TotalTimeInSecs:[" + (double)totalAnalysisTimeInMillis / 1000.0 + "], TotalCharacterCount:[" + this.characterCount + "], TotalWordCount:[" + this.wordCount + "]"));
    }

    private String getNavAsString(NavDocument navDoc) {
        if (navDoc != null) {
            Document ncxnavDocument = navDoc.getDocument();
            return XMLUtilities.documentToString(ncxnavDocument);
        }
        return null;
    }

    private NormalizedManifestMap createManifestItemMap(EPUBModel model, OPFDocument opf) throws EPUBException {
        NormalizedManifestMap manifestItemFiles = new NormalizedManifestMap(Normalizer.Form.NFC);
        List<OPFManifestItem> manifestItems = opf.getLocalManifestItems();
        for (OPFManifestItem item : manifestItems) {
            File file = model.getManifestItemFile(item);
            manifestItemFiles.put(file.toPath().normalize().toString(), item);
        }
        return manifestItemFiles;
    }

    private void takeXmlNamespace(EPUBInfoFileImpl currentEntry, File file) {
        try {
            Document document = XMLUtilities.createDocument(file);
            Element rootElement = document.getRootElement();
            String namespaceURI = rootElement == null ? null : rootElement.getNamespaceURI();
            namespaceURI = namespaceURI != null && namespaceURI.trim().length() > 0 ? namespaceURI.trim() : null;
            String doctype = document.getDocType() != null ? document.getDocType().getPublicID() : null;
            currentEntry.setXml(true);
            currentEntry.setNamespace(namespaceURI);
            currentEntry.setDocTypePublicId(doctype);
        }
        catch (Exception e) {
            currentEntry.setXml(false);
            currentEntry.setNamespace(null);
        }
    }

    private void getViewports(EPUBInfoFileImpl currentEntry, File file) throws EPUBException {
        try {
            Document document = XMLUtilities.createDocument(file);
            Element rootElement = document.getRootElement();
            IteratorIterable it = rootElement.getDescendants((Filter)new Filter<Element>(){

                public boolean matches(Object arg0) {
                    if (!(arg0 instanceof Element)) {
                        return false;
                    }
                    Element elem = (Element)arg0;
                    return "meta".equals(elem.getName()) && "viewport".equals(elem.getAttributeValue("name"));
                }

                public Filter<Element> and(Filter<?> filter) {
                    return null;
                }

                public List<Element> filter(List<?> content) {
                    return null;
                }

                public Element filter(Object content) {
                    return null;
                }

                public Filter<?> negate() {
                    return null;
                }

                public Filter<?> or(Filter<?> filter) {
                    return null;
                }

                public <R> Filter<R> refine(Filter<R> filter) {
                    return null;
                }
            });
            if (it.hasNext()) {
                currentEntry.addFileProperty(EPUBInfo.FileProperties.VIEWPORT);
            }
        }
        catch (Exception e) {
            throw new EPUBException("exception encountered while looking for viewports in " + file.getAbsolutePath(), e);
        }
    }

    private void takeFirstChapterFileFrom(NCXDocument ncx, OPFDocument opf) {
        String firstPageHref = opf.getFirstPageHref();
        if (firstPageHref != null) {
            this.firstChapterFile = firstPageHref;
            this.firstChapterQuality = EPUBInfo.FirstChapterQuality.OPF_GUIDE_REFERENCE;
            return;
        }
        String firstChapterNavPointSrc = ncx.getFirstChapterNavPointSrc();
        if (firstChapterNavPointSrc != null) {
            this.firstChapterFile = firstChapterNavPointSrc;
            this.firstChapterQuality = EPUBInfo.FirstChapterQuality.NCX_CHAPTER_CLASS;
            return;
        }
        List<NavPoint> navPoints = ncx.getNavPoints();
        String[] titlePrefixOrder = new String[]{"preface", "prologue", "prolog", "part ", "introduction", "foreword", "chapter ", "dedication", "title page"};
        HashMap<String, EPUBInfo.FirstChapterQuality> prefixQualityMap = new HashMap<String, EPUBInfo.FirstChapterQuality>();
        prefixQualityMap.put("preface", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_PREFACE);
        prefixQualityMap.put("prologue", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_PROLOGUE);
        prefixQualityMap.put("prolog", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_PROLOGUE);
        prefixQualityMap.put("part ", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_PART);
        prefixQualityMap.put("introduction", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_INTRODUCTION);
        prefixQualityMap.put("foreword", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_FOREWORD);
        prefixQualityMap.put("chapter ", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_CHAPTER);
        prefixQualityMap.put("dedication", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_DEDICATION);
        prefixQualityMap.put("title page", EPUBInfo.FirstChapterQuality.NCX_TOC_TITLE_GUESS_TITLEPAGE);
        for (NavPoint point : navPoints) {
            NCXNavPoint ncxPoint = (NCXNavPoint)point;
            String label = ncxPoint.getText();
            if (label == null) continue;
            String lowerCaseLabel = label.toLowerCase();
            for (String prefix : titlePrefixOrder) {
                boolean hasPrefix = lowerCaseLabel.startsWith(prefix);
                if (!hasPrefix) continue;
                this.firstChapterFile = ncxPoint.getURI();
                this.firstChapterQuality = (EPUBInfo.FirstChapterQuality)((Object)prefixQualityMap.get(prefix));
                return;
            }
        }
        this.firstChapterFile = null;
        this.firstChapterQuality = EPUBInfo.FirstChapterQuality.NONE;
    }

    protected void takeFilesFrom(File root, File file, Map<String, OPFManifestItem> manifestItemFiles) throws EPUBException {
        if (this.files == null) {
            this.files = new ArrayList<EPUBInfo.EPUBFile>();
        }
        if (file.isDirectory()) {
            File[] contents;
            if (manifestItemFiles.get(file.getAbsolutePath()) != null) {
                this.addErrorToList(new EPUBInfoError(EPUBInfoErrorEnum.MANIFESTED_DIRECTORY_FOUND, EPUBInfoImpl.getRelativePath(root, file), "Directories should not be declared in manifest:  " + EPUBInfoImpl.getRelativePath(root, file)));
            }
            for (File subFile : contents = file.listFiles()) {
                this.takeFilesFrom(root, subFile, manifestItemFiles);
            }
            return;
        }
        String relativePath = EPUBInfoImpl.getRelativePath(root, file);
        EPUBInfoFileImpl currentEntry = new EPUBInfoFileImpl(relativePath);
        currentEntry.setPresent(true);
        this.takeXmlNamespace(currentEntry, file);
        OPFManifestItem manifestItem = manifestItemFiles.get(file.getAbsolutePath());
        HashMap<String, Long> imageSizes = new HashMap<String, Long>();
        if (manifestItem != null) {
            currentEntry.setManifestItem(true);
            currentEntry.setSpineItem(manifestItem.isSpineItem());
            currentEntry.setMediaType(manifestItem.getMediaType());
            currentEntry.setManifestId(manifestItem.getId());
            if (manifestItem.isVideo() || manifestItem.isAudio()) {
                try {
                    currentEntry.setFtyp(FileUtilities.getFtyp(file));
                }
                catch (IOException e) {
                    throw new EPUBException("Error Parsing file " + relativePath, e);
                }
            }
            if (manifestItem.isSpineItem() && manifestItem.isXHTML()) {
                XHTMLImageFinder imagefinder = new XHTMLImageFinder(file);
                long currentSize = 0L;
                try {
                    List<String> images = imagefinder.images();
                    for (String image : images) {
                        if (imageSizes.containsKey(image)) {
                            currentSize += ((Long)imageSizes.get(image)).longValue();
                            continue;
                        }
                        File imageFile = new File(file.getParentFile(), FileUtilities.decodeURIPath(image));
                        currentSize += imageFile.length();
                        imageSizes.put(image, imageFile.length());
                    }
                }
                catch (EPUBException e) {
                    // empty catch block
                }
                try {
                    this.getViewports(currentEntry, file);
                }
                catch (EPUBException e) {
                    // empty catch block
                }
                if (currentSize > this.maxSpineItemTotalImageBytes) {
                    this.maxSpineItemTotalImageBytes = currentSize;
                }
            }
        } else {
            currentEntry.setManifestItem(false);
        }
        this.files.add(currentEntry);
    }

    protected static String getRelativePath(File root, File file) {
        return file.getAbsolutePath().substring(root.getAbsolutePath().length());
    }

    public String toString() {
        return "EPUBInfoImpl [coverArtFile=" + this.coverArtFile + ", coverArtMimeType=" + this.coverArtMimeType + ", files=" + this.files + ", firstChapterFile=" + this.firstChapterFile + ", firstChapterQuality=" + (Object)((Object)this.firstChapterQuality) + ", hasAllManifestItems=" + this.hasAllManifestItems + ", hasAllSpineItems=" + this.hasAllSpineItems + ", isEncryptionXmlPresent=" + this.isEncryptionXmlPresent + ", isSignaturesXmlPresent=" + this.isSignaturesXmlPresent + ", manifestItemCount=" + this.manifestItemCount + ", mimeType=" + this.mimeType + ", navContents=" + this.ncxNavContents + ", navContents=" + this.xhtmlNavContents + ", opfContents=" + this.opfContents + ", rootTagCount=" + this.rootTagCount + ", spineItemCount=" + this.spineItemCount + "]";
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public int getRootTagCount() {
        return this.rootTagCount;
    }

    @Override
    public boolean isSignaturesXmlPresent() {
        return this.isSignaturesXmlPresent;
    }

    @Override
    public boolean isEncryptionXmlPresent() {
        return this.isEncryptionXmlPresent;
    }

    @Override
    public String getOpfContents() {
        return this.opfContents;
    }

    @Override
    public String getEncryptionXmlContents() {
        return this.encryptionXmlContents;
    }

    @Override
    public String getNCXNavContents() {
        return this.ncxNavContents;
    }

    @Override
    public String getXHTMLNavContents() {
        return this.xhtmlNavContents;
    }

    @Override
    public Collection<EPUBInfo.EPUBFile> getFiles() {
        return this.files;
    }

    @Override
    public int getManifestItemCount() {
        return this.manifestItemCount;
    }

    @Override
    public boolean hasAllManifestItems() {
        return this.hasAllManifestItems;
    }

    @Override
    public int getSpineItemCount() {
        return this.spineItemCount;
    }

    @Override
    public boolean hasAllSpineItems() {
        return this.hasAllSpineItems;
    }

    @Override
    public String getFirstChapterFile() {
        return this.firstChapterFile;
    }

    @Override
    public EPUBInfo.FirstChapterQuality getFirstChapterQuality() {
        return this.firstChapterQuality;
    }

    @Override
    public String getCoverArtFile() {
        return this.coverArtFile;
    }

    @Override
    public String getCoverArtMimeType() {
        return this.coverArtMimeType;
    }

    @Override
    public boolean getHasAdobePagemap() {
        return this.hasAdobePagemap;
    }

    @Override
    public boolean getHasPagelist() {
        return this.hasPagelist;
    }

    @Override
    public long getMaxSpineItemTotalImageBytes() {
        return this.maxSpineItemTotalImageBytes;
    }

    @Override
    public Map<String, Map<String, String>> getAppleDisplayOptions() {
        return this.appleDisplayOptionsMap;
    }

    @Override
    public String getAppleDisplayOptionsContent() {
        return this.appleDisplayOptionsContent;
    }

    @Override
    public boolean getHasSpecifiedBackCover() {
        return this.hasSpecifiedBackCover;
    }

    @Override
    public Map<String, Boolean> getApplePrintables() {
        return this.applePrintables;
    }

    @Override
    public String getApplePrintablesContent() {
        return this.applePrintablesContent;
    }

    @Override
    public Long getWordCount() {
        return this.wordCount;
    }

    @Override
    public Long getCharacterCount() {
        return this.characterCount;
    }

    @Override
    public Long getEstimatedPageCountForFlowingEpub(boolean shouldUseCharacterCountInsteadOfWordCount) {
        if (shouldUseCharacterCountInsteadOfWordCount) {
            return this.characterCount == null ? null : Long.valueOf(this.characterCount / 600L);
        }
        return this.wordCount == null ? null : Long.valueOf(this.wordCount / 250L);
    }

    @Override
    public String getEpubSpecVersion() {
        return this.epubSpecVersion;
    }

    @Override
    public String iBooksAuthorVersion() {
        return this.iBooksAuthorVersion;
    }

    @Override
    public List<String> getUnmanifestedFilePathsForDelete(String excludeUnmanifestedFilesRE) {
        Pattern excludeUnmanifestedFilesPattern = excludeUnmanifestedFilesRE == null ? null : Pattern.compile(excludeUnmanifestedFilesRE);
        ArrayList<String> unmanifestedFilePaths = new ArrayList<String>();
        for (EPUBInfo.EPUBFile file : this.files) {
            String filePath;
            if (file.isManifestItem() || this.maniPattern.matcher(filePath = file.getPath()).matches() || excludeUnmanifestedFilesPattern != null && excludeUnmanifestedFilesPattern.matcher(filePath).matches()) continue;
            unmanifestedFilePaths.add(filePath);
        }
        return unmanifestedFilePaths;
    }

    @Override
    public List<EPUBInfoError> getEPUBInfoErrorList() {
        return this.errorList;
    }

    private void addErrorToList(EPUBInfoError error) {
        this.errorList.add(error);
    }

    @Override
    public List<XHTMLAnalysis> getXhtmlAnalysisList() {
        return this.xhtmlAnalysisList;
    }
}

