/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInfoImpl;
import com.apple.itunes.epubtoolkit.InvalidZipFileException;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.util.CommonsCompressZipUtil;
import com.apple.itunes.epubtoolkit.util.EPUBUnzipper;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class EPUBInfoExtractor {
    private static ThreadLocal<EPUBUnzipper> unzipper = new ThreadLocal<EPUBUnzipper>(){

        @Override
        protected EPUBUnzipper initialValue() {
            return new CommonsCompressZipUtil();
        }
    };
    private File localFile = null;
    private InputStream is = null;

    public EPUBInfoExtractor(File in) {
        this.localFile = in;
    }

    public EPUBInfoExtractor(InputStream is) {
        this.is = is;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public EPUBInfo extract() throws EPUBException {
        EPUBInfo ePUBInfo;
        block7: {
            File tempDir = null;
            try {
                tempDir = FileUtilities.createTempDirectory(System.currentTimeMillis() + ".", "unpacked");
                ePUBInfo = this.extract(tempDir);
                if (tempDir == null) break block7;
            }
            catch (EPUBException ep) {
                try {
                    throw ep;
                    catch (IOException ioe) {
                        throw new EPUBException("Unable to extract information from EPUB.  Possible bad ZIP file.", ioe);
                    }
                    catch (Throwable t) {
                        throw new EPUBException(t.getMessage(), t);
                    }
                }
                catch (Throwable throwable) {
                    if (tempDir != null) {
                        FileUtilities.deleteRecursively(tempDir);
                    }
                    throw throwable;
                }
            }
            FileUtilities.deleteRecursively(tempDir);
        }
        return ePUBInfo;
    }

    private EPUBInfo extract(File tempDir) throws EPUBException {
        try {
            this.unzip(tempDir);
        }
        catch (IOException e) {
            throw new InvalidZipFileException(e.getMessage(), e);
        }
        EPUBModel model = new EPUBModel(tempDir);
        return this.extract(model);
    }

    public EPUBInfo extract(EPUBModel model) throws EPUBException {
        OPFDocument opf = model.getOPF();
        opf.cleanup();
        return new EPUBInfoImpl(model);
    }

    public EPUBModel getModel(File tempDir) throws InvalidZipFileException {
        try {
            this.unzip(tempDir);
        }
        catch (IOException e) {
            throw new InvalidZipFileException(e.getMessage(), e);
        }
        return new EPUBModel(tempDir);
    }

    public EPUBInfo getInfo(EPUBModel model) throws EPUBException {
        return new EPUBInfoImpl(model);
    }

    public static void setUnzipper(final EPUBUnzipper epubUnzipper) {
        unzipper = new ThreadLocal<EPUBUnzipper>(){

            @Override
            protected EPUBUnzipper initialValue() {
                return epubUnzipper;
            }
        };
    }

    private void unzip(File destination) throws IOException {
        if (this.localFile != null) {
            unzipper.get().unzip(this.localFile, destination);
        } else {
            unzipper.get().unzip(this.is, destination);
        }
    }
}

