/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBInfoError;
import com.apple.itunes.epubtoolkit.model.XHTMLAnalysis;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface EPUBInfo {
    public String getMimeType();

    public int getRootTagCount();

    public boolean isSignaturesXmlPresent();

    public boolean isEncryptionXmlPresent();

    public String getOpfContents();

    public String getEncryptionXmlContents();

    public String getNCXNavContents();

    public String getXHTMLNavContents();

    public List<String> getUnmanifestedFilePathsForDelete(String var1);

    public Collection<EPUBFile> getFiles();

    public int getManifestItemCount();

    public boolean hasAllManifestItems();

    public int getSpineItemCount();

    public boolean hasAllSpineItems();

    public long getMaxSpineItemTotalImageBytes();

    public Map<String, Map<String, String>> getAppleDisplayOptions();

    public Map<String, Boolean> getApplePrintables();

    public String getFirstChapterFile();

    public FirstChapterQuality getFirstChapterQuality();

    public String getCoverArtFile();

    public String getCoverArtMimeType();

    public boolean getHasPagelist();

    public boolean getHasAdobePagemap();

    public String getEpubSpecVersion();

    public String iBooksAuthorVersion();

    public String getAppleDisplayOptionsContent();

    public boolean getHasSpecifiedBackCover();

    public String getApplePrintablesContent();

    public Long getWordCount();

    public Long getCharacterCount();

    public Long getEstimatedPageCountForFlowingEpub(boolean var1);

    public List<EPUBInfoError> getEPUBInfoErrorList();

    public List<XHTMLAnalysis> getXhtmlAnalysisList();

    public static enum FileProperties {
        VIEWPORT("viewport");

        private String value;

        private FileProperties(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum FirstChapterQuality {
        NONE,
        NCX_TOC_TITLE_GUESS_PREFACE,
        NCX_TOC_TITLE_GUESS_PROLOGUE,
        NCX_TOC_TITLE_GUESS_PART,
        NCX_TOC_TITLE_GUESS_INTRODUCTION,
        NCX_TOC_TITLE_GUESS_FOREWORD,
        NCX_TOC_TITLE_GUESS_CHAPTER,
        NCX_TOC_TITLE_GUESS_DEDICATION,
        NCX_TOC_TITLE_GUESS_TITLEPAGE,
        NCX_CHAPTER_CLASS,
        OPF_GUIDE_REFERENCE;

    }

    public static interface EPUBFile {
        public String getPath();

        public boolean isManifestItem();

        public boolean isSpineItem();

        public boolean isPresent();

        public boolean isXml();

        public String getNamespace();

        public String getMediaType();

        public String getDocTypePublicId();

        public List<FileProperties> fileProperties();

        public String getFtyp();

        public String getManifestId();
    }
}

