/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBCleaner;
import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.EPUBInfo;
import com.apple.itunes.epubtoolkit.EPUBInfoImpl;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.model.HtmlNavDocument;
import com.apple.itunes.epubtoolkit.model.NavDocument;
import com.apple.itunes.epubtoolkit.model.NavDocumentBuilder;
import com.apple.itunes.epubtoolkit.model.OPFDocument;
import com.apple.itunes.epubtoolkit.model.OPFManifestItem;
import com.apple.itunes.epubtoolkit.model.XHTMLAnalysis;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class EPUBImportCleaner
extends EPUBCleaner {
    private static final Logger logger = Logger.getLogger(EPUBImportCleaner.class);
    private boolean saveChanges = false;
    private static final String defaultPrefixName = "ibooks:";
    private static final String specifiedFonts = "specified-fonts";
    private static final String binding = "binding";
    private boolean shouldAddSpeficiedFonts;
    private boolean shouldAddSpineless;
    private int bodyMatterStartItem = -1;
    private boolean expandEmptyElementsInOpfNcxApplePub;
    private boolean deleteiTunesArtworkAtRoot;
    private boolean detachVersionMetadataElement;

    public EPUBImportCleaner(File input) {
        super(input, null);
    }

    @Override
    public void clean() throws EPUBException {
        String[] files;
        EPUBModel model = new EPUBModel(this.input);
        if (this.expandEmptyElementsInOpfNcxApplePub) {
            this.saveChanges = this.checkForQuickCloseXmlTags(model);
        }
        if (new File(this.input, "iTunesArtwork").exists() && this.deleteiTunesArtworkAtRoot) {
            this.saveChanges = this.cleanupiTunesArtwork(model);
        }
        for (String removeMe : files = this.input.list(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                if (arg1.equalsIgnoreCase("thumbs.db")) {
                    return new File(arg0, arg1).isFile();
                }
                return false;
            }
        })) {
            if (model.getOPF().getManifestItemByHref(removeMe) != null) continue;
            File del = new File(this.input, removeMe);
            del.delete();
        }
        if (this.detachVersionMetadataElement) {
            model.getOPF().detatchVersionElement();
        }
        if (this.shouldAddSpeficiedFonts) {
            this.addSpecifiedFonts(model);
        }
        if (this.shouldAddSpineless) {
            this.addSpineless(model);
        }
        if (this.bodyMatterStartItem > -1) {
            this.addLandmarks(model);
        }
        if (this.saveChanges) {
            model.saveChanges();
        }
    }

    private boolean checkForQuickCloseXmlTags(EPUBModel model) throws EPUBException {
        File opfFile = model.getOPFFile();
        try {
            boolean hasQuickCloseTag = FileUtilities.containsText(model.getOPFFile(), "/>");
            if (hasQuickCloseTag) {
                logger.debug((Object)"EMPTY_ELEMENT_WITH_QUICK_CLOSE_TAG_IN_OPF");
                return true;
            }
        }
        catch (IOException e) {
            throw new EPUBException("Unable to read OPF File: " + opfFile.getPath(), e);
        }
        Map<NavDocumentBuilder.NavType, NavDocument> navDocs = model.getNavs();
        Map<NavDocumentBuilder.NavType, File> navFiles = model.getNavFiles();
        if (navDocs == null || navFiles == null) {
            return false;
        }
        for (NavDocumentBuilder.NavType type : navDocs.keySet()) {
            File navFile = navFiles.get((Object)type);
            if (navFile == null) continue;
            try {
                boolean hasQuickCloseTag = FileUtilities.containsText(navFile, "/>");
                if (!hasQuickCloseTag) continue;
                logger.debug((Object)"EMPTY_ELEMENT_WITH_QUICK_CLOSE_TAG_IN_NCX");
                return true;
            }
            catch (IOException e) {
                throw new EPUBException("Unable to read NavFile: " + navFile.getPath(), e);
            }
        }
        return false;
    }

    private boolean cleanupiTunesArtwork(EPUBModel model) throws EPUBException {
        OPFDocument opfDocument;
        boolean iTunesArtworkReferencedAtRoot = false;
        EPUBInfoImpl epubInfo = new EPUBInfoImpl(model);
        List<XHTMLAnalysis> xhtmlAnalysisList = epubInfo.getXhtmlAnalysisList();
        for (XHTMLAnalysis xhtmlAnalysis : xhtmlAnalysisList) {
            if (!xhtmlAnalysis.hasITunesArtworkHrefAtRoot()) continue;
            iTunesArtworkReferencedAtRoot = true;
            break;
        }
        for (EPUBInfo.EPUBFile e : epubInfo.getFiles()) {
            if (!e.getPath().equals("/iTunesArtwork")) continue;
            iTunesArtworkReferencedAtRoot = true;
            break;
        }
        if (iTunesArtworkReferencedAtRoot && (opfDocument = model.getOPF()) != null) {
            opfDocument.detachiTunesArtworkManifestItem(model.getDirectory(), model.getOPFFile());
            new File(this.input, "iTunesArtwork").delete();
            logger.debug((Object)"DELETE_ITUNESARTWORK_AT_ROOT");
            return true;
        }
        return false;
    }

    private void addLandmarks(EPUBModel model) throws EPUBException {
        Map<NavDocumentBuilder.NavType, NavDocument> navs = model.getNavs();
        if (navs == null) {
            return;
        }
        NavDocument nav = navs.get((Object)NavDocumentBuilder.NavType.XHTML);
        if (nav == null || !(nav instanceof HtmlNavDocument)) {
            return;
        }
        HtmlNavDocument htmlNav = (HtmlNavDocument)nav;
        if (!htmlNav.getLandmarks().isEmpty()) {
            return;
        }
        OPFDocument opf = model.getOPF();
        if (opf == null) {
            return;
        }
        List<String> spines = opf.getSpineIdentifiers();
        if (spines.size() < this.bodyMatterStartItem) {
            if (spines.size() == 0) {
                throw new EPUBException("Not enough spine items to add landmarks....I don't know what to do :(.");
            }
            this.bodyMatterStartItem = spines.size();
        }
        String uri = opf.getManifestItem(spines.get(this.bodyMatterStartItem - 1)).getHref();
        String navId = opf.getXHTMLNavId();
        OPFManifestItem navItem = opf.getManifestItem(navId);
        String navURI = navItem.getHref();
        navURI = FilenameUtils.getPath((String)navURI);
        String[] levels = navURI.split("[/]");
        int subtract = 0;
        for (String level : levels) {
            if (".".equals(level) || "".equals(level)) {
                ++subtract;
                continue;
            }
            if (!"..".equals(level)) continue;
            subtract += 2;
        }
        for (int x = 0; x < levels.length - subtract; ++x) {
            uri = "../" + uri;
        }
        htmlNav.addLandmark("bodymatter", "Main Content", uri);
        this.saveChanges = true;
    }

    private void addSpineless(EPUBModel model) throws EPUBException {
        this.addMetaElement(model, binding, "false");
    }

    private void addSpecifiedFonts(EPUBModel model) throws EPUBException {
        this.addMetaElement(model, specifiedFonts, "true");
    }

    private void addMetaElement(EPUBModel model, String name, String value) throws EPUBException {
        String prop;
        OPFDocument opf = model.getOPF();
        if (opf == null) {
            return;
        }
        String prefix = opf.getPrefix("http://vocabulary.itunes.apple.com/rdf/ibooks/vocabulary-extensions-1.0");
        if (prefix == null) {
            prefix = defaultPrefixName;
            opf.addPrefix(prefix, "http://vocabulary.itunes.apple.com/rdf/ibooks/vocabulary-extensions-1.0");
            this.saveChanges = true;
        }
        if (opf.getMetaElement(prop = prefix + name) == null) {
            opf.addMetaElement(prop, value);
            this.saveChanges = true;
        }
    }

    public void setShouldAddSpeficiedFonts(boolean shouldAddSpeficiedFonts) {
        this.shouldAddSpeficiedFonts = shouldAddSpeficiedFonts;
    }

    public void setShouldAddSpineless(boolean shouldAddSpineless) {
        this.shouldAddSpineless = shouldAddSpineless;
    }

    public void setBodyMatterStartItem(int item) {
        this.bodyMatterStartItem = item;
    }

    public boolean isExpandEmptyElementsInOpfNcxApplePub() {
        return this.expandEmptyElementsInOpfNcxApplePub;
    }

    public void setExpandEmptyElementsInOpfNcxApplePub(boolean expandEmptyElementsInOpfNcxApplePub) {
        this.expandEmptyElementsInOpfNcxApplePub = expandEmptyElementsInOpfNcxApplePub;
    }

    public boolean isDeleteiTunesArtworkAtRoot() {
        return this.deleteiTunesArtworkAtRoot;
    }

    public void setDeleteiTunesArtworkAtRoot(boolean deleteiTunesArtworkAtRoot) {
        this.deleteiTunesArtworkAtRoot = deleteiTunesArtworkAtRoot;
    }

    public void setDetachVersionMetadataElement(boolean detachVersionMetadataElement) {
        this.detachVersionMetadataElement = detachVersionMetadataElement;
    }
}

