/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import java.io.File;

public class EPUBException
extends Exception {
    private static final long serialVersionUID = 3360320505808871553L;
    public static final int EC_NONE = 0;
    public static final int EC_INVALID_XML_CHAR = 1;
    private int errorCode;
    private int lineNumber;
    private String fileName;

    public EPUBException(Throwable cause) {
        super(cause);
    }

    public EPUBException(String message, Throwable cause) {
        super(message, cause);
    }

    public EPUBException(String message) {
        super(message);
    }

    public EPUBException(int errorCode, String errorMessage, int lineNumber, String fileName, Throwable cause) {
        super(errorMessage, cause);
        this.errorCode = errorCode;
        this.lineNumber = lineNumber;
        this.fileName = fileName;
    }

    public EPUBException(String message, File epubFile) {
        super(message + " [file: " + (epubFile == null ? "null" : epubFile.getName()) + "]");
        if (epubFile != null) {
            this.fileName = epubFile.getName();
        }
    }

    public EPUBException(String message, File epubFile, Throwable cause) {
        super(message + " [file: " + (epubFile == null ? "null" : epubFile.getName()) + "]", cause);
        if (epubFile != null) {
            this.fileName = epubFile.getName();
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }
}

