/*
 * Decompiled with CFR 0.152.
 */
package com.apple.itunes.epubtoolkit;

import com.apple.itunes.epubtoolkit.EPUBException;
import com.apple.itunes.epubtoolkit.model.EPUBModel;
import com.apple.itunes.epubtoolkit.util.CommonsCompressZipUtil;
import com.apple.itunes.epubtoolkit.util.FileUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class EPUBCleaner {
    protected File input;
    protected File output;

    public EPUBCleaner(File input, File output) {
        this.input = input;
        this.output = output;
    }

    public void clean() throws IOException, EPUBException {
        this.clean(false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(boolean deleteUnmanifestedFiles, String excludeUnmanifestedFilesRE) throws IOException, EPUBException {
        File tempDir = FileUtilities.createTempDirectory(this.input.getName() + ".", "unpacked");
        try {
            this.unzip(tempDir);
            this.clean(tempDir, deleteUnmanifestedFiles, excludeUnmanifestedFilesRE);
            this.zip(tempDir);
        }
        finally {
            FileUtilities.deleteRecursively(tempDir);
        }
    }

    protected void clean(File tempDir) throws EPUBException {
        this.clean(tempDir, false, null);
    }

    protected void clean(File tempDir, boolean deleteUnmanifestedFiles, String excludeUnmanifestedFilesRE) throws EPUBException {
        EPUBModel model = new EPUBModel(tempDir);
        model.cleanup(null, null, deleteUnmanifestedFiles, excludeUnmanifestedFilesRE);
        model.saveChanges();
    }

    protected void runXmlLint(File input, File output) throws EPUBException {
        int exitCode;
        Process process;
        Runtime runtime = Runtime.getRuntime();
        String[] commandPlusArgs = new String[]{"xmllint", "--noent", "--recover", "--xmlout", "-o", output.getAbsolutePath(), input.getAbsolutePath()};
        try {
            process = runtime.exec(commandPlusArgs);
        }
        catch (IOException ex) {
            throw new EPUBException("Cannot start xmlint on " + input.getName(), ex);
        }
        StreamConsumer out = new StreamConsumer(process.getInputStream(), System.out);
        Thread outThread = new Thread(out);
        outThread.start();
        StreamConsumer err = new StreamConsumer(process.getErrorStream(), System.err);
        Thread errThread = new Thread(err);
        errThread.start();
        try {
            exitCode = process.waitFor();
        }
        catch (InterruptedException ex) {
            throw new EPUBException("Caught interruption when running xmllint on " + input.getName(), ex);
        }
        if (exitCode != 0) {
            throw new EPUBException("Got error exit code " + exitCode + " from xmllint on " + input.getName());
        }
        out.setIsEnabled(false);
        err.setIsEnabled(false);
    }

    protected void unzip(File tempDir) throws IOException {
        new CommonsCompressZipUtil().unzip(this.input, tempDir);
    }

    protected void zip(File tempDir) throws IOException {
        new CommonsCompressZipUtil().zip(tempDir, this.output);
    }

    private static class StreamConsumer
    implements Runnable {
        private InputStream input;
        private PrintStream out;
        private boolean isEnabled;

        public StreamConsumer(InputStream input, PrintStream out) {
            this.input = input;
            this.out = out;
            this.isEnabled = true;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.input));
            try {
                String line = reader.readLine();
                while (this.isEnabled && line != null) {
                    this.out.println(line);
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void setIsEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
        }
    }
}

