/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.thirdparty.bytebuddy.matcher;

import com.webobjects.thirdparty.bytebuddy.matcher.ElementMatcher;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class StringMatcher
extends ElementMatcher.Junction.AbstractBase<String> {
    private final String value;
    private final Mode mode;

    public StringMatcher(String value, Mode mode) {
        this.value = value;
        this.mode = mode;
    }

    @Override
    public boolean matches(String target) {
        return this.mode.matches(this.value, target);
    }

    public String toString() {
        return this.mode.getDescription() + '(' + this.value + ')';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringMatcher)) {
            return false;
        }
        StringMatcher other = (StringMatcher)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$value = this.value;
        String other$value = other.value;
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Mode this$mode = this.mode;
        Mode other$mode = other.mode;
        return !(this$mode == null ? other$mode != null : !((Object)((Object)this$mode)).equals((Object)other$mode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StringMatcher;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Mode $mode = this.mode;
        result = result * 59 + ($mode == null ? 43 : ((Object)((Object)$mode)).hashCode());
        return result;
    }

    public static enum Mode {
        EQUALS_FULLY("equals"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.equals(expected);
            }
        }
        ,
        EQUALS_FULLY_IGNORE_CASE("equalsIgnoreCase"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.equalsIgnoreCase(expected);
            }
        }
        ,
        STARTS_WITH("startsWith"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.startsWith(expected);
            }
        }
        ,
        STARTS_WITH_IGNORE_CASE("startsWithIgnoreCase"){

            @Override
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale")
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().startsWith(expected.toLowerCase());
            }
        }
        ,
        ENDS_WITH("endsWith"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.endsWith(expected);
            }
        }
        ,
        ENDS_WITH_IGNORE_CASE("endsWithIgnoreCase"){

            @Override
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale")
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().endsWith(expected.toLowerCase());
            }
        }
        ,
        CONTAINS("contains"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.contains(expected);
            }
        }
        ,
        CONTAINS_IGNORE_CASE("containsIgnoreCase"){

            @Override
            @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="Both strings are transformed by the default locale")
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().contains(expected.toLowerCase());
            }
        }
        ,
        MATCHES("matches"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.matches(expected);
            }
        };

        private final String description;

        private Mode(String description) {
            this.description = description;
        }

        protected String getDescription() {
            return this.description;
        }

        protected abstract boolean matches(String var1, String var2);
    }
}

