/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.thirdparty.bytebuddy.implementation.bytecode.constant;

import com.webobjects.thirdparty.asm.MethodVisitor;
import com.webobjects.thirdparty.asm.Type;
import com.webobjects.thirdparty.bytebuddy.ClassFileVersion;
import com.webobjects.thirdparty.bytebuddy.description.type.TypeDescription;
import com.webobjects.thirdparty.bytebuddy.implementation.Implementation;
import com.webobjects.thirdparty.bytebuddy.implementation.bytecode.StackManipulation;
import com.webobjects.thirdparty.bytebuddy.implementation.bytecode.StackSize;

public enum ClassConstant implements StackManipulation
{
    VOID(Void.class),
    BOOLEAN(Boolean.class),
    BYTE(Byte.class),
    SHORT(Short.class),
    CHARACTER(Character.class),
    INTEGER(Integer.class),
    LONG(Long.class),
    FLOAT(Float.class),
    DOUBLE(Double.class);

    private static final StackManipulation.Size SIZE;
    private static final String PRIMITIVE_TYPE_FIELD = "TYPE";
    private static final String CLASS_TYPE_INTERNAL_NAME = "Ljava/lang/Class;";
    private final String fieldOwnerInternalName;

    private ClassConstant(Class<?> type) {
        this.fieldOwnerInternalName = Type.getInternalName(type);
    }

    public static StackManipulation of(TypeDescription typeDescription) {
        if (typeDescription.represents(Void.TYPE)) {
            return VOID;
        }
        if (typeDescription.represents(Boolean.TYPE)) {
            return BOOLEAN;
        }
        if (typeDescription.represents(Byte.TYPE)) {
            return BYTE;
        }
        if (typeDescription.represents(Short.TYPE)) {
            return SHORT;
        }
        if (typeDescription.represents(Character.TYPE)) {
            return CHARACTER;
        }
        if (typeDescription.represents(Integer.TYPE)) {
            return INTEGER;
        }
        if (typeDescription.represents(Long.TYPE)) {
            return LONG;
        }
        if (typeDescription.represents(Float.TYPE)) {
            return FLOAT;
        }
        if (typeDescription.represents(Double.TYPE)) {
            return DOUBLE;
        }
        return new ForReferenceType(typeDescription);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitFieldInsn(178, this.fieldOwnerInternalName, PRIMITIVE_TYPE_FIELD, CLASS_TYPE_INTERNAL_NAME);
        return SIZE;
    }

    static {
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    protected static class ForReferenceType
    implements StackManipulation {
        private final TypeDescription typeDescription;

        protected ForReferenceType(TypeDescription typeDescription) {
            this.typeDescription = typeDescription;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            if (implementationContext.getClassFileVersion().isAtLeast(ClassFileVersion.JAVA_V5) && this.typeDescription.isVisibleTo(implementationContext.getInstrumentedType())) {
                methodVisitor.visitLdcInsn(Type.getType(this.typeDescription.getDescriptor()));
            } else {
                methodVisitor.visitLdcInsn(this.typeDescription.getName());
                methodVisitor.visitMethodInsn(184, "java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;", false);
            }
            return SIZE;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForReferenceType)) {
                return false;
            }
            ForReferenceType other = (ForReferenceType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TypeDescription this$typeDescription = this.typeDescription;
            TypeDescription other$typeDescription = other.typeDescription;
            return !(this$typeDescription == null ? other$typeDescription != null : !this$typeDescription.equals(other$typeDescription));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForReferenceType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeDescription $typeDescription = this.typeDescription;
            result = result * 59 + ($typeDescription == null ? 43 : $typeDescription.hashCode());
            return result;
        }
    }
}

