/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.thirdparty.bytebuddy.implementation.attribute;

import com.webobjects.thirdparty.asm.MethodVisitor;
import com.webobjects.thirdparty.bytebuddy.description.annotation.AnnotationDescription;
import com.webobjects.thirdparty.bytebuddy.description.annotation.AnnotationList;
import com.webobjects.thirdparty.bytebuddy.description.method.MethodDescription;
import com.webobjects.thirdparty.bytebuddy.description.method.ParameterDescription;
import com.webobjects.thirdparty.bytebuddy.description.method.ParameterList;
import com.webobjects.thirdparty.bytebuddy.description.type.TypeDescription;
import com.webobjects.thirdparty.bytebuddy.implementation.attribute.AnnotationAppender;
import com.webobjects.thirdparty.bytebuddy.implementation.attribute.AnnotationValueFilter;
import com.webobjects.thirdparty.bytebuddy.matcher.ElementMatchers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface MethodAttributeAppender {
    public void apply(MethodVisitor var1, MethodDescription var2, AnnotationValueFilter var3);

    public static class Compound
    implements MethodAttributeAppender {
        private final List<MethodAttributeAppender> methodAttributeAppenders = new ArrayList<MethodAttributeAppender>();

        public Compound(MethodAttributeAppender ... methodAttributeAppender) {
            this(Arrays.asList(methodAttributeAppender));
        }

        public Compound(List<? extends MethodAttributeAppender> methodAttributeAppenders) {
            for (MethodAttributeAppender methodAttributeAppender : methodAttributeAppenders) {
                if (methodAttributeAppender instanceof Compound) {
                    this.methodAttributeAppenders.addAll(((Compound)methodAttributeAppender).methodAttributeAppenders);
                    continue;
                }
                if (methodAttributeAppender instanceof NoOp) continue;
                this.methodAttributeAppenders.add(methodAttributeAppender);
            }
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            for (MethodAttributeAppender methodAttributeAppender : this.methodAttributeAppenders) {
                methodAttributeAppender.apply(methodVisitor, methodDescription, annotationValueFilter);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Compound)) {
                return false;
            }
            Compound other = (Compound)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<MethodAttributeAppender> this$methodAttributeAppenders = this.methodAttributeAppenders;
            List<MethodAttributeAppender> other$methodAttributeAppenders = other.methodAttributeAppenders;
            return !(this$methodAttributeAppenders == null ? other$methodAttributeAppenders != null : !((Object)this$methodAttributeAppenders).equals(other$methodAttributeAppenders));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Compound;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<MethodAttributeAppender> $methodAttributeAppenders = this.methodAttributeAppenders;
            result = result * 59 + ($methodAttributeAppenders == null ? 43 : ((Object)$methodAttributeAppenders).hashCode());
            return result;
        }
    }

    public static class ForReceiverType
    implements MethodAttributeAppender,
    Factory {
        private final TypeDescription.Generic receiverType;

        public ForReceiverType(TypeDescription.Generic receiverType) {
            this.receiverType = receiverType;
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            this.receiverType.accept(AnnotationAppender.ForTypeAnnotations.ofReceiverType(new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor)), annotationValueFilter));
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForReceiverType)) {
                return false;
            }
            ForReceiverType other = (ForReceiverType)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TypeDescription.Generic this$receiverType = this.receiverType;
            TypeDescription.Generic other$receiverType = other.receiverType;
            return !(this$receiverType == null ? other$receiverType != null : !this$receiverType.equals(other$receiverType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForReceiverType;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TypeDescription.Generic $receiverType = this.receiverType;
            result = result * 59 + ($receiverType == null ? 43 : $receiverType.hashCode());
            return result;
        }
    }

    public static class Explicit
    implements MethodAttributeAppender,
    Factory {
        private final Target target;
        private final List<? extends AnnotationDescription> annotations;

        public Explicit(int parameterIndex, List<? extends AnnotationDescription> annotations) {
            this(new Target.OnMethodParameter(parameterIndex), annotations);
        }

        public Explicit(List<? extends AnnotationDescription> annotations) {
            this(Target.OnMethod.INSTANCE, annotations);
        }

        protected Explicit(Target target, List<? extends AnnotationDescription> annotations) {
            this.target = target;
            this.annotations = annotations;
        }

        public static Factory of(MethodDescription methodDescription) {
            ParameterList<?> parameters = methodDescription.getParameters();
            ArrayList<Explicit> methodAttributeAppenders = new ArrayList<Explicit>(parameters.size() + 1);
            methodAttributeAppenders.add(new Explicit(methodDescription.getDeclaredAnnotations()));
            for (ParameterDescription parameter : parameters) {
                methodAttributeAppenders.add(new Explicit(parameter.getIndex(), (List<? extends AnnotationDescription>)parameter.getDeclaredAnnotations()));
            }
            return new Factory.Compound(methodAttributeAppenders);
        }

        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender appender = new AnnotationAppender.Default(this.target.make(methodVisitor, methodDescription));
            for (AnnotationDescription annotationDescription : this.annotations) {
                appender = appender.append(annotationDescription, annotationValueFilter);
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Explicit)) {
                return false;
            }
            Explicit other = (Explicit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Target this$target = this.target;
            Target other$target = other.target;
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            List<? extends AnnotationDescription> this$annotations = this.annotations;
            List<? extends AnnotationDescription> other$annotations = other.annotations;
            return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Explicit;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Target $target = this.target;
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            List<? extends AnnotationDescription> $annotations = this.annotations;
            result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
            return result;
        }

        protected static interface Target {
            public AnnotationAppender.Target make(MethodVisitor var1, MethodDescription var2);

            public static class OnMethodParameter
            implements Target {
                private final int parameterIndex;

                protected OnMethodParameter(int parameterIndex) {
                    this.parameterIndex = parameterIndex;
                }

                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    if (this.parameterIndex >= methodDescription.getParameters().size()) {
                        throw new IllegalArgumentException("Method " + methodDescription + " has less then " + this.parameterIndex + " parameters");
                    }
                    return new AnnotationAppender.Target.OnMethodParameter(methodVisitor, this.parameterIndex);
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OnMethodParameter)) {
                        return false;
                    }
                    OnMethodParameter other = (OnMethodParameter)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    return this.parameterIndex == other.parameterIndex;
                }

                protected boolean canEqual(Object other) {
                    return other instanceof OnMethodParameter;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    result = result * 59 + this.parameterIndex;
                    return result;
                }
            }

            public static enum OnMethod implements Target
            {
                INSTANCE;


                @Override
                public AnnotationAppender.Target make(MethodVisitor methodVisitor, MethodDescription methodDescription) {
                    return new AnnotationAppender.Target.OnMethod(methodVisitor);
                }
            }
        }
    }

    public static enum ForInstrumentedMethod implements MethodAttributeAppender,
    Factory
    {
        EXCLUDING_RECEIVER{

            @Override
            protected AnnotationAppender appendReceiver(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, MethodDescription methodDescription) {
                return annotationAppender;
            }
        }
        ,
        INCLUDING_RECEIVER{

            @Override
            protected AnnotationAppender appendReceiver(AnnotationAppender annotationAppender, AnnotationValueFilter annotationValueFilter, MethodDescription methodDescription) {
                TypeDescription.Generic receiverType = methodDescription.getReceiverType();
                return receiverType == null ? annotationAppender : receiverType.accept(AnnotationAppender.ForTypeAnnotations.ofReceiverType(annotationAppender, annotationValueFilter));
            }
        };


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
            AnnotationAppender annotationAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethod(methodVisitor));
            annotationAppender = methodDescription.getReturnType().accept(AnnotationAppender.ForTypeAnnotations.ofMethodReturnType(annotationAppender, annotationValueFilter));
            annotationAppender = AnnotationAppender.ForTypeAnnotations.ofTypeVariable(annotationAppender, annotationValueFilter, false, methodDescription.getTypeVariables());
            for (AnnotationDescription annotation : (AnnotationList)methodDescription.getDeclaredAnnotations().filter(ElementMatchers.not(ElementMatchers.annotationType(ElementMatchers.nameStartsWith("jdk.internal."))))) {
                annotationAppender = annotationAppender.append(annotation, annotationValueFilter);
            }
            for (ParameterDescription parameterDescription : methodDescription.getParameters()) {
                AnnotationAppender parameterAppender = new AnnotationAppender.Default(new AnnotationAppender.Target.OnMethodParameter(methodVisitor, parameterDescription.getIndex()));
                parameterAppender = parameterDescription.getType().accept(AnnotationAppender.ForTypeAnnotations.ofMethodParameterType(parameterAppender, annotationValueFilter, parameterDescription.getIndex()));
                for (AnnotationDescription annotation : parameterDescription.getDeclaredAnnotations()) {
                    parameterAppender = parameterAppender.append(annotation, annotationValueFilter);
                }
            }
            annotationAppender = this.appendReceiver(annotationAppender, annotationValueFilter, methodDescription);
            int exceptionTypeIndex = 0;
            for (TypeDescription.Generic exceptionType : methodDescription.getExceptionTypes()) {
                annotationAppender = exceptionType.accept(AnnotationAppender.ForTypeAnnotations.ofExceptionType(annotationAppender, annotationValueFilter, exceptionTypeIndex++));
            }
        }

        protected abstract AnnotationAppender appendReceiver(AnnotationAppender var1, AnnotationValueFilter var2, MethodDescription var3);
    }

    public static interface Factory {
        public MethodAttributeAppender make(TypeDescription var1);

        public static class Compound
        implements Factory {
            private final List<Factory> factories = new ArrayList<Factory>();

            public Compound(Factory ... factory) {
                this(Arrays.asList(factory));
            }

            public Compound(List<? extends Factory> factories) {
                for (Factory factory : factories) {
                    if (factory instanceof Compound) {
                        this.factories.addAll(((Compound)factory).factories);
                        continue;
                    }
                    if (factory instanceof NoOp) continue;
                    this.factories.add(factory);
                }
            }

            @Override
            public MethodAttributeAppender make(TypeDescription typeDescription) {
                ArrayList<MethodAttributeAppender> methodAttributeAppenders = new ArrayList<MethodAttributeAppender>(this.factories.size());
                for (Factory factory : this.factories) {
                    methodAttributeAppenders.add(factory.make(typeDescription));
                }
                return new com.webobjects.thirdparty.bytebuddy.implementation.attribute.MethodAttributeAppender$Compound(methodAttributeAppenders);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Compound)) {
                    return false;
                }
                Compound other = (Compound)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                List<Factory> this$factories = this.factories;
                List<Factory> other$factories = other.factories;
                return !(this$factories == null ? other$factories != null : !((Object)this$factories).equals(other$factories));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Compound;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                List<Factory> $factories = this.factories;
                result = result * 59 + ($factories == null ? 43 : ((Object)$factories).hashCode());
                return result;
            }
        }
    }

    public static enum NoOp implements MethodAttributeAppender,
    Factory
    {
        INSTANCE;


        @Override
        public MethodAttributeAppender make(TypeDescription typeDescription) {
            return this;
        }

        @Override
        public void apply(MethodVisitor methodVisitor, MethodDescription methodDescription, AnnotationValueFilter annotationValueFilter) {
        }
    }
}

