/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.thirdparty.bytebuddy.dynamic;

import com.webobjects.thirdparty.bytebuddy.description.type.TypeDescription;
import com.webobjects.thirdparty.bytebuddy.dynamic.DynamicType;
import com.webobjects.thirdparty.bytebuddy.matcher.ElementMatchers;
import com.webobjects.thirdparty.bytebuddy.utility.JavaModule;
import com.webobjects.thirdparty.bytebuddy.utility.JavaType;
import com.webobjects.thirdparty.bytebuddy.utility.StreamDrainer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public interface ClassFileLocator
extends Closeable {
    public static final String CLASS_FILE_EXTENSION = ".class";

    public Resolution locate(String var1) throws IOException;

    public static class Compound
    implements ClassFileLocator,
    Closeable {
        private final List<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();

        public Compound(ClassFileLocator ... classFileLocator) {
            this(Arrays.asList(classFileLocator));
        }

        public Compound(List<? extends ClassFileLocator> classFileLocators) {
            for (ClassFileLocator classFileLocator : classFileLocators) {
                if (classFileLocator instanceof Compound) {
                    this.classFileLocators.addAll(((Compound)classFileLocator).classFileLocators);
                    continue;
                }
                if (classFileLocator instanceof NoOp) continue;
                this.classFileLocators.add(classFileLocator);
            }
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocators) {
                Resolution resolution = classFileLocator.locate(typeName);
                if (!resolution.isResolved()) continue;
                return resolution;
            }
            return new Resolution.Illegal(typeName);
        }

        @Override
        public void close() throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocators) {
                classFileLocator.close();
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Compound)) {
                return false;
            }
            Compound other = (Compound)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<ClassFileLocator> this$classFileLocators = this.classFileLocators;
            List<ClassFileLocator> other$classFileLocators = other.classFileLocators;
            return !(this$classFileLocators == null ? other$classFileLocators != null : !((Object)this$classFileLocators).equals(other$classFileLocators));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Compound;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<ClassFileLocator> $classFileLocators = this.classFileLocators;
            result = result * 59 + ($classFileLocators == null ? 43 : ((Object)$classFileLocators).hashCode());
            return result;
        }
    }

    public static class PackageDiscriminating
    implements ClassFileLocator {
        private final Map<String, ClassFileLocator> classFileLocators;

        public PackageDiscriminating(Map<String, ClassFileLocator> classFileLocators) {
            this.classFileLocators = classFileLocators;
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            int packageIndex = typeName.lastIndexOf(46);
            ClassFileLocator classFileLocator = this.classFileLocators.get(packageIndex == -1 ? "" : typeName.substring(0, packageIndex));
            return classFileLocator == null ? new Resolution.Illegal(typeName) : classFileLocator.locate(typeName);
        }

        @Override
        public void close() throws IOException {
            for (ClassFileLocator classFileLocator : this.classFileLocators.values()) {
                classFileLocator.close();
            }
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackageDiscriminating)) {
                return false;
            }
            PackageDiscriminating other = (PackageDiscriminating)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, ClassFileLocator> this$classFileLocators = this.classFileLocators;
            Map<String, ClassFileLocator> other$classFileLocators = other.classFileLocators;
            return !(this$classFileLocators == null ? other$classFileLocators != null : !((Object)this$classFileLocators).equals(other$classFileLocators));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PackageDiscriminating;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, ClassFileLocator> $classFileLocators = this.classFileLocators;
            result = result * 59 + ($classFileLocators == null ? 43 : ((Object)$classFileLocators).hashCode());
            return result;
        }
    }

    public static class AgentBased
    implements ClassFileLocator {
        private static final String INSTALLER_TYPE = "com.webobjects.thirdparty.bytebuddy.agent.Installer";
        private static final String INSTRUMENTATION_GETTER = "getInstrumentation";
        private static final Object STATIC_MEMBER = null;
        private final Instrumentation instrumentation;
        private final ClassLoadingDelegate classLoadingDelegate;

        public AgentBased(Instrumentation instrumentation, ClassLoader classLoader) {
            this(instrumentation, ClassLoadingDelegate.Default.of(classLoader));
        }

        public AgentBased(Instrumentation instrumentation, ClassLoadingDelegate classLoadingDelegate) {
            if (!instrumentation.isRetransformClassesSupported()) {
                throw new IllegalArgumentException(instrumentation + " does not support retransformation");
            }
            this.instrumentation = instrumentation;
            this.classLoadingDelegate = classLoadingDelegate;
        }

        public static ClassFileLocator fromInstalledAgent(ClassLoader classLoader) {
            try {
                return new AgentBased((Instrumentation)ClassLoader.getSystemClassLoader().loadClass(INSTALLER_TYPE).getMethod(INSTRUMENTATION_GETTER, new Class[0]).invoke(STATIC_MEMBER, new Object[0]), classLoader);
            }
            catch (RuntimeException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new IllegalStateException("The Byte Buddy agent is not installed or not accessible", exception);
            }
        }

        public static ClassFileLocator of(Instrumentation instrumentation, Class<?> type) {
            return new AgentBased(instrumentation, ClassLoadingDelegate.Explicit.of(type));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) {
            Resolution resolution;
            ExtractionClassFileTransformer classFileTransformer = new ExtractionClassFileTransformer(this.classLoadingDelegate.getClassLoader(), typeName);
            this.instrumentation.addTransformer(classFileTransformer, true);
            try {
                this.instrumentation.retransformClasses(this.classLoadingDelegate.locate(typeName));
                byte[] binaryRepresentation = classFileTransformer.getBinaryRepresentation();
                resolution = binaryRepresentation == null ? new Resolution.Illegal(typeName) : new Resolution.Explicit(binaryRepresentation);
                this.instrumentation.removeTransformer(classFileTransformer);
            }
            catch (Throwable throwable) {
                try {
                    this.instrumentation.removeTransformer(classFileTransformer);
                    throw throwable;
                }
                catch (RuntimeException exception) {
                    throw exception;
                }
                catch (Exception ignored) {
                    return new Resolution.Illegal(typeName);
                }
            }
            return resolution;
        }

        @Override
        public void close() throws IOException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AgentBased)) {
                return false;
            }
            AgentBased other = (AgentBased)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Instrumentation this$instrumentation = this.instrumentation;
            Instrumentation other$instrumentation = other.instrumentation;
            if (this$instrumentation == null ? other$instrumentation != null : !this$instrumentation.equals(other$instrumentation)) {
                return false;
            }
            ClassLoadingDelegate this$classLoadingDelegate = this.classLoadingDelegate;
            ClassLoadingDelegate other$classLoadingDelegate = other.classLoadingDelegate;
            return !(this$classLoadingDelegate == null ? other$classLoadingDelegate != null : !this$classLoadingDelegate.equals(other$classLoadingDelegate));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AgentBased;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Instrumentation $instrumentation = this.instrumentation;
            result = result * 59 + ($instrumentation == null ? 43 : $instrumentation.hashCode());
            ClassLoadingDelegate $classLoadingDelegate = this.classLoadingDelegate;
            result = result * 59 + ($classLoadingDelegate == null ? 43 : $classLoadingDelegate.hashCode());
            return result;
        }

        protected static class ExtractionClassFileTransformer
        implements ClassFileTransformer {
            private static final byte[] DO_NOT_TRANSFORM = null;
            private final ClassLoader classLoader;
            private final String typeName;
            @SuppressFBWarnings(value={"VO_VOLATILE_REFERENCE_TO_ARRAY"}, justification="The array is not to be modified by contract")
            private volatile byte[] binaryRepresentation;

            protected ExtractionClassFileTransformer(ClassLoader classLoader, String typeName) {
                this.classLoader = classLoader;
                this.typeName = typeName;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP", "EI_EXPOSE_REP2"}, justification="The array is not to be modified by contract")
            public byte[] transform(ClassLoader classLoader, String internalName, Class<?> redefinedType, ProtectionDomain protectionDomain, byte[] binaryRepresentation) {
                if (internalName != null && ElementMatchers.isChildOf(this.classLoader).matches(classLoader) && this.typeName.equals(internalName.replace('/', '.'))) {
                    this.binaryRepresentation = (byte[])binaryRepresentation.clone();
                }
                return DO_NOT_TRANSFORM;
            }

            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The array is not to be modified by contract")
            protected byte[] getBinaryRepresentation() {
                return this.binaryRepresentation;
            }
        }

        public static interface ClassLoadingDelegate {
            public Class<?> locate(String var1) throws ClassNotFoundException;

            public ClassLoader getClassLoader();

            public static class Explicit
            implements ClassLoadingDelegate {
                private final ClassLoadingDelegate fallbackDelegate;
                private final Map<String, Class<?>> types;

                public Explicit(ClassLoader classLoader, Collection<? extends Class<?>> types) {
                    this(Default.of(classLoader), types);
                }

                public Explicit(ClassLoadingDelegate fallbackDelegate, Collection<? extends Class<?>> types) {
                    this.fallbackDelegate = fallbackDelegate;
                    this.types = new HashMap();
                    for (Class<?> type : types) {
                        this.types.put(TypeDescription.ForLoadedType.getName(type), type);
                    }
                }

                public static ClassLoadingDelegate of(Class<?> type) {
                    return new Explicit(type.getClassLoader(), Collections.singleton(type));
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Class<?> type = this.types.get(name);
                    return type == null ? this.fallbackDelegate.locate(name) : type;
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.fallbackDelegate.getClassLoader();
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Explicit)) {
                        return false;
                    }
                    Explicit other = (Explicit)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ClassLoadingDelegate this$fallbackDelegate = this.fallbackDelegate;
                    ClassLoadingDelegate other$fallbackDelegate = other.fallbackDelegate;
                    if (this$fallbackDelegate == null ? other$fallbackDelegate != null : !this$fallbackDelegate.equals(other$fallbackDelegate)) {
                        return false;
                    }
                    Map<String, Class<?>> this$types = this.types;
                    Map<String, Class<?>> other$types = other.types;
                    return !(this$types == null ? other$types != null : !((Object)this$types).equals(other$types));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Explicit;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ClassLoadingDelegate $fallbackDelegate = this.fallbackDelegate;
                    result = result * 59 + ($fallbackDelegate == null ? 43 : $fallbackDelegate.hashCode());
                    Map<String, Class<?>> $types = this.types;
                    result = result * 59 + ($types == null ? 43 : ((Object)$types).hashCode());
                    return result;
                }
            }

            public static class ForDelegatingClassLoader
            extends Default {
                private static final String DELEGATING_CLASS_LOADER_NAME = "sun.reflect.DelegatingClassLoader";
                private static final int ONLY = 0;
                private static final Dispatcher.Initializable DISPATCHER = AccessController.doPrivileged(Dispatcher.CreationAction.INSTANCE);

                protected ForDelegatingClassLoader(ClassLoader classLoader) {
                    super(classLoader);
                }

                protected static boolean isDelegating(ClassLoader classLoader) {
                    return classLoader != null && classLoader.getClass().getName().equals(DELEGATING_CLASS_LOADER_NAME);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    Vector<Class<?>> classes;
                    try {
                        classes = DISPATCHER.initialize().extract(this.classLoader);
                    }
                    catch (RuntimeException ignored) {
                        return super.locate(name);
                    }
                    if (classes.size() != 1) {
                        return super.locate(name);
                    }
                    Class<?> type = classes.get(0);
                    return TypeDescription.ForLoadedType.getName(type).equals(name) ? type : super.locate(name);
                }

                protected static interface Dispatcher {
                    public Vector<Class<?>> extract(ClassLoader var1);

                    public static class Unresolved
                    implements Initializable {
                        private final Exception exception;

                        public Unresolved(Exception exception) {
                            this.exception = exception;
                        }

                        @Override
                        public Dispatcher initialize() {
                            throw new IllegalStateException("Could not locate classes vector", this.exception);
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Unresolved)) {
                                return false;
                            }
                            Unresolved other = (Unresolved)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Exception this$exception = this.exception;
                            Exception other$exception = other.exception;
                            return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Unresolved;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Exception $exception = this.exception;
                            result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
                            return result;
                        }
                    }

                    public static class Resolved
                    implements Dispatcher,
                    Initializable,
                    PrivilegedAction<Dispatcher> {
                        private final Field field;

                        public Resolved(Field field) {
                            this.field = field;
                        }

                        @Override
                        public Dispatcher initialize() {
                            return AccessController.doPrivileged(this);
                        }

                        @Override
                        public Vector<Class<?>> extract(ClassLoader classLoader) {
                            try {
                                return (Vector)this.field.get(classLoader);
                            }
                            catch (IllegalAccessException exception) {
                                throw new IllegalStateException("Cannot access field", exception);
                            }
                        }

                        @Override
                        public Dispatcher run() {
                            this.field.setAccessible(true);
                            return this;
                        }

                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Resolved)) {
                                return false;
                            }
                            Resolved other = (Resolved)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            Field this$field = this.field;
                            Field other$field = other.field;
                            return !(this$field == null ? other$field != null : !((Object)this$field).equals(other$field));
                        }

                        protected boolean canEqual(Object other) {
                            return other instanceof Resolved;
                        }

                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            Field $field = this.field;
                            result = result * 59 + ($field == null ? 43 : ((Object)$field).hashCode());
                            return result;
                        }
                    }

                    public static enum CreationAction implements PrivilegedAction<Initializable>
                    {
                        INSTANCE;


                        @Override
                        public Initializable run() {
                            try {
                                return new Resolved(ClassLoader.class.getDeclaredField("classes"));
                            }
                            catch (Exception exception) {
                                return new Unresolved(exception);
                            }
                        }
                    }

                    public static interface Initializable {
                        public Dispatcher initialize();
                    }
                }
            }

            public static class Default
            implements ClassLoadingDelegate {
                protected final ClassLoader classLoader;

                protected Default(ClassLoader classLoader) {
                    this.classLoader = classLoader;
                }

                public static ClassLoadingDelegate of(ClassLoader classLoader) {
                    return ForDelegatingClassLoader.isDelegating(classLoader) ? new ForDelegatingClassLoader(classLoader) : new Default(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
                }

                @Override
                public Class<?> locate(String name) throws ClassNotFoundException {
                    return this.classLoader.loadClass(name);
                }

                @Override
                public ClassLoader getClassLoader() {
                    return this.classLoader;
                }

                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Default)) {
                        return false;
                    }
                    Default other = (Default)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ClassLoader this$classLoader = this.getClassLoader();
                    ClassLoader other$classLoader = other.getClassLoader();
                    return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
                }

                protected boolean canEqual(Object other) {
                    return other instanceof Default;
                }

                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ClassLoader $classLoader = this.getClassLoader();
                    result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
                    return result;
                }
            }
        }
    }

    public static class ForFolder
    implements ClassFileLocator {
        private final File folder;

        public ForFolder(File folder) {
            this.folder = folder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            File file = new File(this.folder, typeName.replace('.', File.separatorChar) + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (file.exists()) {
                FileInputStream inputStream = new FileInputStream(file);
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                    return explicit;
                }
                finally {
                    ((InputStream)inputStream).close();
                }
            }
            return new Resolution.Illegal(typeName);
        }

        @Override
        public void close() throws IOException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForFolder)) {
                return false;
            }
            ForFolder other = (ForFolder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            File this$folder = this.folder;
            File other$folder = other.folder;
            return !(this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForFolder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            File $folder = this.folder;
            result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
            return result;
        }
    }

    public static class ForModuleFile
    implements ClassFileLocator {
        private static final String JMOD_FILE_EXTENSION = ".jmod";
        private static final List<String> BOOT_LOCATIONS = Arrays.asList("jmods", "../jmods");
        private final ZipFile zipFile;

        public ForModuleFile(ZipFile zipFile) {
            this.zipFile = zipFile;
        }

        public static ClassFileLocator ofBootPath() throws IOException {
            String javaHome = System.getProperty("java.home").replace('\\', '/');
            File bootPath = null;
            for (String location : BOOT_LOCATIONS) {
                File candidate = new File(javaHome, location);
                if (!candidate.isDirectory()) continue;
                bootPath = candidate;
                break;
            }
            if (bootPath == null) {
                throw new IllegalStateException("Boot modules do not exist in " + javaHome + " for any of " + BOOT_LOCATIONS);
            }
            return ForModuleFile.ofBootPath(bootPath);
        }

        public static ClassFileLocator ofBootPath(File bootPath) throws IOException {
            File[] module = bootPath.listFiles();
            if (module == null) {
                return NoOp.INSTANCE;
            }
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>(module.length);
            for (File aModule : module) {
                if (!aModule.isFile()) continue;
                classFileLocators.add(ForModuleFile.of(aModule));
            }
            return new Compound(classFileLocators);
        }

        public static ClassFileLocator ofModulePath() throws IOException {
            String modulePath = System.getProperty("jdk.module.path");
            return modulePath == null ? NoOp.INSTANCE : ForModuleFile.ofModulePath(modulePath);
        }

        public static ClassFileLocator ofModulePath(String modulePath) throws IOException {
            return ForModuleFile.ofModulePath(modulePath, System.getProperty("user.dir"));
        }

        public static ClassFileLocator ofModulePath(String modulePath, String baseFolder) throws IOException {
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (String element : Pattern.compile(System.getProperty("path.separator"), 16).split(modulePath)) {
                File file = new File(baseFolder, element);
                if (file.isDirectory()) {
                    File[] module = file.listFiles();
                    if (module == null) continue;
                    for (File aModule : module) {
                        if (aModule.isDirectory()) {
                            classFileLocators.add(new ForFolder(aModule));
                            continue;
                        }
                        if (!aModule.isFile()) continue;
                        classFileLocators.add(aModule.getName().endsWith(JMOD_FILE_EXTENSION) ? ForModuleFile.of(aModule) : ForJarFile.of(aModule));
                    }
                    continue;
                }
                if (!file.isFile()) continue;
                classFileLocators.add(file.getName().endsWith(JMOD_FILE_EXTENSION) ? ForModuleFile.of(file) : ForJarFile.of(file));
            }
            return new Compound(classFileLocators);
        }

        public static ClassFileLocator of(File file) throws IOException {
            return new ForModuleFile(new ZipFile(file));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            ZipEntry zipEntry = this.zipFile.getEntry("classes/" + typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (zipEntry == null) {
                return new Resolution.Illegal(typeName);
            }
            InputStream inputStream = this.zipFile.getInputStream(zipEntry);
            try {
                Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                return explicit;
            }
            finally {
                inputStream.close();
            }
        }

        @Override
        public void close() throws IOException {
            this.zipFile.close();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForModuleFile)) {
                return false;
            }
            ForModuleFile other = (ForModuleFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ZipFile this$zipFile = this.zipFile;
            ZipFile other$zipFile = other.zipFile;
            return !(this$zipFile == null ? other$zipFile != null : !this$zipFile.equals(other$zipFile));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForModuleFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ZipFile $zipFile = this.zipFile;
            result = result * 59 + ($zipFile == null ? 43 : $zipFile.hashCode());
            return result;
        }
    }

    public static class ForJarFile
    implements ClassFileLocator {
        private static final List<String> RUNTIME_LOCATIONS = Arrays.asList("lib/rt.jar", "../lib/rt.jar", "../Classes/classes.jar");
        private final JarFile jarFile;

        public ForJarFile(JarFile jarFile) {
            this.jarFile = jarFile;
        }

        public static ClassFileLocator of(File file) throws IOException {
            return new ForJarFile(new JarFile(file));
        }

        public static ClassFileLocator ofClassPath() throws IOException {
            return ForJarFile.ofClassPath(System.getProperty("java.class.path"));
        }

        public static ClassFileLocator ofClassPath(String classPath) throws IOException {
            ArrayList<ClassFileLocator> classFileLocators = new ArrayList<ClassFileLocator>();
            for (String element : Pattern.compile(System.getProperty("path.separator"), 16).split(classPath)) {
                File file = new File(element);
                if (file.isDirectory()) {
                    classFileLocators.add(new ForFolder(file));
                    continue;
                }
                if (!file.isFile()) continue;
                classFileLocators.add(ForJarFile.of(file));
            }
            return new Compound(classFileLocators);
        }

        public static ClassFileLocator ofRuntimeJar() throws IOException {
            String javaHome = System.getProperty("java.home").replace('\\', '/');
            File runtimeJar = null;
            for (String location : RUNTIME_LOCATIONS) {
                File candidate = new File(javaHome, location);
                if (!candidate.isFile()) continue;
                runtimeJar = candidate;
                break;
            }
            if (runtimeJar == null) {
                throw new IllegalStateException("Runtime jar does not exist in " + javaHome + " for any of " + RUNTIME_LOCATIONS);
            }
            return ForJarFile.of(runtimeJar);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Resolution locate(String typeName) throws IOException {
            ZipEntry zipEntry = this.jarFile.getEntry(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (zipEntry == null) {
                return new Resolution.Illegal(typeName);
            }
            InputStream inputStream = this.jarFile.getInputStream(zipEntry);
            try {
                Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                return explicit;
            }
            finally {
                inputStream.close();
            }
        }

        @Override
        public void close() throws IOException {
            this.jarFile.close();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForJarFile)) {
                return false;
            }
            ForJarFile other = (ForJarFile)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JarFile this$jarFile = this.jarFile;
            JarFile other$jarFile = other.jarFile;
            return !(this$jarFile == null ? other$jarFile != null : !this$jarFile.equals(other$jarFile));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForJarFile;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JarFile $jarFile = this.jarFile;
            result = result * 59 + ($jarFile == null ? 43 : $jarFile.hashCode());
            return result;
        }
    }

    public static class ForModule
    implements ClassFileLocator {
        private final JavaModule module;

        protected ForModule(JavaModule module) {
            this.module = module;
        }

        @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception is supposed to be rethrown")
        public static ClassFileLocator ofBootLayer() {
            try {
                HashMap<String, ClassFileLocator> bootModules = new HashMap<String, ClassFileLocator>();
                Class<?> layerType = Class.forName("java.lang.ModuleLayer");
                Method getPackages = JavaType.MODULE.load().getMethod("getPackages", new Class[0]);
                for (Object rawModule : (Set)layerType.getMethod("modules", new Class[0]).invoke(layerType.getMethod("boot", new Class[0]).invoke(null, new Object[0]), new Object[0])) {
                    ClassFileLocator classFileLocator = ForModule.of(JavaModule.of(rawModule));
                    for (String packageName : (String[])getPackages.invoke(rawModule, new Object[0])) {
                        bootModules.put(packageName, classFileLocator);
                    }
                }
                return new PackageDiscriminating(bootModules);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Cannot process boot layer", exception);
            }
        }

        public static ClassFileLocator of(JavaModule module) {
            return module.isNamed() ? new ForModule(module) : ForClassLoader.of(module.getClassLoader());
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            return ForModule.locate(this.module, typeName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static Resolution locate(JavaModule module, String typeName) throws IOException {
            InputStream inputStream = module.getResourceAsStream(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                    return explicit;
                }
                finally {
                    inputStream.close();
                }
            }
            return new Resolution.Illegal(typeName);
        }

        @Override
        public void close() throws IOException {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForModule)) {
                return false;
            }
            ForModule other = (ForModule)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JavaModule this$module = this.module;
            JavaModule other$module = other.module;
            return !(this$module == null ? other$module != null : !((Object)this$module).equals(other$module));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForModule;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaModule $module = this.module;
            result = result * 59 + ($module == null ? 43 : ((Object)$module).hashCode());
            return result;
        }

        public static class WeaklyReferenced
        extends WeakReference<Object>
        implements ClassFileLocator {
            private final int hashCode;

            protected WeaklyReferenced(Object module) {
                super(module);
                this.hashCode = System.identityHashCode(module);
            }

            public static ClassFileLocator of(JavaModule module) {
                if (module.isNamed()) {
                    return module.getClassLoader() == null || module.getClassLoader() == ClassLoader.getSystemClassLoader() || module.getClassLoader() == ClassLoader.getSystemClassLoader().getParent() ? new ForModule(module) : new WeaklyReferenced(module.unwrap());
                }
                return ForClassLoader.WeaklyReferenced.of(module.getClassLoader());
            }

            @Override
            public Resolution locate(String typeName) throws IOException {
                Object module = this.get();
                return module == null ? new Resolution.Illegal(typeName) : ForModule.locate(JavaModule.of(module), typeName);
            }

            @Override
            public void close() throws IOException {
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WeaklyReferenced that = (WeaklyReferenced)object;
                Object module = that.get();
                return module != null && this.get() == module;
            }
        }
    }

    public static class ForClassLoader
    implements ClassFileLocator {
        private final ClassLoader classLoader;

        protected ForClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }

        public static ClassFileLocator ofClassPath() {
            return new ForClassLoader(ClassLoader.getSystemClassLoader());
        }

        public static ClassFileLocator of(ClassLoader classLoader) {
            return new ForClassLoader(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader);
        }

        public static Resolution read(Class<?> type) {
            try {
                ClassLoader classLoader = type.getClassLoader();
                return ForClassLoader.locate(classLoader == null ? ClassLoader.getSystemClassLoader() : classLoader, TypeDescription.ForLoadedType.getName(type));
            }
            catch (IOException exception) {
                throw new IllegalStateException("Cannot read class file for " + type, exception);
            }
        }

        @Override
        public Resolution locate(String typeName) throws IOException {
            return ForClassLoader.locate(this.classLoader, typeName);
        }

        @Override
        public void close() throws IOException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected static Resolution locate(ClassLoader classLoader, String typeName) throws IOException {
            InputStream inputStream = classLoader.getResourceAsStream(typeName.replace('.', '/') + ClassFileLocator.CLASS_FILE_EXTENSION);
            if (inputStream != null) {
                try {
                    Resolution.Explicit explicit = new Resolution.Explicit(StreamDrainer.DEFAULT.drain(inputStream));
                    return explicit;
                }
                finally {
                    inputStream.close();
                }
            }
            return new Resolution.Illegal(typeName);
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ForClassLoader)) {
                return false;
            }
            ForClassLoader other = (ForClassLoader)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ClassLoader this$classLoader = this.classLoader;
            ClassLoader other$classLoader = other.classLoader;
            return !(this$classLoader == null ? other$classLoader != null : !this$classLoader.equals(other$classLoader));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ForClassLoader;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ClassLoader $classLoader = this.classLoader;
            result = result * 59 + ($classLoader == null ? 43 : $classLoader.hashCode());
            return result;
        }

        public static class WeaklyReferenced
        extends WeakReference<ClassLoader>
        implements ClassFileLocator {
            private final int hashCode;

            protected WeaklyReferenced(ClassLoader classLoader) {
                super(classLoader);
                this.hashCode = System.identityHashCode(classLoader);
            }

            public static ClassFileLocator of(ClassLoader classLoader) {
                return classLoader == null || classLoader == ClassLoader.getSystemClassLoader() || classLoader == ClassLoader.getSystemClassLoader().getParent() ? ForClassLoader.of(classLoader) : new WeaklyReferenced(classLoader);
            }

            @Override
            public Resolution locate(String typeName) throws IOException {
                ClassLoader classLoader = (ClassLoader)this.get();
                return classLoader == null ? new Resolution.Illegal(typeName) : ForClassLoader.locate(classLoader, typeName);
            }

            @Override
            public void close() throws IOException {
            }

            public int hashCode() {
                return this.hashCode;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                WeaklyReferenced that = (WeaklyReferenced)object;
                ClassLoader classLoader = (ClassLoader)that.get();
                return classLoader != null && this.get() == classLoader;
            }
        }
    }

    public static class Simple
    implements ClassFileLocator {
        private final Map<String, byte[]> classFiles;

        public Simple(Map<String, byte[]> classFiles) {
            this.classFiles = classFiles;
        }

        public static ClassFileLocator of(String typeName, byte[] binaryRepresentation) {
            return new Simple(Collections.singletonMap(typeName, binaryRepresentation));
        }

        public static ClassFileLocator of(String typeName, byte[] binaryRepresentation, ClassFileLocator fallback) {
            return new Compound(new Simple(Collections.singletonMap(typeName, binaryRepresentation)), fallback);
        }

        public static ClassFileLocator of(DynamicType dynamicType) {
            return Simple.of(dynamicType.getAllTypes());
        }

        public static ClassFileLocator of(Map<TypeDescription, byte[]> binaryRepresentations) {
            HashMap<String, byte[]> classFiles = new HashMap<String, byte[]>();
            for (Map.Entry<TypeDescription, byte[]> entry : binaryRepresentations.entrySet()) {
                classFiles.put(entry.getKey().getName(), entry.getValue());
            }
            return new Simple(classFiles);
        }

        @Override
        public Resolution locate(String typeName) {
            byte[] binaryRepresentation = this.classFiles.get(typeName);
            return binaryRepresentation == null ? new Resolution.Illegal(typeName) : new Resolution.Explicit(binaryRepresentation);
        }

        @Override
        public void close() {
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Simple)) {
                return false;
            }
            Simple other = (Simple)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, byte[]> this$classFiles = this.classFiles;
            Map<String, byte[]> other$classFiles = other.classFiles;
            return !(this$classFiles == null ? other$classFiles != null : !((Object)this$classFiles).equals(other$classFiles));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Simple;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, byte[]> $classFiles = this.classFiles;
            result = result * 59 + ($classFiles == null ? 43 : ((Object)$classFiles).hashCode());
            return result;
        }
    }

    public static enum NoOp implements ClassFileLocator
    {
        INSTANCE;


        @Override
        public Resolution locate(String typeName) {
            return new Resolution.Illegal(typeName);
        }

        @Override
        public void close() throws IOException {
        }
    }

    public static interface Resolution {
        public boolean isResolved();

        public byte[] resolve();

        public static class Explicit
        implements Resolution {
            private final byte[] binaryRepresentation;

            @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="The array is not to be modified by contract")
            public Explicit(byte[] binaryRepresentation) {
                this.binaryRepresentation = binaryRepresentation;
            }

            @Override
            public boolean isResolved() {
                return true;
            }

            @Override
            @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="The array is not to be modified by contract")
            public byte[] resolve() {
                return this.binaryRepresentation;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Explicit)) {
                    return false;
                }
                Explicit other = (Explicit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return Arrays.equals(this.binaryRepresentation, other.binaryRepresentation);
            }

            protected boolean canEqual(Object other) {
                return other instanceof Explicit;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Arrays.hashCode(this.binaryRepresentation);
                return result;
            }
        }

        public static class Illegal
        implements Resolution {
            private final String typeName;

            public Illegal(String typeName) {
                this.typeName = typeName;
            }

            @Override
            public boolean isResolved() {
                return false;
            }

            @Override
            public byte[] resolve() {
                throw new IllegalStateException("Could not locate class file for " + this.typeName);
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Illegal)) {
                    return false;
                }
                Illegal other = (Illegal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$typeName = this.typeName;
                String other$typeName = other.typeName;
                return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Illegal;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $typeName = this.typeName;
                result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
                return result;
            }
        }
    }
}

