/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.thirdparty.bytebuddy.description.enumeration;

import com.webobjects.thirdparty.bytebuddy.description.NamedElement;
import com.webobjects.thirdparty.bytebuddy.description.type.TypeDescription;
import java.util.ArrayList;
import java.util.List;

public interface EnumerationDescription
extends NamedElement {
    public String getValue();

    public TypeDescription getEnumerationType();

    public <T extends Enum<T>> T load(Class<T> var1);

    public static class Latent
    extends AbstractBase {
        private final TypeDescription enumerationType;
        private final String value;

        public Latent(TypeDescription enumerationType, String value) {
            this.enumerationType = enumerationType;
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public TypeDescription getEnumerationType() {
            return this.enumerationType;
        }

        @Override
        public <T extends Enum<T>> T load(Class<T> type) {
            if (!this.enumerationType.represents(type)) {
                throw new IllegalArgumentException(type + " does not represent " + this.enumerationType);
            }
            return Enum.valueOf(type, this.value);
        }
    }

    public static class ForLoadedEnumeration
    extends AbstractBase {
        private final Enum<?> value;

        public ForLoadedEnumeration(Enum<?> value) {
            this.value = value;
        }

        public static List<EnumerationDescription> asList(Enum<?>[] enumerations) {
            ArrayList<EnumerationDescription> result = new ArrayList<EnumerationDescription>(enumerations.length);
            for (Enum<?> enumeration : enumerations) {
                result.add(new ForLoadedEnumeration(enumeration));
            }
            return result;
        }

        @Override
        public String getValue() {
            return this.value.name();
        }

        @Override
        public TypeDescription getEnumerationType() {
            return new TypeDescription.ForLoadedType(this.value.getDeclaringClass());
        }

        @Override
        public <T extends Enum<T>> T load(Class<T> type) {
            return (T)(this.value.getDeclaringClass() == type ? this.value : Enum.valueOf(type, this.value.name()));
        }
    }

    public static abstract class AbstractBase
    implements EnumerationDescription {
        @Override
        public String getActualName() {
            return this.getValue();
        }

        public boolean equals(Object other) {
            return other == this || other instanceof EnumerationDescription && ((EnumerationDescription)other).getEnumerationType().equals(this.getEnumerationType()) && ((EnumerationDescription)other).getValue().equals(this.getValue());
        }

        public int hashCode() {
            return this.getValue().hashCode() + 31 * this.getEnumerationType().hashCode();
        }

        public String toString() {
            return this.getValue();
        }
    }
}

