/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.xml;

import com.webobjects.foundation.NSForwardException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class _NSXMLUtilities {
    private static final Logger log = LoggerFactory.getLogger(_NSXMLUtilities.class);
    static final Class<? extends SAXParserFactory> xercesSAXParserFactoryClass;
    static final Class<? extends DocumentBuilderFactory> xercesDocumentBuilderFactoryClass;

    static {
        ClassLoader loader = _NSXMLUtilities.class.getClassLoader();
        boolean useRealXerces = false;
        try {
            Class<SAXParserFactory> saxParserFactoryClass = Class.forName("org.apache.xerces.jaxp.SAXParserFactoryImpl").asSubclass(SAXParserFactory.class);
            SAXParserFactory parserFactory = saxParserFactoryClass.newInstance();
            parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            useRealXerces = true;
        }
        catch (InstantiationException e) {
            log.warn("Not using org.apache.xerces", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            log.warn("Not using org.apache.xerces", (Throwable)e);
        }
        catch (SAXNotRecognizedException e) {
            log.info("Not using org.apache.xerces", (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            log.warn("Not using org.apache.xerces", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.warn("Not using org.apache.xerces", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            log.debug("Not using org.apache.xerces", (Throwable)e);
        }
        xercesSAXParserFactoryClass = _NSXMLUtilities.findClass(loader, SAXParserFactory.class, !useRealXerces ? null : "org.apache.xerces.jaxp.SAXParserFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        xercesDocumentBuilderFactoryClass = _NSXMLUtilities.findClass(loader, DocumentBuilderFactory.class, !useRealXerces ? null : "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
    }

    private static final <T> Class<? extends T> findClass(ClassLoader loader, Class<T> targetClass, String ... classNames) {
        Class<?> result = null;
        String[] stringArray = classNames;
        int n = classNames.length;
        int n2 = 0;
        while (n2 < n) {
            String className = stringArray[n2];
            if (className != null) {
                try {
                    result = Class.forName(className, true, loader);
                }
                catch (ClassNotFoundException classNotFoundException) {}
                if (result != null && targetClass.isAssignableFrom(result)) break;
            }
            ++n2;
        }
        return result == null ? null : result.asSubclass(targetClass);
    }

    public static SAXParserFactory newSAXParserFactory() {
        if (xercesSAXParserFactoryClass != null) {
            try {
                return xercesSAXParserFactoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new NSForwardException(e);
            }
            catch (IllegalAccessException e) {
                throw new NSForwardException(e);
            }
        }
        return SAXParserFactory.newInstance();
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() {
        if (xercesDocumentBuilderFactoryClass != null) {
            try {
                return xercesDocumentBuilderFactoryClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new NSForwardException(e);
            }
            catch (IllegalAccessException e) {
                throw new NSForwardException(e);
            }
        }
        return DocumentBuilderFactory.newInstance();
    }

    public static Document newDocument(InputStream stream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = _NSXMLUtilities.newDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder newDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
        return newDocumentBuilder.parse(stream);
    }
}

