/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.stats.event;

public class NSTimeEvent {
    private final String _name;
    private int[] _buckets;
    private final float[] _bucketMaxValues;
    private final String[] _bucketNames;

    protected int computeBucketIndex(float time) {
        int i = 0;
        while (i < this._bucketMaxValues.length) {
            if (time <= this._bucketMaxValues[i]) {
                return i;
            }
            ++i;
        }
        return this._bucketMaxValues.length - 1;
    }

    public NSTimeEvent(String name, int buckets, float startBucketMaxValue) {
        this._name = name;
        this._buckets = new int[buckets];
        this._bucketMaxValues = new float[buckets];
        this._bucketNames = new String[buckets];
        float bucketMaxValue = startBucketMaxValue;
        int i = 0;
        while (i < this._bucketMaxValues.length) {
            this._bucketMaxValues[i] = bucketMaxValue;
            this._bucketNames[i] = "< " + bucketMaxValue;
            bucketMaxValue *= 2.0f;
            ++i;
        }
    }

    public String name() {
        return this._name;
    }

    public synchronized void add(float time) {
        int index;
        int n = index = this.computeBucketIndex(time);
        this._buckets[n] = this._buckets[n] + 1;
    }

    public int[] buckets() {
        return this._buckets;
    }

    public String[] bucketNames() {
        return this._bucketNames;
    }

    public void resetcumulatives() {
        int size = this._buckets.length;
        this._buckets = new int[size];
    }
}

