/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.stats.event;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation.stats.event.NSHistogram;
import com.webobjects.foundation.stats.event.NSStatsEvent;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public abstract class NSStatsAbstractLiveEvent
implements NSStatsEvent,
Serializable {
    private static final long serialVersionUID = -674682461653057106L;
    private static final ThreadLocal<Double[]> RecentSeconds = new ThreadLocal();
    private final String _name;
    private final long[] _recentTimes;
    private final boolean _allowsStackTraces;
    private StackTraceElement[] _recentStackTraceElements;
    private long _totalCount;
    private long cumulativeCount;
    private long _min;
    private long cumulativeMin = Long.MAX_VALUE;
    private long _max;
    private long cumulativeMax = Long.MIN_VALUE;
    double _averageMillis;
    double cumulativeTime;
    double cumulativeAverageMillis;
    private String eventType;
    private String eventValue;
    private long _activeStartNanos;
    private NSHistogram _percentileHistogram = new NSHistogram();
    private static final int LargeMask = 16383;
    private static final int MediumMask = 1023;
    private static final int SmallMask = 127;
    public static final Comparator<? super NSStatsAbstractLiveEvent> NameComparator = new Comparator<NSStatsAbstractLiveEvent>(){

        @Override
        public int compare(NSStatsAbstractLiveEvent object1, NSStatsAbstractLiveEvent object2) {
            String name1 = object1.name();
            String name2 = object2.name();
            return name1.compareTo(name2);
        }
    };
    public static final Comparator<? super NSStatsAbstractLiveEvent> TotalCountComparator = new Comparator<NSStatsAbstractLiveEvent>(){

        @Override
        public int compare(NSStatsAbstractLiveEvent object1, NSStatsAbstractLiveEvent object2) {
            long totalCount2;
            long totalCount1 = object1.totalCount();
            return totalCount1 > (totalCount2 = object2.totalCount()) ? -1 : (totalCount1 < totalCount2 ? 1 : 0);
        }
    };
    public static final Comparator<? super NSStatsAbstractLiveEvent> AverageComparator = new Comparator<NSStatsAbstractLiveEvent>(){

        @Override
        public int compare(NSStatsAbstractLiveEvent object1, NSStatsAbstractLiveEvent object2) {
            double averag1 = object1.averageMillis();
            double averag2 = object2.averageMillis();
            return Double.compare(averag1, averag2);
        }
    };
    public static final Comparator<? super NSStatsAbstractLiveEvent> TotalEventTimeComparator = new Comparator<NSStatsAbstractLiveEvent>(){

        @Override
        public int compare(NSStatsAbstractLiveEvent object1, NSStatsAbstractLiveEvent object2) {
            double totalEventTime1 = object1.totalEventTime();
            double totalEventTime2 = object2.totalEventTime();
            return Double.compare(totalEventTime2, totalEventTime1);
        }
    };

    public NSStatsAbstractLiveEvent(String name, int movingAverageSampleSize, boolean allowStackTraces) {
        this._name = name;
        this._allowsStackTraces = allowStackTraces;
        this._recentStackTraceElements = allowStackTraces ? this.grabStackTraceElements() : null;
        this._recentTimes = new long[movingAverageSampleSize];
        this.resetCaches();
    }

    public synchronized void setActive(boolean active) {
        this._activeStartNanos = active ? System.nanoTime() : 0L;
    }

    public synchronized boolean isActive() {
        return this._activeStartNanos != 0L;
    }

    public synchronized long activeDurationNanos() {
        return this._activeStartNanos == 0L ? 0L : System.nanoTime() - this._activeStartNanos;
    }

    public synchronized void add(long startTimeMillis, long endTimeMillis) {
        this.add(startTimeMillis, endTimeMillis, 1L);
    }

    public synchronized void add(long startTimeMillis, long endTimeMillis, long count) {
        long deltaTime = endTimeMillis - startTimeMillis;
        this.resetCaches();
        int index = (int)(this._totalCount % (long)this._recentTimes.length);
        this._recentTimes[index] = deltaTime;
        this._totalCount += count;
        this.cumulativeCount += count;
        if (this._allowsStackTraces) {
            if (this._totalCount > 16383L) {
                if ((this._totalCount & 0x3FFFL) == 0L) {
                    this._recentStackTraceElements = this.grabStackTraceElements();
                }
            } else if (this._totalCount > 1023L) {
                if ((this._totalCount & 0x3FFL) == 0L) {
                    this._recentStackTraceElements = this.grabStackTraceElements();
                }
            } else if (this._totalCount > 127L && (this._totalCount & 0x7FL) == 0L) {
                this._recentStackTraceElements = this.grabStackTraceElements();
            }
        }
        if (deltaTime < this.cumulativeMin) {
            this.cumulativeMin = deltaTime;
        }
        if (deltaTime > this.cumulativeMax) {
            this.cumulativeMax = deltaTime;
        }
        this.cumulativeTime += (double)deltaTime;
        this.cumulativeAverageMillis = this.cumulativeTime / (double)this.cumulativeCount;
        this._percentileHistogram.recordSample(deltaTime);
    }

    private StackTraceElement[] grabStackTraceElements() {
        RuntimeException exception = new RuntimeException();
        return exception.getStackTrace();
    }

    @Override
    public String stackTrace() {
        if (this._recentStackTraceElements != null) {
            StringBuilder stringBuffer = new StringBuilder(2000);
            int index = 1;
            int length = this._recentStackTraceElements.length;
            while (index < length) {
                StackTraceElement stackTraceElement = this._recentStackTraceElements[index];
                String straceTraceElementString = stackTraceElement.toString();
                stringBuffer.append(straceTraceElementString);
                stringBuffer.append("\n");
                ++index;
            }
            String stackTrace = stringBuffer.toString();
            return stackTrace;
        }
        return "no stack trace";
    }

    private void resetCaches() {
        this._max = -1L;
        this._min = -1L;
        this._averageMillis = -1.0;
    }

    public synchronized void resetcumulatives() {
        this.cumulativeMin = 0L;
        this.cumulativeMax = 0L;
        this.cumulativeTime = 0.0;
        this.cumulativeAverageMillis = 0.0;
        this.cumulativeCount = 0L;
        this._percentileHistogram = new NSHistogram();
    }

    @Override
    public String name() {
        return this._name;
    }

    public String nameAsString() {
        String name = this.name().trim();
        if (name.endsWith(":")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    @Override
    public long totalCount() {
        return this._totalCount;
    }

    @Override
    public long recentCount() {
        return 0L;
    }

    @Override
    public synchronized double eventCountPercentage() {
        long totalRequestCount = this.totalRequestCount();
        return totalRequestCount == 0L ? 0.0 : (double)this.totalCount() / (double)totalRequestCount * 100.0;
    }

    protected abstract long totalRequestCount();

    @Override
    public synchronized double totalEventTime() {
        return this.averageSeconds() * (double)this.totalCount();
    }

    public synchronized int sampleSize() {
        return this._recentTimes.length;
    }

    @Override
    public synchronized long activeCount() {
        return this._totalCount < (long)this._recentTimes.length ? this._totalCount : (long)this._recentTimes.length;
    }

    private long totalMillis(long count) {
        long totalMillis = 0L;
        int index = 0;
        while ((long)index < count) {
            long recentTime = this._recentTimes[index];
            if (recentTime > 0L) {
                totalMillis += recentTime;
            }
            ++index;
        }
        return totalMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized double averageMillis() {
        if (Math.abs(this._averageMillis + 1.0) < 1.0E-7) {
            NSStatsAbstractLiveEvent nSStatsAbstractLiveEvent = this;
            synchronized (nSStatsAbstractLiveEvent) {
                long count = this.activeCount();
                if (count == 0L) {
                    this._averageMillis = 0.0;
                } else {
                    long totalMillis = this.totalMillis(count);
                    this._averageMillis = (double)totalMillis / (double)count;
                }
            }
        }
        return this._averageMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long minMillis() {
        if (this._min == -1L) {
            NSStatsAbstractLiveEvent nSStatsAbstractLiveEvent = this;
            synchronized (nSStatsAbstractLiveEvent) {
                long minMillis = this._recentTimes[0];
                long count = this.activeCount();
                int index = 0;
                while ((long)index < count) {
                    long recentTime = this._recentTimes[index];
                    if (recentTime < minMillis) {
                        minMillis = recentTime;
                    }
                    ++index;
                }
                this._min = minMillis;
            }
        }
        return this._min;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized long maxMillis() {
        if (this._max == -1L) {
            NSStatsAbstractLiveEvent nSStatsAbstractLiveEvent = this;
            synchronized (nSStatsAbstractLiveEvent) {
                long maxMillis = this._recentTimes[0];
                long count = this.activeCount();
                int index = 0;
                while ((long)index < count) {
                    long recentTime = this._recentTimes[index];
                    if (recentTime > maxMillis) {
                        maxMillis = recentTime;
                    }
                    ++index;
                }
                this._max = maxMillis;
            }
        }
        return this._max;
    }

    @Override
    public synchronized double averageSeconds() {
        return this.averageMillis() / 1000.0;
    }

    @Override
    public synchronized double cumulativeAverageSeconds() {
        if (this.cumulativeCount == 0L) {
            return 0.0;
        }
        return this.cumulativeAverageMillis / 1000.0;
    }

    @Override
    public synchronized double minSeconds() {
        return (double)this.minMillis() / 1000.0;
    }

    @Override
    public synchronized double cumulativeMinSeconds() {
        if (this.cumulativeCount == 0L) {
            return 0.0;
        }
        return (double)this.cumulativeMin / 1000.0;
    }

    @Override
    public synchronized double maxSeconds() {
        return (double)this.maxMillis() / 1000.0;
    }

    @Override
    public synchronized double cumulativeMaxSeconds() {
        if (this.cumulativeCount == 0L) {
            return 0.0;
        }
        return (double)this.cumulativeMax / 1000.0;
    }

    @Override
    public synchronized long cumulativeNumberOfEvents() {
        return this.cumulativeCount;
    }

    @Override
    public synchronized Double[] recentSeconds() {
        int offset = (int)this._totalCount % this._recentTimes.length;
        if (offset < 5) {
            offset = 5;
        }
        --offset;
        Double[] recentSeconds = RecentSeconds.get();
        if (recentSeconds == null) {
            recentSeconds = new Double[5];
            RecentSeconds.set(recentSeconds);
        }
        int index = 0;
        while (index < 5) {
            double currentMillis = this._recentTimes[offset - index];
            recentSeconds[index] = new Double(currentMillis / 1000.0);
            ++index;
        }
        return recentSeconds;
    }

    public synchronized String recentSecondsAsString() {
        return new NSArray<Double>(this.recentSeconds()).componentsJoinedByString(",");
    }

    public synchronized String getRawData() {
        StringBuffer sb = new StringBuffer();
        String name = this.name().trim();
        if (name.endsWith(":")) {
            name = name.substring(0, name.length() - 1);
        }
        sb.append(name).append('\t');
        sb.append(this.totalCount()).append('\t');
        sb.append(this.eventCountPercentage()).append('\t');
        sb.append(this.minSeconds()).append('\t');
        sb.append(this.averageSeconds()).append('\t');
        sb.append(this.maxSeconds()).append('\t');
        int i = 0;
        while (i < this.recentSeconds().length) {
            sb.append(this.recentSeconds()[i]);
            if (i != this.recentSeconds().length - 1) {
                sb.append(',');
            }
            ++i;
        }
        sb.append('\t');
        sb.append(this.totalEventTime()).append('\t');
        sb.append(this.cumulativeMinSeconds()).append('\t');
        sb.append(this.cumulativeAverageSeconds()).append('\t');
        sb.append(this.cumulativeMaxSeconds()).append('\t');
        sb.append(this.cumulativeCount);
        sb.append('\n');
        return sb.toString();
    }

    public NSDictionary<String, ?> asDictionary() {
        return _NSDictionaryUtilities.dictionaryFromObjectWithKeys(this, new NSArray<String>(Keys));
    }

    public String toString() {
        return "[" + super.toString() + "; " + this.asDictionary().toString() + "]";
    }

    public long getTotalCount() {
        return this.totalCount();
    }

    public long getRecentCount() {
        return this.recentCount();
    }

    public double getTotalEventTime() {
        return this.totalEventTime();
    }

    public double getAverageSeconds() {
        return this.averageSeconds();
    }

    public double getCumulativeAverageSeconds() {
        return this.cumulativeAverageSeconds();
    }

    public double getMinSeconds() {
        return this.minSeconds();
    }

    public double getCumulativeMinSeconds() {
        return this.cumulativeMinSeconds();
    }

    public double getMaxSeconds() {
        return this.maxSeconds();
    }

    public double getCumulativeMaxSeconds() {
        return this.cumulativeMaxSeconds();
    }

    public long getCumulativeNumberOfEvents() {
        return this.cumulativeNumberOfEvents();
    }

    public double getEventCountPercentage() {
        return this.eventCountPercentage();
    }

    public Double[] getRecentSeconds() {
        return this.recentSeconds();
    }

    public String getStackTrace() {
        return this.stackTrace();
    }

    public long getActiveCount() {
        return this.activeCount();
    }

    @Override
    public NSHistogram percentileHistogram() {
        return this._percentileHistogram;
    }

    @Override
    public double cumulativeTimeMillis() {
        return this.cumulativeTime;
    }

    @Override
    public Map<String, Double> percentileMap() {
        return this._percentileHistogram.addPercentilesToMap(new HashMap<String, Double>());
    }

    @Override
    public String eventType() {
        return this.eventType;
    }

    @Override
    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    @Override
    public String eventValue() {
        return this.eventValue;
    }

    @Override
    public void setEventValue(String eventValue) {
        this.eventValue = eventValue;
    }
}

