/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.stats.event;

public final class NSSizeEvent {
    private static final ThreadLocal<Integer[]> RecentSizes = new ThreadLocal();
    private static final int MovingAverageSampleSize = 20;
    private static final int HistogramBucketCount = 8;
    private final String _name;
    private final int[] _recentSizes;
    private final int[] _buckets;
    private final int _minimumBucketSize;
    private long _totalCount;

    protected static int computeBucketIndex(long value, long smallestBucket, int bucketCount) {
        value /= smallestBucket;
        int bucketIndex = 0;
        while (value > 0L) {
            if (++bucketIndex >= bucketCount) {
                bucketIndex = bucketCount;
                break;
            }
            value >>>= 1;
        }
        return Math.max(0, bucketIndex - 1);
    }

    public NSSizeEvent(String name, int minimumBucketSize) {
        this._name = name;
        this._minimumBucketSize = minimumBucketSize;
        this._recentSizes = new int[20];
        this._buckets = new int[8];
    }

    public String name() {
        return this._name;
    }

    public synchronized void add(int size) {
        int bucketIndex;
        int adjustedSize;
        int index = (int)(this._totalCount % 20L);
        this._recentSizes[index] = adjustedSize = Math.max(1, size);
        int n = bucketIndex = NSSizeEvent.computeBucketIndex(adjustedSize, this._minimumBucketSize, 8);
        this._buckets[n] = this._buckets[n] + 1;
        ++this._totalCount;
    }

    public synchronized Integer[] recentSizes() {
        int offset = (int)(this._totalCount % (long)this._recentSizes.length);
        if (offset < 8) {
            offset = 8;
        }
        --offset;
        Integer[] recentSizes = RecentSizes.get();
        if (recentSizes == null) {
            recentSizes = new Integer[8];
            RecentSizes.set(recentSizes);
        }
        int index = 0;
        while (index < 8) {
            int currentSize = this._recentSizes[offset - index];
            recentSizes[index] = currentSize;
            ++index;
        }
        return recentSizes;
    }

    public synchronized int[] buckets() {
        return this._buckets;
    }

    public synchronized int mostRecentSize() {
        if (this._totalCount >= 0L) {
            int index = (int)((this._totalCount - 1L) % 20L);
            return this._recentSizes[index];
        }
        return 0;
    }

    public synchronized int movingAverage() {
        long sum = 0L;
        int i = 0;
        while (i < 20) {
            sum += (long)this._recentSizes[i];
            ++i;
        }
        return (int)(sum / 20L);
    }
}

