/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.stats.event;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class NSHistogram
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_MAGNITUDES = 8;
    public static final int MAX_MAGNITUDES = 8;
    protected static final int MAGNITUDE_BUCKETS = 10;
    protected static final double EPSILON = 0.001;
    private final int magnitudeCount;
    private final long[] histogram;
    private long max;
    private long count;
    private static final int[] breaks = new int[8];
    static final int[] startValues;
    static int[] bucketValues;
    static final double[] defaultPercentilePoints;
    public static final String[] defaultPercentileNames;

    static {
        int b = 10;
        int i = 0;
        while (i < 8) {
            NSHistogram.breaks[i] = b;
            b *= 10;
            ++i;
        }
        startValues = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000};
        bucketValues = new int[81];
        NSHistogram.bucketValues[0] = 0;
        int offset = 1;
        int z = 0;
        while (z < 8) {
            int y = 1;
            while (y < 11) {
                NSHistogram.bucketValues[offset] = startValues[z] * y;
                ++offset;
                ++y;
            }
            ++z;
        }
        defaultPercentilePoints = new double[]{0.25, 0.5, 0.9, 0.95, 0.99, 0.999};
        defaultPercentileNames = new String[]{"25th", "50th", "90th", "95th", "99th", "99.9th"};
    }

    public NSHistogram(int magnitudes) {
        this.magnitudeCount = magnitudes;
        this.histogram = new long[this.magnitudeCount * 10 + 1];
    }

    public NSHistogram() {
        this(8);
    }

    private final int indexForSample(long sample) {
        if (sample < 10L) {
            if (sample < 0L) {
                return 0;
            }
            return (int)sample;
        }
        int result = this.histogram.length - 1;
        int i = 1;
        while (i < this.magnitudeCount) {
            if (sample < (long)breaks[i]) {
                result = 10 * i + (int)sample / breaks[i - 1];
                break;
            }
            ++i;
        }
        if (result >= this.histogram.length) {
            result = Math.min(Math.max(0, result), this.histogram.length - 1);
        }
        return result;
    }

    private final boolean isIndexUsed(int index) {
        return index == 0 || index == this.histogram.length - 1 || index % 10 != 0;
    }

    private final int valueForIndex(int index) {
        if (index == this.histogram.length - 1) {
            return this.valueForIndex(index - 10 + 1) * 10;
        }
        int magnitude = index / 10;
        int mult = magnitude == 0 ? 1 : breaks[magnitude - 1];
        return index % 10 * mult;
    }

    private String labelForIndex(int index) {
        if (index == this.histogram.length - 1) {
            return ">= " + this.labelForIndex(index + 1);
        }
        return Integer.toString(this.valueForIndex(index));
    }

    public final void recordSample(long sample) {
        int n = this.indexForSample(sample);
        this.histogram[n] = this.histogram[n] + 1L;
        if (sample > this.max) {
            this.max = sample;
        }
    }

    public final void addHistogram(NSHistogram other) {
        int i = 0;
        while (i < this.histogram.length) {
            int n = i;
            this.histogram[n] = this.histogram[n] + other.histogram[i];
            ++i;
        }
        if (other.max > this.max) {
            this.max = other.max;
        }
    }

    public final void subtractHistogram(NSHistogram other) {
        int i = 0;
        while (i < this.histogram.length) {
            int n = i;
            this.histogram[n] = this.histogram[n] - other.histogram[i];
            ++i;
        }
        if (other.max > this.max) {
            this.max = other.max;
        }
    }

    public final void reset() {
        Arrays.fill(this.histogram, 0L);
        this.max = 0L;
    }

    public final Map<String, Long> getSamples() {
        HashMap<String, Long> h = new HashMap<String, Long>();
        int i = 0;
        while (i < this.histogram.length) {
            if (this.isIndexUsed(i)) {
                h.put(this.labelForIndex(i), this.histogram[i]);
            }
            ++i;
        }
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, Double> addPercentilesToMap(Map<String, Double> map) {
        long[] lArray = this.histogram;
        synchronized (this.histogram) {
            this.computeCount();
            this.addPercentiles(map, defaultPercentilePoints, defaultPercentileNames);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized double getPercentile(double percentile) {
        long[] lArray = this.histogram;
        synchronized (this.histogram) {
            Number v;
            block4: {
                this.computeCount();
                HashMap<String, Double> map = new HashMap<String, Double>();
                this.addPercentiles(map, new double[]{percentile}, new String[]{"default"});
                v = (Number)map.get("default");
                if (v != null) break block4;
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return 0.0;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return v.doubleValue();
        }
    }

    private final void computeCount() {
        this.count = 0L;
        int i = 0;
        while (i < this.histogram.length) {
            this.count += this.histogram[i];
            ++i;
        }
    }

    private final double round(double v) {
        return Math.floor(v * 100.0 + 0.5) / 100.0;
    }

    private final void addPercentiles(Map<String, Double> map, double[] percentilePoints, String[] percentileNames) {
        int currentPercentilePoint = 0;
        double percentilePoint = percentilePoints[currentPercentilePoint];
        long breakPoint = (long)this.breakPoint(percentilePoint);
        double interpolate = this.breakPoint(percentilePoint) - (double)breakPoint;
        long bucketStartSample = 1L;
        long Xi = 0L;
        boolean pendingSample = false;
        int i = 0;
        block0: while (i < this.histogram.length) {
            if (this.isIndexUsed(i)) {
                long samplesInBucket = this.histogram[i];
                if (bucketStartSample + samplesInBucket <= breakPoint) {
                    bucketStartSample += samplesInBucket;
                } else if (this.histogram[i] != 0L) {
                    long right;
                    long left;
                    if (i == this.histogram.length - 1) {
                        left = this.histogram[i] == 1L ? this.max : (long)this.valueForIndex(i);
                        right = this.max;
                    } else {
                        left = this.valueForIndex(i);
                        right = this.isIndexUsed(i + 1) ? this.valueForIndex(i + 1) : this.valueForIndex(i + 2);
                        right = Math.min(right, this.max);
                    }
                    long width = right - left;
                    while (bucketStartSample + samplesInBucket > breakPoint) {
                        double value;
                        long Xi1;
                        long bucketSampleIndex = breakPoint - bucketStartSample + 1L;
                        if (pendingSample) {
                            Xi1 = this.xi(samplesInBucket, left, width, 1L, breakPoint);
                            value = this.interpolate(interpolate, Xi, Xi1);
                        } else {
                            Xi = this.xi(samplesInBucket, left, width, bucketSampleIndex, breakPoint);
                            if (interpolate > 0.001) {
                                if (breakPoint == this.count) {
                                    value = this.interpolate(interpolate, Xi, this.max);
                                } else {
                                    if (bucketSampleIndex + 1L > samplesInBucket) {
                                        pendingSample = true;
                                        break;
                                    }
                                    Xi1 = this.xi(samplesInBucket, left, width, bucketSampleIndex + 1L, breakPoint + 1L);
                                    value = this.interpolate(interpolate, Xi, Xi1);
                                }
                            } else {
                                value = Xi;
                            }
                        }
                        map.put(percentileNames[currentPercentilePoint], this.round(value));
                        if (++currentPercentilePoint == percentilePoints.length) {
                            pendingSample = false;
                            break block0;
                        }
                        long oldBreakPoint = breakPoint;
                        percentilePoint = percentilePoints[currentPercentilePoint];
                        breakPoint = (long)this.breakPoint(percentilePoint);
                        interpolate = this.breakPoint(percentilePoint) - (double)breakPoint;
                        if (oldBreakPoint == breakPoint) continue;
                        pendingSample = false;
                    }
                    bucketStartSample += samplesInBucket;
                }
            }
            ++i;
        }
    }

    private final double interpolate(double interpolate, long Xi, long Xi1) {
        return (double)Xi + (double)(Xi1 - Xi) * interpolate;
    }

    private final long xi(long samples, long left, long width, long index, long globalIndex) {
        if (globalIndex >= this.count) {
            return this.max;
        }
        return left + index * width / (samples + 1L);
    }

    private final double breakPoint(double percentilePoint) {
        return (double)(this.count - 1L) * percentilePoint + 1.0;
    }

    public void setMaxFromHistogram() {
        long max = 0L;
        int z = 0;
        while (z < this.histogram.length) {
            if (this.histogram[z] > 0L) {
                max = bucketValues[z];
            }
            ++z;
        }
        this.max = max;
    }
}

