/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.stats;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSSizeLimitedLinkedHashMap;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation.stats.event.NSSizeEvent;
import com.webobjects.foundation.stats.event.NSStatsAbstractLiveEvent;
import com.webobjects.foundation.stats.event.NSStatsEvent;
import com.webobjects.foundation.stats.event.NSStatsLiveOtherEvent;
import com.webobjects.foundation.stats.event.NSTimeEvent;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSStats {
    private static final Logger log = LoggerFactory.getLogger(NSStats.class);
    private static NSStats _sharedStats;
    public static final char DELIM = '\t';
    public static final boolean StatsEnabled;
    public static final boolean AllowStackTraces;
    protected static int TimeEventBucketSize;
    protected static String TimeEventBucketStartTime;
    protected final Map<String, NSStatsAbstractLiveEvent> _otherEvents;
    protected final Map<String, NSTimeEvent> _otherTimeEvents;
    protected final Map<String, NSSizeEvent> _sizeEvents;
    private final Map<String, NSCacheMonitor> _allMonitoredCaches = new HashMap<String, NSCacheMonitor>(8);
    private long _totalRequests;
    protected final int _movingAverageSampleSize;
    private long _cumulativesTimeCheckpoint;
    private final Date _creationDate;
    private final List<NSThrowableEvent> _recentThrowables;
    private long _totalExceptions;
    protected static MBeanServer mbs;
    public static final String NSStatsMovingAverageSampleSizeKey = "NSStats.movingAverageSampleSize";
    public static final String OtherEventsMapSizeKey = "NSOtherEventsMapSize";
    public static final String OtherTimeEventsMapSizeKey = "NSOtherTimeEventsMapSize";
    public static final String SizeEventsMapSizeKey = "NSSizeEventsMapSize";

    static {
        boolean statsEnabled = false;
        NSStats sharedStats = null;
        boolean allowStackTraces = false;
        if (NSStats.jmxStatsEnabled()) {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        try {
            statsEnabled = NSProperties.booleanForKeyWithDefault("NSStats.statsEnabled", true);
            String statisticsClassName = NSProperties.stringForKeyWithDefault("NSStats.className", NSStats.class.getName());
            sharedStats = (NSStats)Class.forName(statisticsClassName).newInstance();
            allowStackTraces = NSProperties.booleanForKeyWithDefault("NSStats.allowTraces", false);
            TimeEventBucketSize = NSProperties.intForKeyWithDefault("NSStats.timeEventBucketSize", 8);
            TimeEventBucketStartTime = NSProperties.stringForKeyWithDefault("NSStats.timeEventStartTime", "0.5");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        StatsEnabled = statsEnabled;
        NSStats.setSharedStats(sharedStats);
        AllowStackTraces = allowStackTraces;
    }

    public static NSStats sharedStats() {
        return _sharedStats;
    }

    public static void setSharedStats(NSStats sharedStats) {
        _sharedStats = sharedStats;
    }

    public static boolean jmxStatsEnabled() {
        return NSProperties.booleanForKeyWithDefault("NSStats.enableJMXStats", false);
    }

    public NSStats() {
        this._otherEvents = this.newOtherEventsMap();
        this._otherTimeEvents = this.newOtherTimeEventsMap();
        this._sizeEvents = this.newSizeEventsMap();
        this._movingAverageSampleSize = NSProperties.intForKeyWithDefault(NSStatsMovingAverageSampleSizeKey, 100);
        this._cumulativesTimeCheckpoint = System.currentTimeMillis();
        this._creationDate = new Date();
        this._recentThrowables = Collections.synchronizedList(new ArrayList(4));
    }

    protected Map<String, NSStatsAbstractLiveEvent> newOtherEventsMap() {
        return Collections.synchronizedMap(new NSSizeLimitedLinkedHashMap(NSProperties.intForKeyWithDefault(OtherEventsMapSizeKey, 120), false, null));
    }

    protected Map<String, NSTimeEvent> newOtherTimeEventsMap() {
        return Collections.synchronizedMap(new NSSizeLimitedLinkedHashMap(NSProperties.intForKeyWithDefault(OtherTimeEventsMapSizeKey, 120), false, null));
    }

    protected Map<String, NSSizeEvent> newSizeEventsMap() {
        return Collections.synchronizedMap(new NSSizeLimitedLinkedHashMap(NSProperties.intForKeyWithDefault(SizeEventsMapSizeKey, -1), false, null));
    }

    public Date creationDate() {
        return this._creationDate;
    }

    public int movingAverageSampleSize() {
        return this._movingAverageSampleSize;
    }

    public String cumulativesTimeCheckpoint() {
        return new Date(this._cumulativesTimeCheckpoint).toString();
    }

    public void resetCumulatives() {
        this.resetCumulatives(this._otherEvents);
        this.resetTimeCumulatives(this._otherTimeEvents);
        this._cumulativesTimeCheckpoint = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCumulatives(Map<String, ? extends NSStatsAbstractLiveEvent> events) {
        Map<String, ? extends NSStatsAbstractLiveEvent> map = events;
        synchronized (map) {
            Iterator<? extends NSStatsAbstractLiveEvent> i = events.values().iterator();
            while (i.hasNext()) {
                i.next().resetcumulatives();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTimeCumulatives(Map<String, ? extends NSTimeEvent> events) {
        Map<String, ? extends NSTimeEvent> map = events;
        synchronized (map) {
            Iterator<? extends NSTimeEvent> i = events.values().iterator();
            while (i.hasNext()) {
                i.next().resetcumulatives();
            }
        }
    }

    public synchronized long totalRequestCount() {
        return this._totalRequests;
    }

    public synchronized void incrementRequestCount() {
        ++this._totalRequests;
    }

    public long totalExceptionCount() {
        return this._totalExceptions;
    }

    public List<NSThrowableEvent> recentThrowables() {
        return this._recentThrowables;
    }

    protected String jmxEventName(String eventName) {
        return eventName.replaceAll(":", " ");
    }

    protected long _recordEvent(Map<String, NSStatsAbstractLiveEvent> events, String eventName, boolean allowStackTraces, long startTimeMillis, long endTimeMillis) {
        return this._recordEvent(events, eventName, allowStackTraces, startTimeMillis, endTimeMillis, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long _recordEvent(Map<String, NSStatsAbstractLiveEvent> events, String eventName, boolean allowStackTraces, long startTimeMillis, long endTimeMillis, long count) {
        NSStatsAbstractLiveEvent event;
        Map<String, NSStatsAbstractLiveEvent> map = events;
        synchronized (map) {
            event = events.get(eventName);
            if (event == null) {
                event = new NSStatsLiveOtherEvent(eventName, this._movingAverageSampleSize, allowStackTraces);
                if (NSStats.jmxStatsEnabled()) {
                    try {
                        String mbeanName = "com.webobjects.appserver.stats:type=" + this.jmxEventName(eventName);
                        if (log.isInfoEnabled()) {
                            log.info("JMXBeanInit: " + mbeanName);
                        }
                        ObjectName name = new ObjectName(mbeanName);
                        mbs.registerMBean(event, name);
                    }
                    catch (Exception ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                events.put(eventName, event);
            }
        }
        event.add(startTimeMillis, endTimeMillis, count);
        return endTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordTimeEvent(Map<String, NSTimeEvent> events, String eventName, long time) {
        try {
            NSTimeEvent event;
            if (events == null) {
                return;
            }
            if (eventName == null && NSProperties.booleanForKeyWithDefault("NSStats.logNullEventNames", false)) {
                log.error("Attempt to record null eventName in recordTimeEvent", (Throwable)new Exception("recordTimeEvent: null event name"));
            }
            Map<String, NSTimeEvent> map = events;
            synchronized (map) {
                event = events.get(eventName);
                if (event == null) {
                    event = new NSTimeEvent(eventName, TimeEventBucketSize, Float.parseFloat(TimeEventBucketStartTime));
                    events.put(eventName, event);
                }
            }
            event.add((float)time / 1000.0f);
        }
        catch (Throwable t) {
            log.error("Failed to record time event for '" + eventName + "'.", t);
        }
    }

    protected long _recordEvent(String eventName, long startTimeMillis, long driftThesholdMillis, Map<String, NSStatsAbstractLiveEvent> events, Map<String, NSTimeEvent> timeEvents, boolean allowStackTraces) {
        return this._recordEvent(eventName, startTimeMillis, driftThesholdMillis, events, timeEvents, allowStackTraces, 1L);
    }

    protected long _recordEvent(String eventName, long startTimeMillis, long driftThesholdMillis, Map<String, NSStatsAbstractLiveEvent> events, Map<String, NSTimeEvent> timeEvents, boolean allowStackTraces, long count) {
        try {
            long endTimeMillis;
            long l = endTimeMillis = startTimeMillis == 0L ? 0L : System.currentTimeMillis();
            if (endTimeMillis + driftThesholdMillis < startTimeMillis) {
                log.error("The event '" + eventName + "' had an end time that was less than the start time (end=" + endTimeMillis + " vs start=" + startTimeMillis + ")", (Throwable)new RuntimeException("This logged exception is just to help track down the root cause of the negative timing information."));
            }
            long l2 = this._recordEvent(events, eventName, allowStackTraces, startTimeMillis, endTimeMillis, count);
            this.recordTimeEvent(timeEvents, eventName, endTimeMillis - startTimeMillis);
            return l2;
        }
        catch (Throwable t) {
            log.error("Failed to record event for '" + eventName + "'.", t);
            return System.currentTimeMillis();
        }
    }

    public long recordCountEvent(String eventName, long startTimeMillis, long count) {
        return this._recordEvent(eventName, startTimeMillis, 0L, this._otherEvents, this._otherTimeEvents, false, count);
    }

    public long recordCountEvent(String eventName, long count) {
        return this._recordEvent(eventName, System.currentTimeMillis() - count * 1000L, 0L, this._otherEvents, this._otherTimeEvents, false);
    }

    public long recordDimensionalEvent(String eventType, String eventValue, String eventName, long startTimeMillis) {
        return this._recordEvent("||" + eventType + "||" + eventValue + "||" + eventName + "||", startTimeMillis, 0L, this._otherEvents, this._otherTimeEvents, false);
    }

    public long recordEvent(String eventName, long startTimeMillis) {
        return this._recordEvent(eventName, startTimeMillis, 0L, this._otherEvents, this._otherTimeEvents, false);
    }

    public long recordEvent(String eventName, long startTimeMillis, boolean allowStackTraces) {
        return this._recordEvent(eventName, startTimeMillis, 0L, this._otherEvents, this._otherTimeEvents, allowStackTraces);
    }

    public long recordEvent(String eventName, long startTimeMillis, long driftThesholdMillis) {
        return this._recordEvent(eventName, startTimeMillis, driftThesholdMillis, this._otherEvents, this._otherTimeEvents, false);
    }

    public long recordEvent(String eventName, long startTimeMillis, long driftThesholdMillis, boolean allowStackTraces) {
        return this._recordEvent(eventName, startTimeMillis, driftThesholdMillis, this._otherEvents, this._otherTimeEvents, allowStackTraces);
    }

    public NSStatsEvent getEvent(String eventName) {
        return this._otherEvents.get(eventName);
    }

    public NSSizeEvent getSizeEvent(String eventName) {
        return this._sizeEvents.get(eventName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordSizeEvent(String eventName, int size) {
        try {
            NSSizeEvent event;
            Map<String, NSSizeEvent> map = this._sizeEvents;
            synchronized (map) {
                event = this._sizeEvents.get(eventName);
                if (event == null) {
                    event = new NSSizeEvent(eventName, 1);
                    this._sizeEvents.put(eventName, event);
                }
            }
            event.add(size);
        }
        catch (Throwable t) {
            log.error("Failed to record size event for '" + eventName + "'.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <E extends NSStatsEvent> NSStatsEvent[] _events(Comparator<? super E> comparator, String eventsPattern, Map<String, ? extends E> namedEvents) {
        ArrayList<? extends E> list;
        Map<String, E> map = namedEvents;
        synchronized (map) {
            int size = namedEvents.size();
            list = new ArrayList<E>(size);
            list.addAll(namedEvents.values());
        }
        if (eventsPattern != null && !eventsPattern.equals("")) {
            if (log.isDebugEnabled()) {
                log.debug("_events()/eventsPattern: " + eventsPattern);
            }
            Iterator i = list.iterator();
            while (i.hasNext()) {
                NSStatsEvent event = (NSStatsEvent)i.next();
                String eventName = event.name();
                if (_NSStringUtilities.stringMatchesPattern(eventName == null ? "" : eventName, eventsPattern, true)) continue;
                i.remove();
            }
        }
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
        NSStatsEvent[] events = list.toArray(new NSStatsEvent[list.size()]);
        return events;
    }

    public NSStatsEvent[] otherEvents(Comparator<? super NSStatsAbstractLiveEvent> comparator) {
        return this.otherEvents(comparator, null);
    }

    public NSStatsEvent[] otherEvents(Comparator<? super NSStatsAbstractLiveEvent> comparator, String eventsPattern) {
        return this._events(comparator, eventsPattern, this._otherEvents);
    }

    public NSSizeEvent[] sizeEvents() {
        return this._sizeEvents.values().toArray(new NSSizeEvent[0]);
    }

    public NSTimeEvent[] otherTimeEvents() {
        return this._otherTimeEvents.values().toArray(new NSTimeEvent[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordException(Throwable throwable) {
        List<NSThrowableEvent> list = this._recentThrowables;
        synchronized (list) {
            if (this._recentThrowables.size() >= 10) {
                this._recentThrowables.remove(0);
            }
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        NSThrowableEvent throwableEvent = new NSThrowableEvent(throwable);
        this._recentThrowables.add(throwableEvent);
        ++this._totalExceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putMonitoredCache(String name, NSCacheMonitor monitor) {
        Map<String, NSCacheMonitor> map = this._allMonitoredCaches;
        synchronized (map) {
            this._allMonitoredCaches.put(name, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unmonitorCache(String name) {
        Map<String, NSCacheMonitor> map = this._allMonitoredCaches;
        synchronized (map) {
            this._allMonitoredCaches.remove(name);
        }
    }

    public boolean isMonitoringCache(String name) {
        return this._allMonitoredCaches.containsKey(name);
    }

    public void monitorCache(String name, NSDictionary<?, ?> dictionary) {
        NSCacheMonitor monitor = NSCacheMonitor.newInstance(name, dictionary);
        this.putMonitoredCache(name, monitor);
    }

    public void monitorCache(String name, NSArray<?> array) {
        NSCacheMonitor monitor = NSCacheMonitor.newInstance(name, array);
        this.putMonitoredCache(name, monitor);
    }

    public void monitorCache(String name, Collection<?> collection) {
        NSCacheMonitor monitor = NSCacheMonitor.newInstance(name, collection);
        this.putMonitoredCache(name, monitor);
    }

    public void monitorCache(String name, Map<?, ?> map) {
        NSCacheMonitor monitor = NSCacheMonitor.newInstance(name, map);
        this.putMonitoredCache(name, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NSCacheMonitor[] cacheMonitors() {
        Object[] cacheMonitors;
        Map<String, NSCacheMonitor> map = this._allMonitoredCaches;
        synchronized (map) {
            cacheMonitors = this._allMonitoredCaches.values().toArray(new NSCacheMonitor[0]);
        }
        Arrays.sort(cacheMonitors);
        return cacheMonitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCacheLookup(String name) {
        try {
            Map<String, NSCacheMonitor> map = this._allMonitoredCaches;
            synchronized (map) {
                NSCacheMonitor cacheMonitor = this._allMonitoredCaches.get(name);
                cacheMonitor.recordLookup();
            }
        }
        catch (Throwable t) {
            log.error("Failed to record cache lookup for '" + name + "'.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordCacheMiss(String name) {
        try {
            Map<String, NSCacheMonitor> map = this._allMonitoredCaches;
            synchronized (map) {
                NSCacheMonitor cacheMonitor = this._allMonitoredCaches.get(name);
                cacheMonitor.recordMiss();
            }
        }
        catch (Throwable t) {
            log.error("Failed to record cache miss for '" + name + "'.", t);
        }
    }

    public static abstract class NSCacheMonitor
    implements Comparable<NSCacheMonitor> {
        public static final String[] KEYS_ARRAY = new String[]{"name", "size", "lookupCount", "currentCacheAccessPercentage", "missCount", "currentCacheHitPercentage", "date"};
        private final String _name;
        private final Date _creationDate;
        private int _lookupCount;
        private int _missCount;

        public abstract int size();

        private NSCacheMonitor(String name) {
            this._name = name;
            if (name == null) {
                throw new IllegalArgumentException("NSCacheMonitor: name cannot be null.");
            }
            this._creationDate = new Date();
        }

        public static NSCacheMonitor newInstance(String name, NSDictionary<?, ?> nsdictionary) {
            return new NSDictionaryMonitor(name, nsdictionary);
        }

        public static NSCacheMonitor newInstance(String name, NSArray<?> nsarray) {
            return new NSArrayMonitor(name, nsarray);
        }

        public static NSCacheMonitor newInstance(String name, Map<?, ?> map) {
            return new NSMapMonitor(name, map);
        }

        public static NSCacheMonitor newInstance(String name, Collection<?> collection) {
            return new NSCollectionMonitor(name, collection);
        }

        public String name() {
            return this._name;
        }

        public Date date() {
            return this._creationDate;
        }

        public int lookupCount() {
            return this._lookupCount;
        }

        public int missCount() {
            return this._missCount;
        }

        public void recordLookup() {
            ++this._lookupCount;
        }

        public void recordMiss() {
            ++this._missCount;
        }

        public float currentCacheAccessPercentage() {
            long totalRequestCount = NSStats.sharedStats().totalRequestCount();
            return totalRequestCount == 0L ? 0.0f : this.currentCacheAccessPercentage(totalRequestCount);
        }

        public float currentCacheAccessPercentage(float totalRequestCount) {
            return 100.0f * ((float)this._lookupCount / totalRequestCount);
        }

        public float currentCacheHitPercentage() {
            if (this._lookupCount > 0) {
                return 100.0f * ((float)(this._lookupCount - this._missCount) / (float)this._lookupCount);
            }
            return 0.0f;
        }

        @Override
        public int compareTo(NSCacheMonitor otherObject) {
            return NSValueUtilities.compare(otherObject.size(), this.size());
        }

        protected void verifyCache(Object object) {
            if (object == null) {
                throw new IllegalArgumentException("NSCacheMonitor: cache cannot be null.");
            }
        }

        public static final class NSArrayMonitor
        extends NSCacheMonitor {
            private final NSArray<?> _array;

            private NSArrayMonitor(String name, NSArray<?> array) {
                super(name);
                this.verifyCache(array);
                this._array = array;
            }

            @Override
            public int size() {
                return this._array.count();
            }
        }

        public static final class NSCollectionMonitor
        extends NSCacheMonitor {
            private final Collection<?> _collection;

            private NSCollectionMonitor(String name, Collection<?> collection) {
                super(name);
                this.verifyCache(collection);
                this._collection = collection;
            }

            @Override
            public int size() {
                return this._collection.size();
            }
        }

        public static final class NSDictionaryMonitor
        extends NSCacheMonitor {
            private final NSDictionary<?, ?> _dictionary;

            private NSDictionaryMonitor(String name, NSDictionary<?, ?> dictionary) {
                super(name);
                this.verifyCache(dictionary);
                this._dictionary = dictionary;
            }

            @Override
            public int size() {
                return this._dictionary.count();
            }
        }

        public static final class NSMapMonitor
        extends NSCacheMonitor {
            private final Map<?, ?> _map;

            private NSMapMonitor(String name, Map<?, ?> map) {
                super(name);
                this.verifyCache(map);
                this._map = map;
            }

            @Override
            public int size() {
                return this._map.size();
            }
        }
    }

    public static final class NSThrowableEvent {
        private final Throwable _throwable;
        private final Date _creationDate;

        public NSThrowableEvent(Throwable throwable) {
            this._throwable = throwable;
            this._creationDate = new Date();
        }

        public Throwable throwable() {
            return this._throwable;
        }

        public Date creationDate() {
            return this._creationDate;
        }
    }
}

