/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSSourceFactory;
import com.webobjects.foundation.properties.NSWOPropertiesFileErrorDelegate;
import java.io.File;

public class NSWOPropertiesFileSourceFactory
extends NSSourceFactory {
    public static final String NS_GLOBAL_PROPERTIES_PATH = "NSGlobalPropertiesPath";
    private static final String LEGACY_GLOBAL_PROPERTIES_PATH = "WebObjectsPropertiesReplacement";

    @Override
    public NSArray<NSPropertySource> sourcesForProperties(NSPropertiesCoordinator properties) {
        NSMutableArray<int> sources = new NSMutableArray<int>(2);
        String userhome = System.getProperty("user.home");
        boolean validateProperties = Boolean.valueOf(System.getProperty("NSValidateProperties", "true"));
        boolean globalPropertiesPathOverride = false;
        NSMutableArray<File> filesToCheck = new NSMutableArray<File>();
        String wopropsfile = System.getProperty(NS_GLOBAL_PROPERTIES_PATH);
        if (wopropsfile == null) {
            wopropsfile = System.getProperty(LEGACY_GLOBAL_PROPERTIES_PATH);
        }
        if (wopropsfile != null && wopropsfile.length() > 0) {
            if (userhome != null && userhome.length() > 0 && !new File(wopropsfile).isAbsolute()) {
                filesToCheck.addObject(new File(userhome, wopropsfile));
            }
            filesToCheck.addObject(new File(wopropsfile));
            globalPropertiesPathOverride = true;
        } else if (userhome != null && userhome.length() > 0) {
            filesToCheck.addObject(new File(userhome, "WebObjects.properties"));
        }
        File propsFile = null;
        int i = 0;
        while (i < filesToCheck.count()) {
            boolean loadGlobalProperties;
            propsFile = (File)filesToCheck.objectAtIndex(i);
            if (validateProperties && globalPropertiesPathOverride) {
                loadGlobalProperties = true;
            } else {
                boolean bl = loadGlobalProperties = propsFile.exists() && propsFile.isFile() && propsFile.canRead();
            }
            if (loadGlobalProperties) {
                NSPropertyFileSource source = new NSPropertyFileSource(properties, propsFile, NSProperties._shouldRequireSymlinkedGlobalAndIncludeProperties());
                source.setFileErrorDelegate(new NSWOPropertiesFileErrorDelegate(validateProperties || globalPropertiesPathOverride));
                sources.addObject((int)source);
            }
            ++i;
        }
        if (sources.count() == 0 && globalPropertiesPathOverride && validateProperties) {
            throw new RuntimeException("There was no global properties file '" + wopropsfile + "'.");
        }
        return sources;
    }
}

