/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import com.webobjects.foundation.properties._NSPropertyUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSWOPropertiesFileErrorDelegate {
    private static final Logger log = LoggerFactory.getLogger(NSWOPropertiesFileErrorDelegate.class);
    private boolean _validateProperties;

    public NSWOPropertiesFileErrorDelegate(boolean validateProperties) {
        this._validateProperties = validateProperties;
    }

    public void handleLoadingError(NSPropertiesCoordinator coordinator, NSPropertyFileSource.NSFileLocation failedFile, NSArray<NSPropertyFileSource.NSFileLocation> includeChain, Exception exception) {
        String fileDescription = _NSPropertyUtilities.descriptionForFileAndIncludeChain(failedFile, includeChain);
        if (this._validateProperties) {
            throw new RuntimeException("Failed to load " + fileDescription + ": " + exception.getMessage(), exception);
        }
        log.error("Failed to load {}", (Object)fileDescription, (Object)exception);
    }
}

