/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.properties.NSMemoryPropertySource;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValue;

public class NSSystemPropertiesSource
extends NSMemoryPropertySource {
    private static NSDictionary<String, String> _initialSystemProperties;

    public NSSystemPropertiesSource(NSPropertiesCoordinator coordinator) {
        super(coordinator);
    }

    public static void registerSystemProperties() {
        _initialSystemProperties = NSSystemPropertiesSource.buildInitialSystemProperties();
    }

    protected static NSDictionary<String, String> buildInitialSystemProperties() {
        NSMutableDictionary<String, String> dict = new NSMutableDictionary<String, String>(50);
        for (Object keyObj : System.getProperties().keySet()) {
            String key = (String)keyObj;
            dict.setObjectForKey(System.getProperty(key), key);
        }
        return dict.immutableClone();
    }

    @Override
    public void load(NSMutableArray<NSPropertyValidationError> errors) {
        if (_initialSystemProperties != null) {
            for (String key : _initialSystemProperties.allKeys()) {
                this._values.addObject(new NSPropertyValue(key, _initialSystemProperties.objectForKey(key), this));
            }
        }
    }

    @Override
    public String traceSources(boolean includeRawProperties) {
        return "---- Begin system properties source:\n" + super.traceSources(includeRawProperties) + "---- End system properties source\n";
    }

    @Override
    public String toString() {
        return "system properties source";
    }
}

