/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertySource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NSSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(NSSourceFactory.class);

    public abstract NSArray<NSPropertySource> sourcesForProperties(NSPropertiesCoordinator var1);

    public static String processedPropertiesPath(String originalPropertiesPath) {
        String propertiesPath = null;
        if (originalPropertiesPath != null) {
            propertiesPath = NSSourceFactory.processedPropertiesPath(new File(originalPropertiesPath));
        }
        return propertiesPath;
    }

    public static String processedPropertiesPath(File originalPropertiesFile) {
        String propertiesPath = null;
        if (originalPropertiesFile != null) {
            propertiesPath = Boolean.valueOf(System.getProperty("NSProperties.canonicalizePropertiesPaths", "false")) != false ? NSSourceFactory.safeCanonicalPath(originalPropertiesFile) : originalPropertiesFile.getAbsolutePath();
        }
        return propertiesPath;
    }

    protected static String safeCanonicalPath(File file) {
        String propertiesPath = null;
        if (file != null) {
            try {
                propertiesPath = file.getCanonicalPath();
            }
            catch (IOException e) {
                log.error("The file '{}' does not exist: {}", (Object)file, (Object)e.getMessage());
            }
        }
        return propertiesPath;
    }

    public static URL processedPropertiesURL(URL unprocessedURL) throws FileNotFoundException, URISyntaxException, MalformedURLException {
        URL processedPropertiesURL = unprocessedURL;
        if (unprocessedURL != null && "file".equalsIgnoreCase(unprocessedURL.getProtocol())) {
            File userPropertiesFile = new File(unprocessedURL.toURI());
            if (userPropertiesFile.isFile() && userPropertiesFile.canRead()) {
                String processedPropertiesPath = NSSourceFactory.processedPropertiesPath(userPropertiesFile);
                processedPropertiesURL = new File(processedPropertiesPath).toURI().toURL();
            } else {
                throw new FileNotFoundException("Properties file is a directory or not readable: " + unprocessedURL);
            }
        }
        return processedPropertiesURL;
    }
}

