/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyProcessor;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValue;

public class NSSecureProcessor
extends NSPropertyProcessor {
    private static final String SECURE_KEY_TOKEN = "@secureKey";
    private static final String SECURE_TOKEN = "@secure";

    @Override
    public void preProcess(NSMutableArray<NSPropertyValue> values, NSMutableArray<NSPropertyValidationError> errors, NSPropertiesCoordinator coordinator) {
        NSArray<NSPropertyValue> valuesClone = values.immutableClone();
        for (NSPropertyValue value : valuesClone) {
            String key = value.currentKey();
            String parameter = this.parameterInKeyForElement(key, SECURE_TOKEN);
            if (parameter != null && parameter.length() > 0) {
                value.setSecure(true);
                value.setSecureKeyName(parameter);
                value.setProcessedKey(this.keyByRemovingElementAndNextElements(key, SECURE_TOKEN, 1));
                continue;
            }
            if (!this.keyContainsElement(key, SECURE_KEY_TOKEN)) continue;
            String secureKey = this.keyByRemovingElement(key, SECURE_KEY_TOKEN);
            coordinator.setSecureKeyForName(value.currentValue(), secureKey);
            values.removeObject(value);
        }
    }

    @Override
    public void postProcess(NSPropertiesCoordinator coordinator, NSMutableArray<NSPropertyValidationError> errors) {
    }
}

