/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation.properties.NSBooleanProperty;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSPropertyTypeValidationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSPropertyValue {
    private String _originalValue;
    private String _originalKey;
    private String _processedValue;
    private String _processedKey;
    private ValueAppendingOperator _valueAppendingOperator;
    private NSPropertySource _source;
    private NSPropertyValue _overriddenValue;
    private boolean _final;
    private boolean _abstract;
    private boolean _visible;
    private boolean _override;
    private boolean _secure;
    private boolean _template;
    private String _secureKeyName;
    private NSArray<Class<?>> _types;
    private boolean _hasCheckedType;
    private static NSBooleanProperty shouldThrowOnUnvalidatedAccess = new NSBooleanProperty("NSPropertyValue.shouldThrowOnUndeclaredTypeAccess", false);
    private static final Logger missingTypeDeclarationLog = LoggerFactory.getLogger((String)(String.valueOf(NSPropertyValue.class.getName()) + ".missingTypeDeclaration"));

    public NSPropertyValue(String originalKey, String originalValue, NSPropertySource source) {
        this._source = source;
        this._originalKey = originalKey;
        this._originalValue = originalValue;
        this._final = false;
        this._abstract = false;
        this._visible = true;
        this._override = false;
        this._valueAppendingOperator = ValueAppendingOperator.REPLACE;
    }

    public String originalValue() {
        return this._originalValue;
    }

    public String originalKey() {
        return this._originalKey;
    }

    public void setProcessedValue(String value) {
        this._processedValue = value;
    }

    public String processedValue() {
        return this._processedValue;
    }

    public void setProcessedKey(String key) {
        this._processedKey = key;
    }

    public String processedKey() {
        return this._processedKey;
    }

    public NSPropertySource source() {
        return this._source;
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setIsFinal(boolean isFinal) {
        this._final = isFinal;
    }

    public boolean isAbstract() {
        return this._abstract;
    }

    public void setIsAbstract(boolean isAbstract) {
        this._abstract = isAbstract;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void setVisible(boolean visible) {
        this._visible = visible;
    }

    public boolean isOverride() {
        return this._override;
    }

    public void setIsOverride(boolean isOverride) {
        this._override = isOverride;
    }

    public NSPropertyValue overriddenValue() {
        return this._overriddenValue;
    }

    public void setOverriddenValue(NSPropertyValue value) {
        this._overriddenValue = value;
        if (this._overriddenValue != null && this._overriddenValue.types() != null) {
            for (Class<?> type : this._overriddenValue.types()) {
                this.addType(type);
            }
        }
    }

    public String currentKey() {
        return this._processedKey == null ? this._originalKey : this._processedKey;
    }

    public String currentValue() {
        return this._processedValue == null ? this._originalValue : this._processedValue;
    }

    public Object clone() throws CloneNotSupportedException {
        NSPropertyValue newValue = new NSPropertyValue(this.originalKey(), this.originalValue(), this.source());
        newValue.copyDataFromValue(this);
        return newValue;
    }

    protected void copyDataFromValue(NSPropertyValue value) {
        this.setProcessedKey(value.processedKey());
        this.setProcessedValue(value.processedValue());
        this.setOverriddenValue(value.overriddenValue());
        this.setIsFinal(value.isFinal());
        this.setIsAbstract(value.isAbstract());
        this.setVisible(value.isVisible());
        this.setIsOverride(value.isOverride());
        this.setValueAppendingOperator(value.valueAppendingOperator());
        if (value.types() != null) {
            this._types = value.types().immutableClone();
        }
    }

    public String trace() {
        return this.trace(0);
    }

    public String trace(int indentation) {
        StringBuffer buffer = new StringBuffer();
        this.appendIndentation(buffer, indentation);
        if (indentation != 0) {
            buffer.append("was ");
        }
        this.traceKeyAndValue(buffer);
        buffer.append("\n");
        this.appendIndentation(buffer, indentation);
        buffer.append(this.traceSource());
        buffer.append("\n");
        this.traceExtras(buffer, indentation);
        if (this.overriddenValue() != null) {
            buffer.append("\n");
            buffer.append(this.overriddenValue().trace(1));
        }
        return buffer.toString();
    }

    protected void traceExtras(StringBuffer buffer, int indentation) {
        if (this.isAbstract() || this.isFinal() || !this.isVisible() || this.isOverride() || this.processedKey() != null || this.processedValue() != null) {
            NSMutableArray<String> elements = new NSMutableArray<String>();
            if (this.isAbstract()) {
                elements.addObject("abstract");
            }
            if (this.isFinal()) {
                elements.addObject("final");
            }
            if (!this.isVisible()) {
                elements.addObject("hidden");
            }
            if (this.isOverride()) {
                elements.addObject("override");
            }
            if (this.processedKey() != null || this.processedValue() != null) {
                elements.addObject("originally: " + this.originalKey() + "=" + this.originalValue());
            }
            this.appendIndentation(buffer, indentation);
            buffer.append("(");
            buffer.append(elements.componentsJoinedByString(", "));
            buffer.append(")\n");
        }
    }

    protected String traceSource() {
        return "from " + this._source.toString();
    }

    protected void appendIndentation(StringBuffer buffer, int indentation) {
        int i = 0;
        while (i < indentation) {
            buffer.append("    ");
            ++i;
        }
    }

    protected void traceKeyAndValue(StringBuffer buffer) {
        buffer.append(this.currentKey());
        buffer.append("=");
        buffer.append(this.currentValue());
    }

    public String toString() {
        String result = String.valueOf(this.currentKey()) + "=" + this.currentValue();
        if (this.processedKey() != null || this.processedValue() != null) {
            result = String.valueOf(result) + " (originally: " + this.originalKey() + "=" + this.originalValue() + ")";
        }
        return result;
    }

    public void setSecure(boolean secure) {
        this._secure = secure;
    }

    public boolean secure() {
        return this._secure;
    }

    public void setSecureKeyName(String secureKeyName) {
        this._secureKeyName = secureKeyName;
    }

    public String secureKeyName() {
        return this._secureKeyName;
    }

    public ValueAppendingOperator valueAppendingOperator() {
        return this._valueAppendingOperator;
    }

    public void setValueAppendingOperator(ValueAppendingOperator valueAppendingOperator) {
        if (valueAppendingOperator == null) {
            throw new IllegalArgumentException("The value appending operator can never be null.");
        }
        this._valueAppendingOperator = valueAppendingOperator;
    }

    public void _applyAppendingOperator() {
        String overriddenStringValue = null;
        if (this.overriddenValue() != null) {
            overriddenStringValue = this.overriddenValue().currentValue();
        }
        String currentValue = this.currentValue();
        String newValue = this.valueAppendingOperator().appendValue(overriddenStringValue, currentValue);
        if (newValue != currentValue) {
            this.setProcessedValue(newValue);
        }
    }

    public boolean isTemplate() {
        return this._template;
    }

    public void setIsTemplate(boolean template) {
        this._template = template;
    }

    public NSArray<Class<?>> types() {
        return this._types;
    }

    public void addType(Class<?> _type) {
        if (this._types == null) {
            this._types = new NSArray(_type);
        } else if (!this._types.contains(_type)) {
            this._types = NSArray.arrayByAddingObject(this._types, _type);
        }
    }

    public boolean hasType(Class<?> expected) {
        return this.types() != null && this.types().contains(expected);
    }

    public void validateForType(Class<?> expected) {
        if (!this._hasCheckedType && !this.hasType(expected)) {
            String typeKey = NSPropertyTypeValidationProcessor.typeKeyForClass(expected);
            if (shouldThrowOnUnvalidatedAccess.value().booleanValue()) {
                this._hasCheckedType = true;
                throw new IllegalArgumentException("Accessed property " + this.currentKey() + " as " + expected.getSimpleName() + " without type declaration on original key " + this.originalKey() + ".  Add ." + typeKey + " to property key to avoid this exception. Trace:\n" + this.trace());
            }
            missingTypeDeclarationLog.warn("Accessed  property {} as {} without type declaration on original key {}.  Add .{} to property key to avoid this message. Trace:\n{}", new Object[]{this.currentKey(), expected.getSimpleName(), this.originalKey(), typeKey, this.trace()});
        }
        this._hasCheckedType = true;
    }

    public static enum ValueAppendingOperator {
        REPLACE(null){

            @Override
            public String appendValue(String previousValue, String value) {
                return value;
            }
        }
        ,
        ADD("@add"){

            @Override
            public String appendValue(String previousValue, String value) {
                NSMutableArray previousArrayValue = this.valueAsArray(previousValue).mutableClone();
                NSArray arrayValue = this.valueAsArray(value);
                for (Object object : arrayValue) {
                    if (previousArrayValue.containsObject(object)) continue;
                    previousArrayValue.addObject(object);
                }
                return NSPropertyListSerialization.stringFromPropertyList(previousArrayValue, false);
            }
        }
        ,
        REMOVE("@remove"){

            @Override
            public String appendValue(String previousValue, String value) {
                NSMutableArray previousArrayValue = this.valueAsArray(previousValue).mutableClone();
                NSArray arrayValue = this.valueAsArray(value);
                previousArrayValue.removeObjectsInArray(arrayValue);
                return NSPropertyListSerialization.stringFromPropertyList(previousArrayValue, false);
            }
        };

        private String _keyElement;

        private ValueAppendingOperator(String keyElement) {
            this._keyElement = keyElement;
        }

        public abstract String appendValue(String var1, String var2);

        public String keyElement() {
            return this._keyElement;
        }

        public boolean hasKeyElement() {
            return this.keyElement() != null;
        }

        protected NSArray valueAsArray(String value) {
            if (value == null) {
                return NSArray.EmptyArray;
            }
            try {
                return NSValueUtilities.arrayValue(value);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse property value as an array for adding/removing elements: " + value, e);
            }
        }
    }
}

