/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyValue;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class NSPropertyUsageTracker {
    public static final String ReferenceTrackingEnabledKey = "NSPropertyUsageTracker.referenceTrackingEnabled";
    public static final String ReferenceStackTraceEnabledKey = "NSPropertyUsageTracker.referenceStackTraceEnabled";
    public static final String PropertyReferenceKey = "propertyReference";
    public static final String PropertyValueKey = "propertyValue";
    public static final String PropertyReferenceFileKey = "file";
    public static final String PropertyReferenceClassKey = "class";
    public static final String PropertyReferenceMethodKey = "method";
    public static final String PropertyReferenceLineKey = "line";
    public static final String ThrowableKey = "throwable";
    protected static final Logger log = LoggerFactory.getLogger((String)(String.valueOf(NSPropertyUsageTracker.class.getName()) + "." + "propertyReference"));
    private static NSPropertyUsageTracker _tracker = new NSPropertyUsageTracker();
    protected volatile NSDictionary<String, String> additionalContext = NSDictionary.emptyDictionary();
    private volatile ConcurrentMap<String, PropertyReference> cachedReferences = new ConcurrentHashMap<String, PropertyReference>(500);

    protected NSPropertyUsageTracker() {
    }

    public static NSPropertyUsageTracker instance() {
        return _tracker;
    }

    public static void setInstance(NSPropertyUsageTracker tracker) {
        _tracker = tracker;
    }

    public static void recordPropertyReference(NSPropertyValue value) {
        NSPropertyUsageTracker.instance()._recordPropertyReference(value);
    }

    public static void startOutputtingReferenceData() {
        NSPropertyUsageTracker.instance()._startOutputtingReferenceData();
    }

    private void _startOutputtingReferenceData() {
        ConcurrentMap<String, PropertyReference> localCachedReferences = this.cachedReferences;
        if (localCachedReferences == null) {
            return;
        }
        this.cachedReferences = null;
        for (PropertyReference reference : localCachedReferences.values()) {
            this.outputPropertyReference(reference.key, reference.value, reference.location, reference.stackTrace);
        }
    }

    private void _recordPropertyReference(NSPropertyValue propertyValue) {
        if (this.isReferenceLoggingEnabled()) {
            ConcurrentMap<String, PropertyReference> localCachedReferences;
            String key = propertyValue.currentKey();
            String value = propertyValue.currentValue();
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            int i = 0;
            while (this.shouldIgnoreElement(stackTrace[i])) {
                ++i;
            }
            StackTraceElement propReferenceLocation = stackTrace[i];
            String stackTraceString = null;
            if (this.isStackTraceEnabledForKey(key)) {
                StringBuilder sb = new StringBuilder();
                while (i < stackTrace.length) {
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(stackTrace[i].toString());
                    ++i;
                }
                stackTraceString = sb.toString();
            }
            if ((localCachedReferences = this.cachedReferences) != null) {
                if (!localCachedReferences.containsKey(key)) {
                    localCachedReferences.putIfAbsent(key, new PropertyReference(key, value, propReferenceLocation, stackTraceString));
                }
            } else {
                this.outputPropertyReference(key, value, propReferenceLocation, stackTraceString);
            }
        }
    }

    protected boolean shouldIgnoreElement(StackTraceElement element) {
        String className = element.getClassName();
        if (className.equals(NSProperties.class.getName()) || className.equals(Thread.class.getName()) || className.startsWith(NSPropertiesCoordinator.class.getPackage().getName())) {
            return true;
        }
        NSPropertyValue value = NSPropertiesCoordinator.sharedInstance()._getPropertyValueForKey("NSPropertyUsageTracker.classNamePrefixesToIgnore");
        if (value != null) {
            NSArray classNamePrefixesToIgnore = NSValueUtilities.arrayValueWithDefault(value.currentValue(), NSArray.emptyArray());
            for (String prefix : classNamePrefixesToIgnore) {
                if (!className.startsWith(prefix)) continue;
                return true;
            }
        }
        return false;
    }

    protected void outputPropertyReference(String key, String value, StackTraceElement location, String stackTrace) {
        Map originalMDC = MDC.getCopyOfContextMap();
        NSDictionary<String, String> additionalContextCopy = this.additionalContext.immutableClone();
        try {
            String valueAsString;
            MDC.put((String)PropertyReferenceKey, (String)key);
            String string = valueAsString = value == null ? "(null)" : value;
            if (key.toLowerCase().indexOf("password") > -1) {
                valueAsString = "(omitted)";
            }
            MDC.put((String)PropertyValueKey, (String)valueAsString);
            MDC.put((String)PropertyReferenceClassKey, (String)location.getClassName());
            MDC.put((String)PropertyReferenceMethodKey, (String)location.getMethodName());
            if (location.isNativeMethod()) {
                MDC.put((String)PropertyReferenceFileKey, (String)"(Native Method)");
            } else if (location.getFileName() != null && location.getLineNumber() >= 0) {
                MDC.put((String)PropertyReferenceFileKey, (String)location.getFileName());
                MDC.put((String)PropertyReferenceLineKey, (String)Integer.valueOf(location.getLineNumber()).toString());
            } else {
                MDC.put((String)PropertyReferenceFileKey, (String)(location.getFileName() != null ? location.getFileName() : "(Unknown Source)"));
            }
            if (stackTrace != null) {
                MDC.put((String)ThrowableKey, (String)("Property referenced at:\n" + stackTrace));
            } else {
                MDC.remove((String)ThrowableKey);
            }
            for (String aKey : additionalContextCopy.allKeys()) {
                MDC.put((String)aKey, (String)additionalContextCopy.get(aKey));
            }
            log.info(key);
        }
        finally {
            if (originalMDC != null) {
                MDC.setContextMap((Map)originalMDC);
            } else {
                MDC.clear();
            }
        }
    }

    protected boolean isReferenceLoggingEnabled() {
        return this.booleanForKeyWithDefault(ReferenceTrackingEnabledKey, false);
    }

    protected boolean isStackTraceEnabledForKey(String currentKey) {
        return this.booleanForKeyWithDefault(ReferenceStackTraceEnabledKey, false) || this.booleanForKeyWithDefault("NSPropertyUsageTracker.referenceStackTraceEnabledFor." + currentKey, false);
    }

    public synchronized void addAdditionalPropertyReferenceContext(String key, String value) {
        NSMutableDictionary<String, String> context = this.additionalContext.mutableClone();
        context.setObjectForKey(value, key);
        this.additionalContext = context.immutableClone();
    }

    public synchronized void removeAdditionalPropertyReferenceContext(String key) {
        NSMutableDictionary<String, String> context = this.additionalContext.mutableClone();
        context.remove(key);
        this.additionalContext = context.immutableClone();
    }

    private boolean booleanForKeyWithDefault(String key, boolean defaultValue) {
        boolean result = defaultValue;
        NSPropertyValue value = NSPropertiesCoordinator.sharedInstance()._getPropertyValueForKey(key);
        if (value != null) {
            result = NSValueUtilities.booleanValue(value.currentValue());
        }
        return result;
    }

    protected class PropertyReference {
        public String key;
        public String value;
        public StackTraceElement location;
        public String stackTrace;

        public PropertyReference(String key, Object value, StackTraceElement location, String stackTrace) {
            this.key = key;
            this.value = value == null ? null : value.toString();
            this.location = location;
            this.stackTrace = stackTrace;
        }
    }
}

