/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyProcessor;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSPropertyTypeValidationProcessor
extends NSPropertyProcessor {
    private static Logger log = LoggerFactory.getLogger(NSPropertyTypeValidationProcessor.class);
    private static final NSArray<TypeValidator> typeValidators = new NSArray<TypeValidator>(new TypeValidator("@array", "an array", (Class)NSArray.class){

        @Override
        public void validateValue(NSPropertyValue v) {
            NSValueUtilities.arrayValue(v.originalValue());
        }
    }, new TypeValidator("@dictionary", "a dictionary", (Class)NSDictionary.class){

        @Override
        public void validateValue(NSPropertyValue v) {
            NSValueUtilities.dictionaryValue(v.originalValue());
        }
    }, new TypeValidator("@set", "a set", (Class)NSSet.class){

        @Override
        public void validateValue(NSPropertyValue v) {
            NSSet setValue = NSValueUtilities.setValue(v.originalValue());
            NSArray arrayValue = NSValueUtilities.arrayValue(v.originalValue());
            if (setValue.count() != arrayValue.count()) {
                log.warn("Value for set property " + v.originalKey() + " has duplicate values");
            }
        }
    }, new TypeValidator("@data", "bytes of data", (Class)NSData.class){

        @Override
        public void validateValue(NSPropertyValue v) {
            NSValueUtilities.dataValue(v.originalValue());
        }
    });

    public static String typeKeyForClass(Class<?> type) {
        for (TypeValidator validator : typeValidators) {
            if (!validator.typeClass().equals(type)) continue;
            return validator.typeKey();
        }
        throw new IllegalArgumentException("No validator for " + type);
    }

    @Override
    public void preProcess(NSMutableArray<NSPropertyValue> values, NSMutableArray<NSPropertyValidationError> errors, NSPropertiesCoordinator coordinator) {
        for (NSPropertyValue value : values) {
            for (TypeValidator validator : typeValidators) {
                String key = value.currentKey();
                if (!this.keyContainsElement(key, validator.typeKey())) continue;
                try {
                    validator.validateValue(value);
                    value.setProcessedKey(this.keyByRemovingElement(key, validator.typeKey()));
                    value.addType(validator.typeClass());
                }
                catch (IllegalArgumentException e) {
                    errors.add(new NSPropertyValidationError("Could not parse property value as " + validator.typeDescription() + " (reason: " + e.getMessage() + ")", key, value));
                }
            }
        }
    }

    @Override
    public void postProcess(NSPropertiesCoordinator coordinator, NSMutableArray<NSPropertyValidationError> errors) {
        for (String key : coordinator.allKeys()) {
            NSPropertyValue value = coordinator._getPropertyValueForKey(key);
            for (TypeValidator validator : typeValidators) {
                if (!value.hasType(validator.typeClass())) continue;
                try {
                    validator.validateValue(value);
                }
                catch (IllegalArgumentException e) {
                    errors.add(new NSPropertyValidationError("Could not parse property value as " + validator.typeDescription() + " (reason: " + e.getMessage() + ")", key, value));
                }
            }
        }
    }

    public static abstract class TypeValidator {
        private final String typeKey;
        private final String typeDesc;
        private final Class<?> typeClass;

        public TypeValidator(String typeKey, String typeDesc, Class<?> typeClass) {
            this.typeKey = typeKey;
            this.typeDesc = typeDesc;
            this.typeClass = typeClass;
        }

        public final String typeKey() {
            return this.typeKey;
        }

        public final String typeDescription() {
            return this.typeDesc;
        }

        public final Class<?> typeClass() {
            return this.typeClass;
        }

        public abstract void validateValue(NSPropertyValue var1) throws IllegalArgumentException;
    }
}

