/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValue;

public abstract class NSPropertyProcessor {
    public abstract void preProcess(NSMutableArray<NSPropertyValue> var1, NSMutableArray<NSPropertyValidationError> var2, NSPropertiesCoordinator var3);

    public abstract void postProcess(NSPropertiesCoordinator var1, NSMutableArray<NSPropertyValidationError> var2);

    protected int indexOfElement(String key, String element) {
        int index = 0;
        do {
            if (!key.startsWith(element, index)) continue;
            int end = index + element.length();
            if (end == key.length() || key.charAt(end) == '.') {
                return index;
            }
            index = end;
        } while ((index = key.indexOf(46, index) + 1) != 0);
        return -1;
    }

    protected boolean keyContainsElement(String key, String query) {
        return this.indexOfElement(key, query) >= 0;
    }

    protected String parameterInKeyForElement(String key, String query) {
        int index = this.indexOfElement(key, query);
        int start = index + query.length() + 1;
        if (index >= 0 && start < key.length()) {
            int end = key.indexOf(46, start);
            if (start < end) {
                return key.substring(start, end);
            }
            if (end == -1) {
                return key.substring(start);
            }
        }
        return null;
    }

    protected String keyByRemovingElement(String key, String query) {
        return this.keyByRemovingElementAndNextElements(key, query, 0);
    }

    protected String keyByRemovingElementAndNextElements(String key, String query, int removeCount) {
        int index = this.indexOfElement(key, query);
        if (index < 0) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key.length());
        if (index > 0) {
            sb.append(key, 0, index - 1);
        }
        int i = removeCount;
        while (i >= 0 && index >= 0) {
            index = key.indexOf(46, index + 1);
            --i;
        }
        if (index > 0) {
            int start = sb.length() > 0 ? index : index + 1;
            sb.append(key, start, key.length());
        }
        return sb.toString();
    }

    protected String keyWithoutElementInPosition(String key, int position) {
        if (position == 0) {
            return this.keyWithoutFirstElement(key);
        }
        int index = 0;
        int i = position;
        while (i > 0 && index >= 0) {
            index = key.indexOf(46, index + 1);
            --i;
        }
        if (index < 0) {
            return key;
        }
        StringBuilder sb = new StringBuilder(key.length());
        sb.append(key, 0, index);
        index = key.indexOf(46, index + 1);
        if (index > 0) {
            sb.append(key, index, key.length());
        }
        return sb.toString();
    }

    protected String lastElementOfKey(String key) {
        return key.substring(key.lastIndexOf(".") + 1);
    }

    protected String keyWithoutLastElement(String key) {
        int index = key.lastIndexOf(46);
        if (index >= 0) {
            return key.substring(0, index);
        }
        return "";
    }

    protected String keyWithoutFirstElement(String key) {
        int index = key.indexOf(46);
        if (index >= 0) {
            return key.substring(index + 1);
        }
        return "";
    }
}

