/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation._NSDelegate;
import com.webobjects.foundation._NSFileUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.properties.NSFileChunkPropertySource;
import com.webobjects.foundation.properties.NSFileChunkPropertyValue;
import com.webobjects.foundation.properties.NSMonitoredPropertiesFileProvider;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSourceException;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValidationException;
import com.webobjects.foundation.properties.NSPropertyValue;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSPropertyFileSource
implements NSPropertySource,
NSMonitoredPropertiesFileProvider {
    private static final Logger _log = LoggerFactory.getLogger(NSPropertyFileSource.class);
    private static final String HANDLE_LOADING_ERROR_METHOD_NAME = "handleLoadingError";
    public static final String IncludePropsKey = ".includeProps";
    public static final String IntegrityTokenMarker = ">>INTEGRITY_CHECK<<";
    private static final int NONE = 0;
    private static final int SLASH = 1;
    private static final int UNICODE = 2;
    private static final int CONTINUE = 3;
    private static final int KEY_DONE = 4;
    private static final int IGNORE = 5;
    private NSMutableSet<String> _includedPropsSoFar = null;
    private NSMutableArray<NSFileChunkPropertySource> _fileChuncks;
    private NSFileLocation _baseFile;
    private int _currentDeepness = 0;
    private Stack<NSFileLocation> _files = new Stack();
    private NSPropertiesCoordinator _coordinator;
    private _NSDelegate _fileErrorDelegate;
    private boolean _requireSymLinks;
    private NSArray<String> _ignorableIncludes;

    public static NSPropertyFileSource sourceForURL(NSPropertiesCoordinator coordinator, URL url) {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                return new NSPropertyFileSource(coordinator, new File(url.toURI()), false);
            }
            catch (URISyntaxException e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
        return new NSPropertyFileSource(coordinator, url);
    }

    public NSPropertyFileSource(NSPropertiesCoordinator coordinator, File baseFile, boolean requireSymLinks) {
        this(coordinator);
        this._baseFile = new NSFileLocation(baseFile);
        this._requireSymLinks = requireSymLinks;
    }

    public NSPropertyFileSource(NSPropertiesCoordinator coordinator, URL url) {
        this(coordinator);
        this._baseFile = new NSFileLocation(url);
    }

    private NSPropertyFileSource(NSPropertiesCoordinator coordinator) {
        this._fileChuncks = new NSMutableArray();
        this._coordinator = coordinator;
        this._fileErrorDelegate = new _NSDelegate(FileErrorDelegate.class);
        this._requireSymLinks = false;
        NSArray deprecatedIgnorableIncludes = NSValueUtilities.arrayValueWithDefault(System.getProperty("NSPropertyFileSource.missingIncludesToIgnore"), NSArray.emptyArray());
        this._ignorableIncludes = NSValueUtilities.arrayValueWithDefault(System.getProperty("NSPropertyFileSource.includesToIgnore"), deprecatedIgnorableIncludes);
    }

    public static Properties propertiesFromFile(File file, boolean requireSymLinks) {
        return NSPropertyFileSource.propertiesFromFile(file, requireSymLinks, null);
    }

    public static Properties propertiesFromFile(File file, boolean requireSymLinks, Object errorDelegate) {
        NSPropertyFileSource source = new NSPropertyFileSource(null, file, requireSymLinks);
        source.setFileErrorDelegate(errorDelegate);
        return NSPropertyFileSource.propertiesFromSource(source);
    }

    public static Properties propertiesFromURL(URL url) {
        return NSPropertyFileSource.propertiesFromURL(url, null);
    }

    public static Properties propertiesFromURL(URL url, Object errorDelegate) {
        NSPropertyFileSource source = new NSPropertyFileSource(null, url);
        source.setFileErrorDelegate(errorDelegate);
        return NSPropertyFileSource.propertiesFromSource(source);
    }

    private static Properties propertiesFromSource(NSPropertyFileSource source) {
        NSMutableArray<NSPropertyValidationError> errors = new NSMutableArray<NSPropertyValidationError>();
        source.load(errors);
        if (errors.count() != 0) {
            throw new NSPropertyValidationException(errors);
        }
        Properties properties = new Properties();
        for (NSFileChunkPropertySource chunk : source._fileChuncks) {
            for (NSPropertyValue value : chunk._values) {
                properties.put(value.originalKey(), value.originalValue());
            }
        }
        return properties;
    }

    private void loadFile(NSFileLocation file, int firstLine) throws IOException {
        NSFileChunkPropertySource chunk = new NSFileChunkPropertySource(this._coordinator, file, firstLine);
        chunk.setIncludeDepth(this._currentDeepness);
        if (this._files.size() > 1) {
            NSFileLocation tempFile = this._files.pop();
            chunk.setIncludedFrom(this._files.peek());
            this._files.push(tempFile);
        }
        this._fileChuncks.addObject(chunk);
        try (InputStreamReader reader = new InputStreamReader(file.inputStream(), "UTF-8");){
            this.loadImpl(reader);
            if (this._coordinator != null) {
                this._coordinator.propertiesLoadedWithTimestamp(file.lastModified());
            }
        }
    }

    private void loadImpl(Reader reader) throws IOException {
        int intVal;
        int mode = 0;
        int unicode = 0;
        int count = 0;
        char[] nextCharBuffer = new char[1];
        char[] buf = new char[40];
        int offset = 0;
        int keyLength = -1;
        boolean firstChar = true;
        BufferedReader br = new BufferedReader(reader);
        int physicalLine = 1;
        IntegrityTokenStatus integrityStatus = IntegrityTokenStatus.NOT_FOUND;
        String integrityToken = null;
        boolean foundUsefulContent = false;
        boolean foundEquals = false;
        block21: while ((intVal = br.read(nextCharBuffer)) != -1) {
            char nextChar = nextCharBuffer[0];
            if (offset == buf.length) {
                char[] newBuf = new char[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, offset);
                buf = newBuf;
            }
            if (mode == 2) {
                int digit = Character.digit(nextChar, 16);
                if (digit >= 0) {
                    unicode = (unicode << 4) + digit;
                    if (++count < 4) {
                        continue;
                    }
                } else if (count <= 4) {
                    throw new IllegalArgumentException("Invalid Unicode sequence: illegal character");
                }
                mode = 0;
                buf[offset++] = (char)unicode;
                if (nextChar != '\n' && nextChar != '\u0085') continue;
            }
            if (mode == 1) {
                mode = 0;
                switch (nextChar) {
                    case '\r': {
                        mode = 3;
                        ++physicalLine;
                        continue block21;
                    }
                    case '\n': 
                    case '\u0085': {
                        mode = 5;
                        ++physicalLine;
                        continue block21;
                    }
                    case 'b': {
                        nextChar = '\b';
                        break;
                    }
                    case 'f': {
                        nextChar = '\f';
                        break;
                    }
                    case 'n': {
                        nextChar = '\n';
                        break;
                    }
                    case 'r': {
                        nextChar = '\r';
                        break;
                    }
                    case 't': {
                        nextChar = '\t';
                        break;
                    }
                    case 'u': {
                        mode = 2;
                        count = 0;
                        unicode = 0;
                        continue block21;
                    }
                }
            } else {
                switch (nextChar) {
                    case '!': 
                    case '#': {
                        if (!firstChar) break;
                        StringBuffer comment = new StringBuffer();
                        while (true) {
                            String token;
                            if ((intVal = br.read()) == -1) {
                                token = this.integrityTokenFromComment(comment.toString());
                                if (!this.validateIntegrityTokens() || token == null) continue block21;
                                try {
                                    integrityStatus = this.integrityStatus(integrityStatus, integrityToken, token, foundUsefulContent);
                                    integrityToken = token;
                                    continue block21;
                                }
                                catch (Exception e) {
                                    _log.error("Comment: " + this.nullOrNull(comment.toString()));
                                    _log.error("File " + this._files.peek().toString() + " at line " + physicalLine);
                                    throw NSForwardException._runtimeExceptionForThrowable(e);
                                }
                            }
                            nextChar = (char)intVal;
                            if (nextChar == '\r' || nextChar == '\n' || nextChar == '\u0085') {
                                token = this.integrityTokenFromComment(comment.toString());
                                if (this.validateIntegrityTokens() && token != null) {
                                    try {
                                        integrityStatus = this.integrityStatus(integrityStatus, integrityToken, token, foundUsefulContent);
                                        integrityToken = token;
                                    }
                                    catch (Exception e) {
                                        _log.error("Comment: " + this.nullOrNull(comment.toString()));
                                        _log.error("File " + this._files.peek().toString() + " at line " + physicalLine);
                                        throw NSForwardException._runtimeExceptionForThrowable(e);
                                    }
                                }
                                ++physicalLine;
                                continue block21;
                            }
                            comment.append(nextChar);
                        }
                    }
                    case '\n': {
                        if (mode == 3) {
                            mode = 5;
                            continue block21;
                        }
                    }
                    case '\r': 
                    case '\u0085': {
                        mode = 0;
                        firstChar = true;
                        if (offset > 0 || offset == 0 && keyLength == 0) {
                            if (keyLength == -1) {
                                keyLength = offset;
                            }
                            String temp = new String(buf, 0, offset);
                            if (!foundEquals) {
                                throw new IOException("Malformed property, missing '=' at line " + physicalLine + ": " + temp.substring(0, keyLength));
                            }
                            this.put(temp.substring(0, keyLength), temp.substring(keyLength), physicalLine);
                            foundUsefulContent = true;
                            if (this.validateIntegrityTokens() && integrityStatus == IntegrityTokenStatus.FOUND_FINAL) {
                                throw new RuntimeException("Found property " + temp.substring(0, keyLength) + " after final integrity token '" + integrityToken + "' on file " + ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).file().toString());
                            }
                        }
                        keyLength = -1;
                        offset = 0;
                        foundEquals = false;
                        ++physicalLine;
                        continue block21;
                    }
                    case '\\': {
                        if (mode == 4) {
                            keyLength = offset;
                        }
                        mode = 1;
                        continue block21;
                    }
                    case ':': 
                    case '=': {
                        if (keyLength != -1) break;
                        foundEquals = true;
                        mode = 0;
                        keyLength = offset;
                        continue block21;
                    }
                }
                if (nextChar < '\u0100' && Character.isWhitespace(nextChar)) {
                    if (mode == 3) {
                        mode = 5;
                    }
                    if (offset == 0 || offset == keyLength || mode == 5) continue;
                    if (keyLength == -1) {
                        mode = 4;
                        continue;
                    }
                }
                if (mode == 5 || mode == 3) {
                    mode = 0;
                }
            }
            firstChar = false;
            if (mode == 4) {
                keyLength = offset;
                mode = 0;
            }
            buf[offset++] = nextChar;
        }
        if (mode == 2 && count <= 4) {
            throw new IllegalArgumentException("Invalid Unicode sequence: expected format \\uxxxx");
        }
        if (keyLength == -1 && offset > 0) {
            keyLength = offset;
        }
        if (keyLength >= 0) {
            String temp = new String(buf, 0, offset);
            String key = temp.substring(0, keyLength);
            String value = temp.substring(keyLength);
            if (mode == 1) {
                value = String.valueOf(value) + "\u0000";
            }
            this.put(key, value, physicalLine);
            foundUsefulContent = true;
            if (this.validateIntegrityTokens() && integrityStatus == IntegrityTokenStatus.FOUND_FINAL) {
                throw new RuntimeException("Found property " + temp.substring(0, keyLength) + " after final integrity token '" + integrityToken + "' on file " + ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).file().toString());
            }
        }
        if (this.validateIntegrityTokens() && integrityStatus == IntegrityTokenStatus.FOUND_INITIAL) {
            throw new RuntimeException("Didn't find final integrity token '" + integrityToken + "' on file " + ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).file().toString());
        }
        ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).setLastLineNumber(physicalLine);
    }

    private boolean validateIntegrityTokens() {
        return NSValueUtilities.booleanValue(System.getProperty("NSEnablePropertiesIntegrityTokens", "true"));
    }

    private IntegrityTokenStatus integrityStatus(IntegrityTokenStatus integrityStatus, String previousToken, String foundToken, boolean foundUsefulContent) {
        if (!this.validateIntegrityTokens()) {
            return IntegrityTokenStatus.NOT_FOUND;
        }
        if (integrityStatus == IntegrityTokenStatus.NOT_FOUND) {
            if (foundUsefulContent) {
                _log.error("previousToken: " + this.nullOrNull(previousToken));
                _log.error("foundToken: " + this.nullOrNull(foundToken));
                _log.error("foundUsefulContent: " + foundUsefulContent);
                _log.error("foundUsefulContent: " + foundUsefulContent);
                if (this._fileChuncks.count() > 0) {
                    _log.error(((NSFileChunkPropertySource)this._fileChuncks.lastObject()).traceSources(true));
                    try {
                        File file = ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).file().fileForLocation();
                        this.printEntireFile(file);
                    }
                    catch (Exception e) {
                        _log.error("Exception while trying to print properties file contents: " + e);
                        e.printStackTrace();
                    }
                }
                throw new RuntimeException("Integrity token '" + foundToken + "' found after useful content on file " + ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).file().toString());
            }
            return IntegrityTokenStatus.FOUND_INITIAL;
        }
        if (integrityStatus == IntegrityTokenStatus.FOUND_INITIAL) {
            if (!foundToken.equals(previousToken)) {
                throw new RuntimeException("Found an integrity token '" + foundToken + "' different from the intial one '" + previousToken + "' on file " + ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).file().toString());
            }
            return IntegrityTokenStatus.FOUND_FINAL;
        }
        if (integrityStatus == IntegrityTokenStatus.FOUND_FINAL) {
            throw new RuntimeException("Found an integrity token '" + foundToken + "' after the final one '" + previousToken + "' on file " + ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).file().toString());
        }
        throw new RuntimeException("Unknown status");
    }

    private void printEntireFile(File file) {
        try {
            String str;
            _log.error("************** Entire content for file " + file.getCanonicalPath());
            BufferedReader in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                _log.error(str);
            }
            _log.error("************** End of file content");
            in.close();
        }
        catch (IOException iOException) {
            _log.error("Error printing file content.");
        }
    }

    private String nullOrNull(String string) {
        return string == null ? "*** REALLY IS NULL ***" : string;
    }

    private String integrityTokenFromComment(String comment) {
        if (!this.validateIntegrityTokens()) {
            return null;
        }
        String trimmedComment = comment.trim();
        if (trimmedComment.startsWith(IntegrityTokenMarker) && trimmedComment.endsWith(IntegrityTokenMarker) && trimmedComment.length() > IntegrityTokenMarker.length() * 2) {
            return trimmedComment.substring(IntegrityTokenMarker.length(), trimmedComment.length() - IntegrityTokenMarker.length());
        }
        return null;
    }

    public void put(Object key, Object value, int line) {
        if (IncludePropsKey.equals(key)) {
            if (this._coordinator != null && this._coordinator.shouldProcessIncludeDirectives()) {
                String propsFileName = (String)value;
                File tempPropsFile = new File(propsFileName);
                NSFileLocation propsLocation = null;
                if (!tempPropsFile.isAbsolute()) {
                    NSFileLocation cwd = null;
                    cwd = this._files.size() > 0 ? this._files.peek() : new NSFileLocation(new File(System.getProperty("user.home")));
                    propsLocation = cwd.relativeLocationForPath(propsFileName);
                } else {
                    propsLocation = new NSFileLocation(tempPropsFile);
                }
                if (NSValueUtilities.booleanValueWithDefault(System.getProperty("com.webobjects.foundation.properties.NSPropertyFileSource.performRecursiveIncludeCheck"), true)) {
                    String propsPath;
                    try {
                        propsPath = propsLocation.canonicalPath();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to canonicalize the property file '" + propsLocation.toString() + "'.", e);
                    }
                    if (this._includedPropsSoFar == null) {
                        this._includedPropsSoFar = new NSMutableSet();
                    }
                    if (this._includedPropsSoFar.containsObject(propsPath)) {
                        throw new NSPropertyFileSourceException("Possible recursive includeProps detected.", new IllegalStateException("'" + propsPath + "' was included in more than one of the following files: " + this._includedPropsSoFar), propsLocation, this.includeChainForErrorHandling(propsLocation));
                    }
                    this._includedPropsSoFar.addObject(propsPath);
                }
                try {
                    ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).setLastLineNumber(line);
                    this.loadIncludedFile(propsLocation);
                    NSFileLocation theFile = this._files.peek();
                    NSFileChunkPropertySource chunk = new NSFileChunkPropertySource(this._coordinator, theFile, line + 1);
                    chunk.setIncludeDepth(this._currentDeepness);
                    if (this._files.size() > 1) {
                        NSFileLocation tempFile = this._files.pop();
                        chunk.setIncludedFrom(this._files.peek());
                        this._files.push(tempFile);
                    }
                    this._fileChuncks.addObject(chunk);
                }
                catch (IOException e) {
                    throw new NSPropertyFileSourceException("Failed to load the property file '" + value + "'.", e, propsLocation, this.includeChainForErrorHandling(propsLocation));
                }
            }
        } else {
            ((NSFileChunkPropertySource)this._fileChuncks.lastObject()).addValue(new NSFileChunkPropertyValue((String)key, (String)value, (NSPropertySource)this._fileChuncks.lastObject(), line));
        }
    }

    protected NSArray<NSFileLocation> includeChainForErrorHandling(NSFileLocation failedFile) {
        NSMutableArray<NSFileLocation> chain = new NSMutableArray<NSFileLocation>(this._files);
        chain.removeObject(failedFile);
        return chain;
    }

    public synchronized void loadIncludedFile(NSFileLocation propsFile) throws IOException {
        String filePath;
        File fileForLocation = propsFile.fileForLocation();
        String string = filePath = fileForLocation == null ? null : fileForLocation.getPath();
        if (filePath != null) {
            for (String ignorableInclude : this._ignorableIncludes) {
                if (!filePath.endsWith(ignorableInclude)) continue;
                return;
            }
        }
        NSFileLocation canonicalPropsFile = propsFile.canonicalLocation(NSProperties._shouldRequireSymlinkedGlobalAndIncludeProperties());
        this._files.push(canonicalPropsFile);
        ++this._currentDeepness;
        try {
            try {
                this.loadFile(canonicalPropsFile, 1);
            }
            catch (NSPropertyFileSourceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new NSPropertyFileSourceException(e.getMessage(), e, canonicalPropsFile, this.includeChainForErrorHandling(canonicalPropsFile));
            }
        }
        finally {
            this._files.pop();
            --this._currentDeepness;
        }
    }

    @Override
    public void load(NSMutableArray<NSPropertyValidationError> errors) {
        try {
            NSFileLocation canonicalFile = this._baseFile.canonicalLocation(this._requireSymLinks);
            this._files.push(canonicalFile);
            this.loadFile(canonicalFile, 1);
        }
        catch (NSPropertyFileSourceException e) {
            this._fileChuncks.removeAllObjects();
            if (this._fileErrorDelegate.delegate() != null && this._fileErrorDelegate.respondsTo(HANDLE_LOADING_ERROR_METHOD_NAME)) {
                this._fileErrorDelegate.perform(HANDLE_LOADING_ERROR_METHOD_NAME, this._coordinator, e.failedFile(), e.includeChain(), e);
            }
            throw new RuntimeException("Error loading file " + e.failedFile().toString() + ": " + e.getMessage(), e);
        }
        catch (Exception e) {
            this._fileChuncks.removeAllObjects();
            if (this._fileErrorDelegate.delegate() != null && this._fileErrorDelegate.respondsTo(HANDLE_LOADING_ERROR_METHOD_NAME)) {
                NSFileLocation file = this._files.size() > 0 ? this._files.peek() : this._baseFile;
                this._fileErrorDelegate.perform(HANDLE_LOADING_ERROR_METHOD_NAME, this._coordinator, file, this.includeChainForErrorHandling(file), e);
            }
            throw new RuntimeException("Error loading file " + this._baseFile.toString() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void process(NSMutableArray<NSPropertyValidationError> errors) {
        for (NSFileChunkPropertySource source : this._fileChuncks) {
            source.process(errors);
        }
    }

    @Override
    public NSArray<String> monitoredFilePaths(boolean includeIncludedFiles) {
        NSMutableArray<String> files = new NSMutableArray<String>();
        if (includeIncludedFiles) {
            for (NSFileChunkPropertySource chunk : this._fileChuncks) {
                File file = chunk.file().fileForLocation();
                if (file == null || files.containsObject(file.getAbsolutePath())) continue;
                files.addObject(file.getAbsolutePath());
            }
        } else {
            File file = this._baseFile.fileForLocation();
            if (file != null) {
                files.addObject(file.getAbsolutePath());
            }
        }
        return files;
    }

    @Override
    public String traceSources(boolean includeRawProperties) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---- Begin property file source for file " + this._baseFile.toString() + ":\n");
        for (NSFileChunkPropertySource source : this._fileChuncks) {
            buffer.append(source.traceSources(includeRawProperties));
        }
        buffer.append("---- End property file source\n");
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "property file source for " + this._baseFile;
    }

    public Object fileErrorDelegate() {
        return this._fileErrorDelegate.delegate();
    }

    public void setFileErrorDelegate(Object errorDelegate) {
        this._fileErrorDelegate.setDelegate(errorDelegate);
    }

    public static interface FileErrorDelegate {
        public void handleLoadingError(NSPropertiesCoordinator var1, NSFileLocation var2, NSArray<NSFileLocation> var3, Exception var4);
    }

    private static enum IntegrityTokenStatus {
        NOT_FOUND,
        FOUND_INITIAL,
        FOUND_FINAL;

    }

    protected static class NSFileLocation {
        private static final boolean USE_JAR_URL_LAST_MODIFIED = NSProperties.booleanForKeyWithDefault("NSPropertyFileSource.useJarUrlLastModified", false);
        private File _file;
        private URL _url;
        private NSTimestamp lastModified = NSTimestamp.DistantPast;

        public NSFileLocation(File file) {
            if (file == null) {
                throw new RuntimeException("File cannot be null");
            }
            this._file = file;
        }

        public NSFileLocation(URL url) {
            if (url == null) {
                throw new RuntimeException("URL cannot be null");
            }
            if (url.getProtocol().equals("file")) {
                throw new RuntimeException("URL " + url.toString() + " is a file. Please use the file constructor.");
            }
            this._url = url;
        }

        public File fileForLocation() {
            return this._file;
        }

        public String toString() {
            if (this._file != null) {
                return this._file.getPath();
            }
            return this._url.toString();
        }

        public InputStream inputStream() throws IOException {
            if (this._file != null) {
                this.lastModified = new NSTimestamp(this._file.lastModified());
                return new BufferedInputStream(new FileInputStream(this._file));
            }
            URLConnection connection = this._url.openConnection();
            long urlLastModified = connection instanceof JarURLConnection && !USE_JAR_URL_LAST_MODIFIED ? new File(((JarURLConnection)connection).getJarFile().getName()).lastModified() : connection.getLastModified();
            this.lastModified = urlLastModified == 0L ? NSTimestamp.DistantPast : new NSTimestamp(urlLastModified);
            return connection.getInputStream();
        }

        public NSFileLocation relativeLocationForPath(String relativePath) {
            if (this._file != null) {
                File parentFile = this._file.getParentFile();
                return new NSFileLocation(new File(parentFile, relativePath));
            }
            try {
                String path = this._url.getPath();
                path = path.lastIndexOf("/") > -1 ? String.valueOf(path.substring(0, path.lastIndexOf("/"))) + "/" + relativePath : relativePath;
                return new NSFileLocation(new URL(this._url.getProtocol(), this._url.getHost(), this._url.getPort(), path));
            }
            catch (MalformedURLException exception) {
                throw new RuntimeException(exception);
            }
        }

        public String canonicalPath() throws IOException {
            if (this._file != null) {
                return this._file.getCanonicalPath();
            }
            return this._url.getPath();
        }

        protected NSFileLocation canonicalLocation(boolean requireSymLinks) throws IOException {
            if (this._file != null) {
                File canonicalPropsFile = requireSymLinks ? _NSFileUtilities.resolveLinkForFile(this._file) : this._file.getCanonicalFile();
                return new NSFileLocation(canonicalPropsFile);
            }
            return this;
        }

        public URL toURL() throws MalformedURLException {
            if (this._file != null) {
                return this._file.toURI().toURL();
            }
            return this._url;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof NSFileLocation)) {
                return false;
            }
            NSFileLocation other = (NSFileLocation)obj;
            return _NSUtilities.safeEquals(this._file, other._file) && _NSUtilities.safeEquals(this._url, other._url);
        }

        public NSTimestamp lastModified() {
            return this.lastModified;
        }
    }
}

