/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSSimpleBlowfishCrypter;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.properties.NSAbstractProcessor;
import com.webobjects.foundation.properties.NSAppendingProcessor;
import com.webobjects.foundation.properties.NSBundleSourceFactory;
import com.webobjects.foundation.properties.NSCachedProperty;
import com.webobjects.foundation.properties.NSCommandLineSourceFactory;
import com.webobjects.foundation.properties.NSDefaultWOPropertiesSourceFactory;
import com.webobjects.foundation.properties.NSFinalProcessor;
import com.webobjects.foundation.properties.NSJNDISourceFactory;
import com.webobjects.foundation.properties.NSMonitoredPropertiesFileProvider;
import com.webobjects.foundation.properties.NSNotificationBasedSourceFactory;
import com.webobjects.foundation.properties.NSOptionalPropertyFilesSourceFactory;
import com.webobjects.foundation.properties.NSOverrideProcessor;
import com.webobjects.foundation.properties.NSPerAppPerMachineSourceFactory;
import com.webobjects.foundation.properties.NSPerAppPerUserSourceFactory;
import com.webobjects.foundation.properties.NSProgrammaticPropertiesSource;
import com.webobjects.foundation.properties.NSProgrammaticPropertyValue;
import com.webobjects.foundation.properties.NSProgrammaticSourceFactory;
import com.webobjects.foundation.properties.NSPropertyProcessor;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSPropertyTypeConverter;
import com.webobjects.foundation.properties.NSPropertyTypeValidationProcessor;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValidationException;
import com.webobjects.foundation.properties.NSPropertyValue;
import com.webobjects.foundation.properties.NSSecureProcessor;
import com.webobjects.foundation.properties.NSSourceFactory;
import com.webobjects.foundation.properties.NSSystemPropertiesSource;
import com.webobjects.foundation.properties.NSSystemPropertiesSourceFactory;
import com.webobjects.foundation.properties.NSWOPropertiesFileSourceFactory;
import com.webobjects.foundation.properties._NSPropertiesAdaptor;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class NSPropertiesCoordinator
implements NSKeyValueCodingAdditions {
    private static final int INITIAL_PROPERTY_HASHMAP_CAPACITY = 1024;
    private static final int MAX_RELOADING_TRIES = 5;
    private static NSMutableSet<Class<? extends NSPropertyProcessor>> _processorClasses;
    private static String _appName;
    private static volatile NSPropertiesCoordinator _sharedInstance;
    private static ReentrantLock _lock;
    private ConcurrentHashMap<String, String> _secureKeys;
    private ConcurrentMap<String, String> _securePropertiesCache;
    private ConcurrentMap<String, NSCachedProperty> _properties;
    private NSMutableArray<NSPropertySource> _sources;
    private NSArray<NSPropertyProcessor> _processors;
    private NSTimestamp _loadingTimestamp;
    private NSTimestamp mostRecentPropertyFileTimestamp = NSTimestamp.DistantPast;
    private NSMutableDictionary<String, Object> _sourceDependableProperties;

    static {
        _lock = new ReentrantLock();
        NSSystemPropertiesSource.registerSystemProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NSPropertiesCoordinator sharedInstance() {
        NSPropertiesCoordinator sharedInstance = _sharedInstance;
        if (sharedInstance != null) return sharedInstance;
        Class<NSPropertiesCoordinator> clazz = NSPropertiesCoordinator.class;
        synchronized (NSPropertiesCoordinator.class) {
            sharedInstance = _sharedInstance;
            if (sharedInstance != null) return sharedInstance;
            NSPropertiesCoordinator newProperties = new NSPropertiesCoordinator();
            newProperties.initializeWithBootstrappingProperties();
            NSPropertiesCoordinator.lockForWriting();
            try {
                NSPropertiesCoordinator._setSharedInstance(newProperties);
                newProperties.dumpToSystemProperties();
            }
            finally {
                NSPropertiesCoordinator.unlockForWriting();
            }
            sharedInstance = newProperties;
            NSNotificationCenter.defaultCenter().postNotification("PropertiesDidChange", newProperties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sharedInstance;
        }
    }

    protected static void _setSharedInstance(NSPropertiesCoordinator instance) {
        _sharedInstance = instance;
    }

    /*
     * Exception decompiling
     */
    public static void loadProperties() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void registerProcessorClass(Class<? extends NSPropertyProcessor> opClass) {
        NSPropertiesCoordinator._processorClasses().addObject(opClass);
    }

    public static void unregisterProcessorClass(Class<? extends NSPropertyProcessor> opClass) {
        NSPropertiesCoordinator._processorClasses().removeObject(opClass);
    }

    protected static NSMutableSet<Class<? extends NSPropertyProcessor>> _processorClasses() {
        if (_processorClasses == null) {
            NSMutableSet<Class> set = new NSMutableSet<Class>();
            set.addObject(NSPropertyTypeValidationProcessor.class);
            set.addObject(NSFinalProcessor.class);
            set.addObject(NSAbstractProcessor.class);
            set.addObject(NSOverrideProcessor.class);
            set.addObject(NSSecureProcessor.class);
            set.addObject(NSAppendingProcessor.class);
            _processorClasses = set;
        }
        return _processorClasses;
    }

    protected static synchronized NSArray<NSSourceFactory> _sourceFactories() {
        return new NSArray<NSSourceFactory>(new NSJNDISourceFactory(), new NSDefaultWOPropertiesSourceFactory(), new NSBundleSourceFactory(), new NSWOPropertiesFileSourceFactory(), new NSOptionalPropertyFilesSourceFactory(), new NSNotificationBasedSourceFactory(), new NSPerAppPerMachineSourceFactory(), new NSPerAppPerUserSourceFactory(), new NSSystemPropertiesSourceFactory(), new NSCommandLineSourceFactory(), new NSProgrammaticSourceFactory());
    }

    protected static synchronized NSArray<NSSourceFactory> _bootstrappingSourceFactories() {
        return new NSArray<NSSourceFactory>(new NSDefaultWOPropertiesSourceFactory(), new NSSystemPropertiesSourceFactory(), new NSProgrammaticSourceFactory());
    }

    protected static NSArray<NSPropertyProcessor> _processorsArray(NSSet<? extends Class<? extends NSPropertyProcessor>> classes) {
        NSMutableArray<NSPropertyProcessor> processors = new NSMutableArray<NSPropertyProcessor>();
        try {
            for (Class<? extends NSPropertyProcessor> clazz : classes) {
                NSPropertyProcessor processor = clazz.newInstance();
                processors.addObject(processor);
            }
        }
        catch (InstantiationException instantiationException) {
            throw NSForwardException._runtimeExceptionForThrowable(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw NSForwardException._runtimeExceptionForThrowable(illegalAccessException);
        }
        return processors;
    }

    public static void setAppName(String appName) {
        _appName = appName;
    }

    public static String appName() {
        return _appName;
    }

    protected NSPropertiesCoordinator() {
        this._properties = new ConcurrentHashMap<String, NSCachedProperty>(1024);
        this._loadingTimestamp = new NSTimestamp();
        this._secureKeys = new ConcurrentHashMap();
        this._securePropertiesCache = new ConcurrentHashMap<String, String>();
        this._sourceDependableProperties = new NSMutableDictionary();
    }

    protected void initialize() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this._setProcessors(NSPropertiesCoordinator._processorsArray(NSPropertiesCoordinator._processorClasses()));
            this._setSources(this._dataSourceInstancesArray());
            this.loadPropertiesToSources();
            this.processProperties();
            this.validateProperties();
            this.applyPostProcessors();
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    private void initializeWithBootstrappingProperties() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this._setProcessors(NSPropertiesCoordinator._processorsArray(NSPropertiesCoordinator._processorClasses()));
            this._setSources(this._bootstappingSourceInstanceArray());
            this.loadPropertiesToSources();
            this.processProperties();
            this.validateProperties();
            this.applyPostProcessors();
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public void dumpToSystemProperties() {
        Properties currentSystemProperties = System.getProperties();
        if (currentSystemProperties instanceof _NSPropertiesAdaptor) {
            _NSPropertiesAdaptor currentAdaptor = (_NSPropertiesAdaptor)currentSystemProperties;
            currentAdaptor.loadFromNSProperties(this);
        } else {
            _NSPropertiesAdaptor systemProperties = new _NSPropertiesAdaptor();
            for (String key : this._properties.keySet()) {
                NSPropertyValue value = this._getPropertyValueForKey(key);
                if (value == null) continue;
                systemProperties._setProperty(key, value.currentValue());
            }
            System.setProperties(systemProperties);
        }
    }

    protected NSArray<NSPropertySource> _dataSourceInstancesArray() {
        NSMutableArray<int> sources = new NSMutableArray<int>(NSPropertiesCoordinator._sourceFactories().count());
        for (NSSourceFactory factory : NSPropertiesCoordinator._sourceFactories()) {
            sources.addObjectsFromArray(factory.sourcesForProperties(this));
        }
        return sources;
    }

    private NSArray<NSPropertySource> _bootstappingSourceInstanceArray() {
        NSMutableArray<int> sources = new NSMutableArray<int>(NSPropertiesCoordinator._bootstrappingSourceFactories().count());
        for (NSSourceFactory factory : NSPropertiesCoordinator._bootstrappingSourceFactories()) {
            sources.addObjectsFromArray(factory.sourcesForProperties(this));
        }
        return sources;
    }

    protected void loadPropertiesToSources() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            NSMutableArray<NSPropertyValidationError> errors = new NSMutableArray<NSPropertyValidationError>();
            for (NSPropertySource source : this._sources) {
                source.load(errors);
            }
            if (errors.count() > 0) {
                throw new NSPropertyValidationException(errors);
            }
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    protected void processProperties() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            NSMutableArray<NSPropertyValidationError> errors = new NSMutableArray<NSPropertyValidationError>();
            for (NSPropertySource source : this._sources) {
                source.process(errors);
            }
            if (errors.count() > 0) {
                throw new NSPropertyValidationException(errors);
            }
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public NSPropertyValidationError addValue(NSPropertyValue value) {
        NSPropertiesCoordinator.assertWriteLocked();
        String key = value.currentKey();
        if (key.length() == 0) {
            return new NSPropertyValidationError("Property name missing or reduced to empty key due to processors", key, value);
        }
        if (!Character.isAlphabetic(key.charAt(0)) && !Character.isDigit(key.charAt(0)) && '_' != key.charAt(0)) {
            return new NSPropertyValidationError("Invalid property name", key, value);
        }
        if (value.isVisible()) {
            NSCachedProperty cachedProperty = (NSCachedProperty)this._properties.get(key);
            NSPropertyValue previousValue = null;
            if (cachedProperty != null) {
                if (cachedProperty.value().isFinal()) {
                    return new NSPropertyValidationError("Tried to redefine a final property", key, value);
                }
                if (cachedProperty.value().isOverride() && !value.isOverride()) {
                    System.err.println("Ignoring new definition for property " + value.currentKey() + " previously defined as @override.");
                    return null;
                }
                previousValue = cachedProperty.value();
                while (previousValue instanceof NSProgrammaticPropertyValue) {
                    previousValue = previousValue.overriddenValue();
                }
            }
            value.setOverriddenValue(previousValue);
            value._applyAppendingOperator();
            this._properties.put(key, new NSCachedProperty(value));
            if (value.isOverride() && !(value instanceof NSProgrammaticPropertyValue)) {
                NSProgrammaticPropertiesSource._forgetOverrideForKey(value.currentKey());
            }
        }
        return null;
    }

    protected void validateProperties() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            NSMutableArray<NSPropertyValidationError> errors = new NSMutableArray<NSPropertyValidationError>();
            for (NSCachedProperty property : this._properties.values()) {
                if (!property.value().isAbstract()) continue;
                errors.addObject(new NSPropertyValidationError("Abstract property was not redefined", property.value().currentKey(), property.value()));
            }
            if (errors.count() > 0) {
                throw new NSPropertyValidationException(errors);
            }
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public NSProgrammaticPropertiesSource overrideSource() {
        return (NSProgrammaticPropertiesSource)this._sources.lastObject();
    }

    public String stackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StringBuilder sb = new StringBuilder();
        boolean shouldSkip = true;
        StackTraceElement[] stackTraceElementArray = stackTrace;
        int n = stackTrace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (!shouldSkip || !element.getClassName().equals(NSProperties.class.getName()) && !element.getClassName().equals(Thread.class.getName()) && !element.getClassName().startsWith(NSPropertiesCoordinator.class.getPackage().getName())) {
                shouldSkip = false;
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(element.toString());
            }
            ++n2;
        }
        return sb.toString();
    }

    protected void applyPostProcessors() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            NSMutableArray<NSPropertyValidationError> errors = new NSMutableArray<NSPropertyValidationError>();
            for (NSPropertyProcessor processor : this._processors) {
                processor.postProcess(this, errors);
            }
            if (errors.count() > 0) {
                throw new NSPropertyValidationException(errors);
            }
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    protected void _setSources(NSArray<NSPropertySource> sources) {
        this._sources = sources.mutableClone();
    }

    public NSArray<NSPropertyProcessor> processors() {
        return this._processors;
    }

    protected void _setProcessors(NSArray<NSPropertyProcessor> processors) {
        this._processors = processors;
    }

    public NSArray<String> allKeys() {
        return new NSArray<String>(this._properties.keySet());
    }

    public void replaceProcessedValueForKey(String value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            NSCachedProperty cachedProperty = (NSCachedProperty)this._properties.get(key);
            cachedProperty.value().setProcessedValue(value);
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public static void unlockForWriting() {
        _lock.unlock();
    }

    public static void lockForWriting() {
        _lock.lock();
    }

    private static void assertWriteLocked() {
        if (!_lock.isHeldByCurrentThread()) {
            throw new RuntimeException("Thread did not lock for write!");
        }
    }

    public NSArray<String> monitoredFilePaths() {
        NSMutableArray<String> files = new NSMutableArray<String>();
        for (NSPropertySource source : this._sources) {
            if (!(source instanceof NSMonitoredPropertiesFileProvider)) continue;
            NSMonitoredPropertiesFileProvider provider = (NSMonitoredPropertiesFileProvider)((Object)source);
            files.addObjectsFromArray(provider.monitoredFilePaths(true));
        }
        return files;
    }

    public NSPropertyValue _getPropertyValueForKey(String key) {
        NSCachedProperty cachedProperty = (NSCachedProperty)this._properties.get(key);
        return cachedProperty != null ? cachedProperty.value() : null;
    }

    private final NSCachedProperty _getPropertyForKey(String key) {
        NSCachedProperty property = (NSCachedProperty)this._properties.get(key);
        if (property != null) {
            property.logUsage();
        }
        return property;
    }

    public Object removePropertyForKey(String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            String value = this.stringForKey(key);
            this.setStringForKey(null, key);
            String string = value;
            return string;
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public Object setPropertyForKey(String value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            String oldValue = this.stringForKey(key);
            this.setStringForKey(value, key);
            String string = oldValue;
            return string;
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public void removeProgrammaticValueForKey(String key) {
        NSPropertiesCoordinator.assertWriteLocked();
        NSCachedProperty cachedProperty = (NSCachedProperty)this._properties.get(key);
        if (cachedProperty != null) {
            NSPropertyValue value = cachedProperty.value();
            while (value != null && value instanceof NSProgrammaticPropertyValue) {
                value = value.overriddenValue();
            }
            if (value != null) {
                this._properties.put(key, new NSCachedProperty(value));
            } else {
                this._properties.remove(key);
            }
        }
    }

    public NSTimestamp loadingTimestamp() {
        return this._loadingTimestamp;
    }

    protected void propertiesLoadedWithTimestamp(NSTimestamp lastModified) {
        if (lastModified != null && lastModified.getTime() > this.mostRecentPropertyFileTimestamp.getTime()) {
            this.mostRecentPropertyFileTimestamp = lastModified;
        }
    }

    public NSTimestamp mostRecentPropertyFileTimestamp() {
        return this.mostRecentPropertyFileTimestamp;
    }

    public String _sourceDependablePropertyValue(String key) {
        Object value;
        if (this._sourceDependableProperties.objectForKey(key) == null) {
            String currentValue = NSProperties.stringForKey(key);
            this._sourceDependableProperties.setObjectForKey(currentValue == null ? NSKeyValueCoding.NullValue : currentValue, key);
        }
        return (value = this._sourceDependableProperties.objectForKey(key)) == NSKeyValueCoding.NullValue ? null : (String)value;
    }

    protected NSMutableDictionary<String, Object> _copyOfSourceDependablePropertiesWithNewValuesApplied() {
        NSMutableDictionary<String, Object> newDict = new NSMutableDictionary<String, Object>(this._sourceDependableProperties.count());
        for (String key : this._sourceDependableProperties.allKeys()) {
            String newValue = this.stringForKey(key);
            if (newValue != null) {
                newDict.setObjectForKey(newValue, key);
                continue;
            }
            newDict.setObjectForKey(NSKeyValueCoding.NullValue, key);
        }
        return newDict;
    }

    protected boolean _sourceDependablePropertiesMatchNew() {
        for (String key : this._sourceDependableProperties.allKeys()) {
            String stringValue;
            Object value = this._sourceDependableProperties.objectForKey(key);
            String string = stringValue = value == NSKeyValueCoding.NullValue ? null : (String)value;
            if (_NSUtilities.safeEquals(stringValue, this.valueForKey(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object valueForKey(String key) {
        return this.stringForKey(key);
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        this.setStringForKey(value.toString(), key);
    }

    @Override
    public Object valueForKeyPath(String keyPath) {
        return this.stringForKey(keyPath);
    }

    @Override
    public void takeValueForKeyPath(Object value, String keyPath) {
        this.setStringForKey(value.toString(), keyPath);
    }

    public String stringForKey(String key) {
        return this.stringForKeyWithDefault(key, null);
    }

    public String stringForKeyWithDefault(String key, String defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            String value = property.value().currentValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setStringForKey(String value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value, key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public void _putAll(Map<?, ?> properties) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            for (Object key : properties.keySet()) {
                String stringKey = (String)key;
                this.setStringForKey((String)properties.get(stringKey), stringKey);
            }
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public int intForKey(String key) {
        return this.intForKeyWithDefault(key, 0);
    }

    public int intForKeyWithDefault(String key, int defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Integer value = property.intValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public Integer IntegerForKey(String key) {
        return this.IntegerForKeyWithDefault(key, null);
    }

    public Integer IntegerForKeyWithDefault(String key, Integer defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Integer value = property.intValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setIntegerForKey(Integer value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.toString(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public NSArray arrayForKey(String aKey) {
        return this.arrayForKeyWithDefault(aKey, null);
    }

    public NSArray arrayForKeyWithDefault(String key, NSArray defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            try {
                NSArray value = property.arrayValue();
                return value != null ? value : defaultValue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The value for property '" + key + "' is malformed: " + e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    public void setArrayForKey(NSArray<?> value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : NSPropertyListSerialization.stringFromPropertyList(value), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public NSSet setForKey(String aKey) {
        return this.setForKeyWithDefault(aKey, null);
    }

    public NSSet setForKeyWithDefault(String key, NSSet defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            try {
                NSSet value = property.setValue();
                return value != null ? value : defaultValue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The value for property '" + key + "' is malformed: " + e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    public void setSetForKey(NSSet<?> value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : NSPropertyListSerialization.stringFromPropertyList(value.allObjects()), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public boolean booleanForKey(String aKey) {
        return this.booleanForKeyWithDefault(aKey, false);
    }

    public boolean booleanForKeyWithDefault(String key, boolean defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Boolean value = property.booleanValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public Boolean BooleanForKey(String aKey) {
        return this.BooleanForKeyWithDefault(aKey, null);
    }

    public Boolean BooleanForKeyWithDefault(String key, Boolean defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Boolean value = property.booleanValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setBooleanForKey(Boolean value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.toString(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public NSData dataForKey(String aKey) {
        return this.dataForKeyWithDefault(aKey, null);
    }

    public NSData dataForKeyWithDefault(String key, NSData defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            try {
                NSData value = property.dataValue();
                return value != null ? value : defaultValue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The value for property '" + key + "' is malformed: " + e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    public void setDataForKey(NSData value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : NSPropertyListSerialization.stringFromPropertyList(value), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public NSDictionary dictionaryForKey(String aKey) {
        return this.dictionaryForKeyWithDefault(aKey, null);
    }

    public NSDictionary dictionaryForKeyWithDefault(String key, NSDictionary defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            try {
                NSDictionary value = property.dictionaryValue();
                return value != null ? value : defaultValue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The value for property '" + key + "' is malformed: " + e.getMessage(), e);
            }
        }
        return defaultValue;
    }

    public void setDictionaryForKey(NSDictionary<?, ?> value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : NSPropertyListSerialization.stringFromPropertyList(value), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public double doubleForKey(String aKey) {
        return this.doubleForKeyWithDefault(aKey, 0.0);
    }

    public double doubleForKeyWithDefault(String key, double defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Double value = property.doubleValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public Double DoubleForKey(String aKey) {
        return this.DoubleForKeyWithDefault(aKey, null);
    }

    public Double DoubleForKeyWithDefault(String key, Double defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Double value = property.doubleValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setDoubleForKey(Double value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.toString(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public float floatForKey(String aKey) {
        return this.floatForKeyWithDefault(aKey, 0.0f);
    }

    public float floatForKeyWithDefault(String key, float defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Float value = property.floatValue();
            return value != null ? value.floatValue() : defaultValue;
        }
        return defaultValue;
    }

    public Float FloatForKey(String aKey) {
        return this.FloatForKeyWithDefault(aKey, null);
    }

    public Float FloatForKeyWithDefault(String key, Float defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Float value = property.floatValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setFloatForKey(Float value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.toString(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public <T> Class<? extends T> classForKey(String aKey) {
        return this.classForKeyWithDefault(aKey, null);
    }

    public <T> Class<? extends T> classForKeyWithDefault(String key, Class<? extends T> defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Class<?> value = property.classValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setClassForKey(Class value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.getName(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public long longForKey(String aKey) {
        return this.longForKeyWithDefault(aKey, 0L);
    }

    public long longForKeyWithDefault(String key, long defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Long value = property.longVaue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public Long LongForKey(String aKey) {
        return this.LongForKeyWithDefault(aKey, null);
    }

    public Long LongForKeyWithDefault(String key, Long defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            Long value = property.longVaue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setLongForKey(Long value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.toString(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public BigDecimal bigDecimalForKey(String key) {
        return this.bigDecimalForKeyWithDefault(key, null);
    }

    public BigDecimal bigDecimalForKeyWithDefault(String key, BigDecimal defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            BigDecimal value = property.bigDecimalValue();
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public void setBigDecimalForKey(BigDecimal value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.toString(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public <T> T objectForKey(String key, NSPropertyTypeConverter<T> converter) {
        return this.objectForKeyWithDefault(key, null, converter);
    }

    public <T> T objectForKeyWithDefault(String key, T defaultValue, NSPropertyTypeConverter<T> converter) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            T value = property.genericValueForClassWithFormatter(converter);
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public <T> void setObjectForKey(T value, String key, NSPropertyTypeConverter<T> converter) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : converter.stringValue(value), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public <T extends Enum<T>> T enumForKey(String key, Class<T> enumerationClass) {
        return this.enumForKeyWithDefault(key, null, enumerationClass);
    }

    public <T extends Enum<T>> T enumForKeyWithDefault(String key, T defaultValue, Class<T> enumerationClass) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            T value = property.enumValueForEnum(enumerationClass);
            return value != null ? value : defaultValue;
        }
        return defaultValue;
    }

    public <T extends Enum<T>> void setEnumForKey(T value, String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().setStringForKeyWithTrace(value == null ? null : value.name(), key, this.stackTrace());
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public void revertPropertyWithKey(String key) {
        NSPropertiesCoordinator.lockForWriting();
        try {
            this.overrideSource().revertPropertyWithKey(key);
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public void setSecureKeyForName(String secureKey, String name) {
        this._secureKeys.put(name, secureKey);
    }

    public String decryptedStringForKey(String key) {
        return this.decryptedStringForKeyWithDefault(key, null);
    }

    public String decryptedStringForKeyWithDefault(String key, String defaultValue) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            NSPropertyValue propValue = property.value();
            if (propValue.secure()) {
                try {
                    String decryptedValue = (String)this._securePropertiesCache.get(key);
                    if (decryptedValue == null) {
                        String encryptionKey = this._secureKeys.get(propValue.secureKeyName());
                        if (encryptionKey == null || encryptionKey.equals("")) {
                            throw new RuntimeException("Security key named " + propValue.secureKeyName() + " not found, could not decrypt secure property " + key);
                        }
                        _NSSimpleBlowfishCrypter crypter = new _NSSimpleBlowfishCrypter(encryptionKey);
                        decryptedValue = new String(crypter.debase64AndDecrypt(propValue.currentValue().getBytes()), StandardCharsets.UTF_8);
                        if (this.booleanForKeyWithDefault("NSProperties.cacheDecryptedSecureProperties", false)) {
                            this._securePropertiesCache.put(key, decryptedValue);
                        }
                    }
                    return decryptedValue;
                }
                catch (Exception e) {
                    throw new RuntimeException("Error decrypting property key=" + key + " secureName=" + propValue.secureKeyName() + ". Make sure the password is correct.", e);
                }
            }
            return propValue.currentValue() != null ? propValue.currentValue() : defaultValue;
        }
        return defaultValue;
    }

    public boolean isSecureProperty(String key) {
        NSCachedProperty property = this._getPropertyForKey(key);
        if (property != null) {
            NSPropertyValue propValue = property.value();
            return propValue.secure();
        }
        return false;
    }

    public String toString() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            Set keySet = this._properties.keySet();
            if (keySet.size() == 0) {
                return "(empty)";
            }
            StringBuffer buffer = new StringBuffer(keySet.size() * 20);
            NSArray keys = new NSArray(keySet).sortedArrayUsingComparator(NSComparator.AscendingCaseInsensitiveStringComparator);
            for (String key : keys) {
                buffer.append(key);
                buffer.append("=");
                buffer.append(this.stringForKey(key));
                buffer.append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        catch (NSComparator.ComparisonException e) {
            throw new NSForwardException(e);
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public String traceAllProperties() {
        NSPropertiesCoordinator.lockForWriting();
        try {
            StringBuffer buffer = new StringBuffer(this._properties.size() * 20);
            NSArray keys = new NSArray(this._properties.keySet()).sortedArrayUsingComparator(NSComparator.AscendingCaseInsensitiveStringComparator);
            for (String key : keys) {
                buffer.append(this.traceProperty(key));
                buffer.append("\n");
            }
            buffer.append("Total of " + keys.count() + " properties\n");
            String string = buffer.toString();
            return string;
        }
        catch (NSComparator.ComparisonException e) {
            throw new NSForwardException(e);
        }
        finally {
            NSPropertiesCoordinator.unlockForWriting();
        }
    }

    public String traceProperty(String key) {
        NSCachedProperty property = (NSCachedProperty)this._properties.get(key);
        if (property == null) {
            return null;
        }
        return property.trace();
    }

    public String traceSources(boolean includeRawProperties) {
        StringBuffer buffer = new StringBuffer();
        for (NSPropertySource source : this._sources) {
            buffer.append(source.traceSources(includeRawProperties));
        }
        return buffer.toString();
    }

    public void propertiesDidChange(NSNotification n) {
        NSPropertiesCoordinator.loadProperties();
    }

    public boolean shouldProcessIncludeDirectives() {
        return true;
    }
}

