/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSNotificationCenter;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.properties.NSProgrammaticPropertyValue;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValidationException;
import com.webobjects.foundation.properties.NSPropertyValue;
import com.webobjects.foundation.properties._NSPropertiesAdaptor;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class NSProgrammaticPropertiesSource
implements NSPropertySource {
    private static ConcurrentHashMap<String, NSProgrammaticPropertyValue> _overrides = new ConcurrentHashMap();
    private NSPropertiesCoordinator _coordinator;

    public NSProgrammaticPropertiesSource(NSPropertiesCoordinator coordinator) {
        this._coordinator = coordinator;
    }

    public static void _resetOverrides() {
        _overrides.clear();
    }

    @Override
    public void load(NSMutableArray<NSPropertyValidationError> errors) {
    }

    public void setStringForKeyWithTrace(String value, String key, String stackTrace) {
        NSProgrammaticPropertyValue propValue = new NSProgrammaticPropertyValue(key, value, this, stackTrace);
        NSPropertyValidationError error = this.processOverrideForValue(propValue);
        if (error != null) {
            throw new NSPropertyValidationException(error);
        }
        _overrides.put(key, propValue);
        NSNotificationCenter.defaultCenter().postNotification(NSProperties._notificationNameForProperty(key), this._coordinator);
    }

    @Override
    public void process(NSMutableArray<NSPropertyValidationError> errors) {
        for (NSPropertyValue nSPropertyValue : _overrides.values()) {
            NSPropertyValidationError error = this.processOverrideForValue(nSPropertyValue);
            if (error == null) continue;
            errors.addObject(error);
        }
    }

    public void revertPropertyWithKey(String key) {
        NSProgrammaticPropertyValue value = _overrides.get(key);
        if (value != null) {
            _overrides.remove(key);
            this._coordinator.removeProgrammaticValueForKey(value.currentKey());
            Properties sysProps = System.getProperties();
            String currentValue = this._coordinator.stringForKey(value.currentKey());
            if (sysProps instanceof _NSPropertiesAdaptor) {
                _NSPropertiesAdaptor adapter = (_NSPropertiesAdaptor)sysProps;
                adapter._setProperty(value.currentKey(), currentValue);
            } else if (currentValue == null) {
                sysProps.remove(value.currentKey());
            } else {
                sysProps.setProperty(value.currentKey(), currentValue);
            }
        }
    }

    public static void _forgetOverrideForKey(String key) {
        _overrides.remove(key);
    }

    private NSPropertyValidationError processOverrideForValue(NSPropertyValue value) {
        NSPropertyValidationError error = this._coordinator.addValue(value);
        if (error == null && this._coordinator == NSPropertiesCoordinator.sharedInstance()) {
            Properties sysProps = System.getProperties();
            if (sysProps instanceof _NSPropertiesAdaptor) {
                _NSPropertiesAdaptor adapter = (_NSPropertiesAdaptor)sysProps;
                adapter._setProperty(value.currentKey(), value.currentValue());
            } else if (value.currentValue() == null) {
                sysProps.remove(value.currentKey());
            } else {
                sysProps.setProperty(value.currentKey(), value.currentValue());
            }
        }
        return error;
    }

    @Override
    public String traceSources(boolean includeRawProperties) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("---- Begin override properties source:\n");
        if (includeRawProperties) {
            for (NSPropertyValue nSPropertyValue : _overrides.values()) {
                buffer.append(nSPropertyValue);
                buffer.append("\n");
            }
        }
        buffer.append("---- End override properties source\n");
        return buffer.toString();
    }

    @Override
    public String toString() {
        return "override properties source";
    }
}

