/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSSourceFactory;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSPerAppPerUserSourceFactory
extends NSSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(NSPerAppPerUserSourceFactory.class);

    @Override
    public NSArray<NSPropertySource> sourcesForProperties(NSPropertiesCoordinator coordinator) {
        URL applicationUserPropertiesURL;
        if (NSBundle._mainBundle() != null && (applicationUserPropertiesURL = NSPerAppPerUserSourceFactory.applicationUserPropertiesURL(coordinator)) != null) {
            NSPropertyFileSource source = NSPropertyFileSource.sourceForURL(coordinator, applicationUserPropertiesURL);
            return new NSArray<NSPropertySource>(source);
        }
        return NSArray.emptyArray();
    }

    public static URL applicationUserPropertiesURL(NSPropertiesCoordinator coordinator) {
        boolean throwOnFileError = NSProperties.booleanForKeyWithDefault("NSOptionalPropertyFilesSourceFactory.throwOnFileError", true);
        URL userPropertiesURL = null;
        String userName = coordinator._sourceDependablePropertyValue("user.name");
        if (userName != null && userName.length() > 0) {
            userPropertiesURL = NSBundle.mainBundle().pathURLForResourcePath("Properties." + userName);
            if (userPropertiesURL != null && NSBundle.mainBundle()._pathURLForResourcePath("Properties." + userName, false) == null) {
                if (throwOnFileError) {
                    throw new RuntimeException("User properties file is a directory: Properties." + userName + ", file: " + userPropertiesURL);
                }
                log.error("User properties file is a directory: Properties.{}, file: {}", (Object)userName, (Object)userPropertiesURL);
            }
            try {
                userPropertiesURL = NSPerAppPerUserSourceFactory.processedPropertiesURL(userPropertiesURL);
            }
            catch (Exception e) {
                if (throwOnFileError) {
                    throw new RuntimeException("User properties file is not readable: Properties." + userName + ", file: " + userPropertiesURL, e);
                }
                log.error("User properties file is not readable: Properties.{}, file: {}", new Object[]{userName, userPropertiesURL, e});
            }
        }
        return userPropertiesURL;
    }
}

