/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSSourceFactory;
import java.io.File;

public class NSPerAppPerMachineSourceFactory
extends NSSourceFactory {
    public static final String PROPERTIES_MACHINE_PROPERTIES_PATH_KEY = "NSProperties.machinePropertiesPath";

    @Override
    public NSArray<NSPropertySource> sourcesForProperties(NSPropertiesCoordinator coordinator) {
        File file;
        String fileName = NSPerAppPerMachineSourceFactory.applicationMachinePropertiesPath(coordinator, "Properties");
        if (fileName != null && (file = new File(fileName)).exists() && file.isFile() && file.canRead()) {
            NSPropertyFileSource source = new NSPropertyFileSource(coordinator, file, false);
            return new NSArray<NSPropertySource>(source);
        }
        return NSArray.emptyArray();
    }

    public static String applicationMachinePropertiesPath(NSPropertiesCoordinator coordinator, String fileName) {
        File applicationPropertiesFile;
        String applicationMachinePropertiesPath = null;
        String machinePropertiesPath = coordinator._sourceDependablePropertyValue(PROPERTIES_MACHINE_PROPERTIES_PATH_KEY);
        if (machinePropertiesPath == null) {
            machinePropertiesPath = "/etc/WebObjects";
        }
        if (NSPropertiesCoordinator.appName() != null && (applicationPropertiesFile = new File(String.valueOf(machinePropertiesPath) + File.separator + NSPropertiesCoordinator.appName() + File.separator + fileName)).exists()) {
            applicationMachinePropertiesPath = NSPerAppPerMachineSourceFactory.processedPropertiesPath(applicationPropertiesFile);
        }
        return applicationMachinePropertiesPath;
    }
}

