/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSSourceFactory;
import java.io.File;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSOptionalPropertyFilesSourceFactory
extends NSSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(NSOptionalPropertyFilesSourceFactory.class);
    public static final String PROPERTIES_OPTIONAL_CONFIGURATION_FILES_KEY = "NSProperties.OptionalConfigurationFiles";

    @Override
    public NSArray<NSPropertySource> sourcesForProperties(NSPropertiesCoordinator coordinator) {
        NSMutableArray<NSPropertySource> sources = new NSMutableArray<NSPropertySource>();
        for (URL url : this.optionalPropertyFileURLs(coordinator)) {
            NSPropertyFileSource source = NSPropertyFileSource.sourceForURL(coordinator, url);
            sources.addObject(source);
        }
        return sources;
    }

    private NSArray<URL> optionalPropertyFileURLs(NSPropertiesCoordinator coordinator) {
        boolean throwOnFileError = NSProperties.booleanForKeyWithDefault("NSOptionalPropertyFilesSourceFactory.throwOnFileError", true);
        NSArray immutableOptionalConfigurationFiles = NSValueUtilities.arrayValue(coordinator._sourceDependablePropertyValue(PROPERTIES_OPTIONAL_CONFIGURATION_FILES_KEY));
        NSArray deprecatedIgnorablePaths = NSValueUtilities.arrayValueWithDefault(System.getProperty("NSOptionalPropertyFilesSource.missingFilesToIgnore"), NSArray.emptyArray());
        NSArray ignorablePaths = NSValueUtilities.arrayValueWithDefault(System.getProperty("NSOptionalPropertyFilesSource.filesToIgnore"), deprecatedIgnorablePaths);
        NSMutableArray<URL> optionalPropertyFileURLs = new NSMutableArray<URL>();
        if (immutableOptionalConfigurationFiles != null) {
            int i = 0;
            while (i < immutableOptionalConfigurationFiles.count()) {
                String optionalConfigurationFilePath = (String)immutableOptionalConfigurationFiles.objectAtIndex(i);
                if (!ignorablePaths.contains(optionalConfigurationFilePath)) {
                    File optionalConfigurationFile = new File(optionalConfigurationFilePath);
                    if (optionalConfigurationFile.exists()) {
                        try {
                            optionalPropertyFileURLs.addObject(NSOptionalPropertyFilesSourceFactory.processedPropertiesURL(optionalConfigurationFile.toURI().toURL()));
                        }
                        catch (Exception e) {
                            if (throwOnFileError) {
                                throw new RuntimeException("Optional properties file has malformed path, is a directory or not readable: " + optionalConfigurationFile, e);
                            }
                            log.error("Optional properties file has malformed path, is a directory or not readable: {}", (Object)optionalConfigurationFile, (Object)e);
                        }
                    } else if (NSBundle._mainBundle() != null) {
                        URL resourcePropertiesURL = NSBundle.mainBundle().pathURLForResourcePath(optionalConfigurationFilePath);
                        if (resourcePropertiesURL != null) {
                            if (NSBundle.mainBundle()._pathURLForResourcePath(optionalConfigurationFilePath, false) == null) {
                                if (throwOnFileError) {
                                    throw new RuntimeException("Optional properties file is a directory: " + resourcePropertiesURL);
                                }
                                log.error("Optional properties file is a directory: {}", (Object)resourcePropertiesURL);
                            }
                            try {
                                resourcePropertiesURL = NSOptionalPropertyFilesSourceFactory.processedPropertiesURL(resourcePropertiesURL);
                                optionalPropertyFileURLs.addObject(resourcePropertiesURL);
                            }
                            catch (Exception e) {
                                if (throwOnFileError) {
                                    throw new RuntimeException("Optional properties file is not readable: " + resourcePropertiesURL, e);
                                }
                                log.error("Optional properties file is not readable: {}", (Object)resourcePropertiesURL, (Object)e);
                            }
                        } else {
                            if (throwOnFileError) {
                                throw new RuntimeException("Optional properties file not found in file system or main bundle: " + optionalConfigurationFilePath);
                            }
                            log.error("Optional properties file not found in file system or main bundle: {}", (Object)optionalConfigurationFilePath);
                        }
                    }
                }
                ++i;
            }
        }
        return optionalPropertyFileURLs;
    }
}

