/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyProcessor;
import com.webobjects.foundation.properties.NSPropertySource;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValue;

public abstract class NSMemoryPropertySource
implements NSPropertySource {
    protected NSMutableArray<NSPropertyValue> _values = new NSMutableArray();
    protected NSPropertiesCoordinator _properties;

    public NSMemoryPropertySource(NSPropertiesCoordinator properties) {
        this._properties = properties;
    }

    @Override
    public String traceSources(boolean includeRawProperties) {
        String result = "";
        if (includeRawProperties) {
            for (NSPropertyValue value : this._values) {
                result = String.valueOf(result) + value.toString() + "\n";
            }
        }
        return result;
    }

    @Override
    public void load(NSMutableArray<NSPropertyValidationError> errors) {
        throw new RuntimeException("Subclasses must implement this method");
    }

    @Override
    public void process(NSMutableArray<NSPropertyValidationError> errors) {
        this.applyPreProcessorsToValues(this._values, errors);
        for (NSPropertyValue value : this._values) {
            NSPropertyValidationError error = this._properties.addValue(value);
            if (error == null) continue;
            errors.addObject(error);
        }
    }

    protected void applyPreProcessorsToValues(NSMutableArray<NSPropertyValue> values, NSMutableArray<NSPropertyValidationError> errors) {
        for (NSPropertyProcessor processor : this._properties.processors()) {
            processor.preProcess(values, errors, this._properties);
        }
    }
}

