/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.properties.NSMemoryPropertySource;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValue;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class NSJNDISource
extends NSMemoryPropertySource {
    public NSJNDISource(NSPropertiesCoordinator properties) {
        super(properties);
    }

    @Override
    public void load(NSMutableArray<NSPropertyValidationError> errors) {
        try {
            InitialContext ctx = new InitialContext();
            NamingEnumeration<NameClassPair> list = ctx.list("java:comp/env/wo");
            while (list.hasMore()) {
                NameClassPair pair = list.next();
                String name = pair.isRelative() ? "java:comp/env/wo/" + pair.getName() : pair.getName();
                Object obj = ctx.lookup(name);
                this._values.addObject(new NSPropertyValue(pair.getName(), obj.toString(), this));
            }
        }
        catch (NamingException namingException) {
            this._values.removeAllObjects();
        }
    }

    @Override
    public String traceSources(boolean includeRawProperties) {
        return "---- Begin JNDI source:\n" + super.traceSources(includeRawProperties) + "---- End JNDI source\n";
    }

    @Override
    public String toString() {
        return "JNDI source";
    }
}

