/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSTimestampFormatter;
import com.webobjects.foundation.properties.NSFileChunkPropertyValue;
import com.webobjects.foundation.properties.NSMemoryPropertySource;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import com.webobjects.foundation.properties.NSPropertyValue;

public class NSFileChunkPropertySource
extends NSMemoryPropertySource {
    private NSPropertyFileSource.NSFileLocation _file;
    private int _firstLineNumber;
    private int _lastLineNumber;
    private NSPropertyFileSource.NSFileLocation _includedFrom;
    private int _includeDepth;
    private NSTimestamp _lastModified;

    public NSFileChunkPropertySource(NSPropertiesCoordinator properties, NSPropertyFileSource.NSFileLocation file, int firstLineNumber) {
        super(properties);
        if (file == null) {
            throw new RuntimeException("File cannot be null.");
        }
        this._file = file;
        this._firstLineNumber = firstLineNumber;
        this._lastModified = file.lastModified();
    }

    protected NSPropertyFileSource.NSFileLocation file() {
        return this._file;
    }

    protected void setFile(NSPropertyFileSource.NSFileLocation _file) {
        this._file = _file;
    }

    public int firstLineNumber() {
        return this._firstLineNumber;
    }

    protected void setFirstLineNumber(int _firstLineNumber) {
        this._firstLineNumber = _firstLineNumber;
    }

    public int lastLineNumber() {
        return this._lastLineNumber;
    }

    protected void setLastLineNumber(int _lastLineNumber) {
        this._lastLineNumber = _lastLineNumber;
    }

    public NSPropertyFileSource.NSFileLocation includedFrom() {
        return this._includedFrom;
    }

    protected void setIncludedFrom(NSPropertyFileSource.NSFileLocation _includedFrom) {
        this._includedFrom = _includedFrom;
    }

    public int includeDepth() {
        return this._includeDepth;
    }

    protected void setIncludeDepth(int _includeDepth) {
        this._includeDepth = _includeDepth;
    }

    public NSTimestamp lastModified() {
        return this._lastModified;
    }

    protected void setLastModified(NSTimestamp _lastModified) {
        this._lastModified = _lastModified;
    }

    public void addValue(NSFileChunkPropertyValue value) {
        this._values.addObject(value);
    }

    @Override
    public String traceSources(boolean includeRawProperties) {
        StringBuffer buffer = new StringBuffer();
        this.appendIndentation(buffer);
        String lastModifiedString = this.lastModifiedDescription();
        buffer.append("File chunk from line " + this._firstLineNumber + " to " + this._lastLineNumber + " of file " + this._file.toString() + lastModifiedString + ".\n");
        if (this._includedFrom != null) {
            this.appendIndentation(buffer);
            buffer.append("(included from ");
            buffer.append(this._includedFrom.toString());
            buffer.append(")\n");
        }
        this.appendIndentation(buffer);
        buffer.append("Contains " + this._values.count() + " values");
        if (includeRawProperties) {
            buffer.append(":\n");
            for (NSPropertyValue value : this._values) {
                this.appendIndentation(buffer);
                buffer.append(value);
                buffer.append("\n");
            }
        } else {
            buffer.append("\n");
        }
        return buffer.toString();
    }

    protected String lastModifiedDescription() {
        String lastModifiedString = "";
        if (this.lastModified() != null) {
            NSTimestampFormatter formatter = new NSTimestampFormatter("%b %d, %Y - %I:%M %p %Z");
            lastModifiedString = " modified on " + formatter.format(this.lastModified());
        }
        return lastModifiedString;
    }

    private void appendIndentation(StringBuffer buffer) {
        int i = 0;
        while (i < this._includeDepth) {
            buffer.append("  ");
            ++i;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(this.file().toString()) + this.lastModifiedDescription();
    }
}

