/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.properties.NSPropertyAccessor;

public class NSEnumProperty<T extends Enum<T>>
extends NSPropertyAccessor<T> {
    private Class<T> _enumClass;

    public NSEnumProperty(String key, T defaultValue, Class<T> enumClass) {
        super(key, defaultValue);
        this._enumClass = enumClass;
    }

    @Override
    public T value() {
        return (T)NSProperties.enumForKeyWithDefault(this.key(), (Enum)this.defaultValue(), this.enumClass());
    }

    @Override
    public void setValue(T value) {
        NSProperties.setEnumForKey(value, this.key());
    }

    public Class<T> enumClass() {
        return this._enumClass;
    }
}

