/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.properties.NSMemoryPropertySource;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValue;

public class NSCommandLineSource
extends NSMemoryPropertySource {
    private static NSDictionary<String, String> _commandLineProperties;
    private static final String _def = "-D";
    private static final char _dqc = '\"';
    private static final String _dqs = "\"";
    private static final String _eqs = "=";
    private static final String _false = "false";
    private static final String _hyphen = "-";
    private static final String _no = "NO";
    private static final char _sqc = '\'';
    private static final String _sqs = "'";
    private static final String _true = "true";
    private static final String _yes = "YES";

    public NSCommandLineSource(NSPropertiesCoordinator properties) {
        super(properties);
    }

    @Override
    public void load(NSMutableArray<NSPropertyValidationError> errors) {
        if (_commandLineProperties != null) {
            for (String key : _commandLineProperties.allKeys()) {
                this._values.addObject(new NSPropertyValue(key, _commandLineProperties.objectForKey(key), this));
            }
        }
    }

    public static void registerCommandLineProperties(String[] argv) {
        _commandLineProperties = NSCommandLineSource.buildCommandLinePropertiesDict(argv);
    }

    protected static NSDictionary<String, String> buildCommandLinePropertiesDict(String[] argv) {
        NSDictionary<String, String> dict = NSCommandLineSource.valuesFromArgv(argv);
        return dict.immutableClone();
    }

    public static NSDictionary<String, String> valuesFromArgv(String[] argv) {
        if (argv == null) {
            return NSDictionary.emptyDictionary();
        }
        NSMutableDictionary<String, String> values = new NSMutableDictionary<String, String>(50);
        int argCount = argv.length;
        int i = 0;
        while (i < argCount) {
            String argumentValue;
            String argumentName;
            int indexOfEqualSign;
            String argument = argv[i];
            int argumentLength = argument.length();
            boolean argIsQuoted = argument.startsWith(_dqs) && argument.endsWith(_dqs) || argument.startsWith(_sqs) && argument.endsWith(_sqs);
            boolean hasBeenParsed = false;
            if ((argIsQuoted ? argument.indexOf(_def) == 1 : argument.startsWith(_def)) && (indexOfEqualSign = argument.indexOf(_eqs)) != -1 && (argIsQuoted ? indexOfEqualSign < argumentLength - 2 && indexOfEqualSign > 3 : indexOfEqualSign < argumentLength && indexOfEqualSign > 2)) {
                if (argIsQuoted) {
                    argumentName = argument.substring(3, indexOfEqualSign);
                    argumentValue = argument.substring(indexOfEqualSign + 1, argumentLength - 1);
                } else {
                    boolean valIsQuoted = indexOfEqualSign < argumentLength - 2 && (argument.charAt(indexOfEqualSign + 1) == '\"' && argument.endsWith(_dqs) || argument.charAt(indexOfEqualSign + 1) == '\'' && argument.endsWith(_sqs));
                    argumentName = argument.substring(2, indexOfEqualSign);
                    argumentValue = valIsQuoted ? argument.substring(indexOfEqualSign + 2, argumentLength - 1) : argument.substring(indexOfEqualSign + 1, argumentLength);
                }
                values.setObjectForKey(argumentValue, argumentName);
                hasBeenParsed = true;
            }
            if (!hasBeenParsed && argument.startsWith(_hyphen) && argument.length() > 1) {
                argumentName = argument.substring(1);
                if (i + 1 < argCount) {
                    argumentValue = argv[i + 1];
                    ++i;
                    if (argumentValue.equalsIgnoreCase(_yes) || argumentValue.equalsIgnoreCase(_true)) {
                        argumentValue = _true;
                    } else if (argumentValue.equalsIgnoreCase(_no) || argumentValue.equalsIgnoreCase(_false)) {
                        argumentValue = _false;
                    }
                    values.setObjectForKey(argumentValue, argumentName);
                }
            }
            ++i;
        }
        return values;
    }

    @Override
    public String traceSources(boolean includeRawProperties) {
        return "---- Begin command line source:\n" + super.traceSources(includeRawProperties) + "---- End command line source\n";
    }

    @Override
    public String toString() {
        return "command line source";
    }
}

