/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.properties.NSPropertyAccessor;

public class NSCachedPropertyAccessor<T> {
    private NSPropertyAccessor<T> _propertyAccessor;
    private volatile T _lastValue;
    private volatile long _loadingTimestamp;

    public NSCachedPropertyAccessor(NSPropertyAccessor<T> propertyAccessor) {
        this._propertyAccessor = propertyAccessor;
        this._loadingTimestamp = 0L;
    }

    public T value() {
        long lastLoadingTimestamp = this._loadingTimestamp;
        long loadingTimestamp = NSProperties.loadingTimestamp().getTime();
        if (loadingTimestamp != lastLoadingTimestamp) {
            this._lastValue = this._propertyAccessor.value();
            this._loadingTimestamp = loadingTimestamp;
        }
        return this._lastValue;
    }

    public void setValue(T value) {
        this._propertyAccessor.setValue(value);
        this._lastValue = value;
        this._loadingTimestamp = NSProperties.loadingTimestamp().getTime();
    }

    public NSPropertyAccessor<T> propertyAccessor() {
        return this._propertyAccessor;
    }
}

