/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.properties.NSPropertyTypeConverter;
import com.webobjects.foundation.properties.NSPropertyUsageTracker;
import com.webobjects.foundation.properties.NSPropertyValue;
import java.math.BigDecimal;

public class NSCachedProperty {
    private final NSPropertyValue _value;
    private Object _cachedValue;
    private boolean hasLoggedUsage = false;

    public NSCachedProperty(NSPropertyValue value) {
        if (value == null) {
            throw new IllegalArgumentException("Value to cache can't be null");
        }
        this._value = value;
    }

    public NSPropertyValue value() {
        return this._value;
    }

    protected final void logUsage() {
        if (!this.hasLoggedUsage) {
            this.hasLoggedUsage = true;
            NSPropertyUsageTracker.recordPropertyReference(this._value);
        }
    }

    public String stringValue() {
        return this.value().currentValue();
    }

    public <T> T genericValueForClassWithFormatter(NSPropertyTypeConverter<? extends T> converter) {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && converter.matchesType(cachedValue)) {
            return (T)cachedValue;
        }
        String currentValue = this.value().currentValue();
        T parsedValue = currentValue != null ? (T)converter.parse(this.value().currentValue()) : null;
        this._cachedValue = parsedValue;
        return parsedValue;
    }

    public Integer intValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof Integer) {
            return (Integer)cachedValue;
        }
        this._cachedValue = cachedValue = NSValueUtilities.IntegerValueWithDefault(this.value().currentValue(), null);
        return (Integer)cachedValue;
    }

    public NSArray<?> arrayValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof NSArray) {
            return (NSArray)cachedValue;
        }
        this.value().validateForType(NSArray.class);
        this._cachedValue = cachedValue = NSValueUtilities.arrayValue(this.value().currentValue());
        return (NSArray)cachedValue;
    }

    public NSSet<?> setValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof NSSet) {
            return (NSSet)cachedValue;
        }
        this.value().validateForType(NSSet.class);
        this._cachedValue = cachedValue = NSValueUtilities.setValue(this.value().currentValue());
        return (NSSet)cachedValue;
    }

    public Boolean booleanValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof Boolean) {
            return (Boolean)cachedValue;
        }
        this._cachedValue = cachedValue = NSValueUtilities.BooleanValueWithDefault(this.value().currentValue(), null);
        return (Boolean)cachedValue;
    }

    public NSData dataValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof NSData) {
            return (NSData)cachedValue;
        }
        this.value().validateForType(NSData.class);
        this._cachedValue = cachedValue = NSValueUtilities.dataValue(this.value().currentValue());
        return (NSData)cachedValue;
    }

    public NSDictionary<?, ?> dictionaryValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof NSDictionary) {
            return (NSDictionary)cachedValue;
        }
        this.value().validateForType(NSDictionary.class);
        this._cachedValue = cachedValue = NSValueUtilities.dictionaryValue(this.value().currentValue());
        return (NSDictionary)cachedValue;
    }

    public Double doubleValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof Double) {
            return (Double)cachedValue;
        }
        this._cachedValue = cachedValue = NSValueUtilities.DoubleValueWithDefault(this.value().currentValue(), null);
        return (Double)cachedValue;
    }

    public Float floatValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof Float) {
            return (Float)cachedValue;
        }
        this._cachedValue = cachedValue = NSValueUtilities.FloatValueWithDefault(this.value().currentValue(), null);
        return (Float)cachedValue;
    }

    public Class<?> classValue() {
        Class<?> cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof Class) {
            return cachedValue;
        }
        String stringValue = this.value().currentValue();
        if (stringValue != null && stringValue.length() > 0) {
            Class<?> value = _NSUtilities.classWithName(stringValue);
            if (value == null) {
                throw new IllegalArgumentException("Failed to load the class named '" + stringValue + "'.");
            }
            cachedValue = value;
        } else {
            cachedValue = null;
        }
        this._cachedValue = cachedValue;
        return cachedValue;
    }

    public Long longVaue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof Long) {
            return (Long)cachedValue;
        }
        this._cachedValue = cachedValue = NSValueUtilities.LongValueWithDefault(this.value().currentValue(), null);
        return (Long)cachedValue;
    }

    public BigDecimal bigDecimalValue() {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && cachedValue instanceof BigDecimal) {
            return (BigDecimal)cachedValue;
        }
        this._cachedValue = cachedValue = NSValueUtilities.bigDecimalValue(this.value().currentValue());
        return (BigDecimal)cachedValue;
    }

    public <T extends Enum<T>> T enumValueForEnum(Class<T> enumerationClass) {
        Object cachedValue = this._cachedValue;
        if (cachedValue != null && enumerationClass.isInstance(cachedValue)) {
            return (T)((Enum)enumerationClass.cast(cachedValue));
        }
        String currentValue = this.value().currentValue();
        T enumValue = currentValue != null ? (T)Enum.valueOf(enumerationClass, this.value().currentValue()) : null;
        this._cachedValue = enumValue;
        return enumValue;
    }

    public String trace() {
        return this.value().trace();
    }
}

