/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.properties;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.properties.NSPropertiesCoordinator;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import com.webobjects.foundation.properties._NSPropertyUtilities;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSBundleSourceErrorDelegate {
    private static final Logger log = LoggerFactory.getLogger(NSBundleSourceErrorDelegate.class);
    private boolean _validateProperties;

    public NSBundleSourceErrorDelegate(boolean validateProperties) {
        this._validateProperties = validateProperties;
    }

    public void handleLoadingError(NSPropertiesCoordinator coordinator, NSPropertyFileSource.NSFileLocation failedFile, NSArray<NSPropertyFileSource.NSFileLocation> includeChain, Exception exception) {
        String fileDescription = _NSPropertyUtilities.descriptionForFileAndIncludeChain(failedFile, includeChain);
        if (exception instanceof FileNotFoundException) {
            if (this._validateProperties) {
                try {
                    if (NSBundle._bundleUrlExists(failedFile.toURL())) {
                        throw new RuntimeException("Failed to load " + fileDescription + ".", exception);
                    }
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Failed to load " + fileDescription + ".", e);
                }
            }
        } else {
            if (this._validateProperties) {
                throw new RuntimeException("Failed to load " + fileDescription + ".", exception);
            }
            log.error("Error reading properties file {}. Ignoring this file.", (Object)fileDescription, (Object)exception);
        }
    }
}

