/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.plist.impl;

class Preconditions {
    Preconditions() {
    }

    public static <T> T checkNotNull(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static void checkCondition(boolean condition, String message, Object ... args) {
        if (!condition) {
            throw new IllegalStateException(Preconditions.errorMessage(message, args));
        }
    }

    public static String errorMessage(String message, Object[] args) {
        if (args == null || args.length == 0) {
            return message;
        }
        return String.format(message, args);
    }

    public static void checkIndexOffset(int start, int end, int size) {
        if (start < 0 || end < start || end > size) {
            throw new IndexOutOfBoundsException("Invalid index range [" + start + ":" + end + "]");
        }
    }
}

