/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.plist.impl;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.plist._PListBinaryParser;
import com.webobjects.foundation.plist._PListParser;
import com.webobjects.foundation.plist.impl.BinaryPListUtils;
import com.webobjects.foundation.plist.impl.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSPListBinaryImpl
extends _PListParser
implements _PListBinaryParser {
    private static final Logger log = LoggerFactory.getLogger(NSPListBinaryImpl.class);

    public static boolean isBinaryPList(ByteBuffer byteBuffer) {
        ByteBuffer buffer = byteBuffer.asReadOnlyBuffer();
        if (buffer.remaining() < 8) {
            return false;
        }
        long header = buffer.getLong();
        return BinaryPListUtils.Header.isValid(header);
    }

    public static SeekableByteChannel toDataChannel(InputStream stream) throws IOException {
        int r;
        if (stream instanceof SeekableByteChannel) {
            return (SeekableByteChannel)((Object)stream);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(Math.max(32, stream.available()));
        byte[] buf = new byte[4096];
        while ((r = stream.read(buf)) != -1) {
            out.write(buf, 0, r);
        }
        return new BinaryPListUtils.SeekableDataChannel(out.toByteArray());
    }

    @Override
    public Object propertyListWithChannel(SeekableByteChannel channel) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Reader reader = new Reader(channel);){
                return reader.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    @Override
    public Object propertyListWithData(byte[] data) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Reader reader = new Reader(data);){
            return reader.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object propertyListWithData(ByteBuffer data) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Reader reader = new Reader(data);){
            return reader.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object propertyListWithData(NSData data) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Reader reader = new Reader(data.bytes());){
            return reader.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Object propertyListWithStream(InputStream is, Normalizer.Form normalizerForm) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Reader reader = new Reader(NSPListBinaryImpl.toDataChannel(is));){
                return reader.readObject();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    @Override
    public void writePropertyListToStream(Object plist, OutputStream out) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Writer writer = new Writer(new DataOutputStream(out));){
            writer.write(plist);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static class Reader
    implements Closeable {
        private final BinaryPListUtils.Trailer trailer;
        private DataInput dataInput;
        protected final List<Object> objectTable;

        protected Reader(SeekableByteChannel channel) throws IOException {
            Preconditions.checkCondition(channel.size() > 8L, "Not a binary property list", new Object[0]);
            this.dataInput = new DataInputStream(Channels.newInputStream(channel));
            BinaryPListUtils.checkHeader(this.dataInput.readLong());
            channel.position(channel.size() - 32L);
            this.trailer = BinaryPListUtils.readTrailer(this.dataInput);
            this.objectTable = this.newRefTable();
            channel.position(8L);
        }

        public Reader(byte[] source) {
            this(ByteBuffer.wrap(source));
        }

        public Reader(ByteBuffer source) {
            ByteBuffer buffer = source.slice();
            try {
                Preconditions.checkCondition(buffer.capacity() > 8, "Not a binary property list", new Object[0]);
                this.dataInput = new BinaryPListUtils.SeekableDataChannel(buffer);
                BinaryPListUtils.checkHeader(buffer.getLong());
                buffer.position(buffer.capacity() - 32);
                this.trailer = BinaryPListUtils.readTrailer(this.dataInput);
                this.objectTable = this.newRefTable();
                buffer.position(8);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }

        static Object adapt(Object obj) {
            NSCoding result = obj;
            if (obj instanceof BinaryPListUtils.ReferenceDictionary) {
                result = new NSDictionary<String, Object>((BinaryPListUtils.ReferenceDictionary)((Object)obj));
            } else if (obj instanceof BinaryPListUtils.ReferenceArray) {
                result = new NSArray<Object>((BinaryPListUtils.ReferenceArray)((Object)obj));
            } else if (obj instanceof BinaryPListUtils.ReferenceSet) {
                result = new NSSet<Object>((BinaryPListUtils.ReferenceSet)((Object)obj));
            } else if (obj instanceof ByteBuffer) {
                result = new NSData(((ByteBuffer)((Object)obj)).slice());
            } else if (obj instanceof Date) {
                result = new NSTimestamp(((Date)((Object)obj)).getTime());
            }
            return result;
        }

        private void flush() {
            this.readRef((int)this.trailer.objectCount - 1);
        }

        private Object getValue() {
            int ref = (int)this.trailer.topObject;
            this.readRef(ref);
            return Reader.adapt(this.objectTable.get(ref));
        }

        protected void readRef(int ref) {
            Preconditions.checkCondition((long)ref >= this.trailer.topObject && (long)ref < this.trailer.objectCount, "Invalid reference %s", ref);
            Preconditions.checkCondition(this.dataInput != null || ref < this.objectTable.size(), "Attempt to read unfaulted reference after closing input stream; Call flush() before closing.", new Object[0]);
            try {
                while (this.objectTable.size() <= ref) {
                    BinaryPListUtils.Type type = BinaryPListUtils.readNextObject(this.dataInput, this.objectTable, this.trailer.objectRefSize);
                    if (!log.isTraceEnabled()) continue;
                    log.trace("readRef: read reference: {} = {}", (Object)type, this.objectTable.get(this.objectTable.size() - 1));
                }
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }

        BinaryPListUtils.ReferenceTable newRefTable() {
            return new BinaryPListUtils.ReferenceTable(new ArrayList((int)this.trailer.objectCount)){

                @Override
                protected void willRead(int index) {
                    Reader.this.readRef(index);
                }
            };
        }

        @Override
        public void close() {
            if (this.dataInput instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.dataInput)).close();
                    this.dataInput = null;
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }
        }

        public void dumpObjectTable() {
            this.readObject();
            log.trace(this.objectTable.toString());
        }

        public Object readObject() {
            this.flush();
            int i = this.objectTable.size();
            while (i > 0) {
                Object a;
                Object o = this.objectTable.get(i - 1);
                if (o != (a = Reader.adapt(o))) {
                    this.objectTable.set(i - 1, a);
                }
                --i;
            }
            return this.getValue();
        }
    }

    static class Writer
    implements Closeable {
        private boolean writeCalled = false;
        private final DataOutput output;

        public Writer(DataOutput dataOutput) {
            this.output = dataOutput;
        }

        protected Object adapt(Object value) {
            Object obj = value;
            if (obj instanceof byte[]) {
                obj = ByteBuffer.wrap((byte[])obj);
            }
            if (value instanceof NSData) {
                obj = ByteBuffer.wrap(((NSData)value).bytes());
            }
            return obj;
        }

        @Override
        public void close() {
            this.writeCalled = true;
            if (this.output instanceof Closeable) {
                try {
                    ((Closeable)((Object)this.output)).close();
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }
        }

        public void dumpObjectTable(Object object) {
            BinaryPListUtils.ReferenceTable objectTable = new BinaryPListUtils.ReferenceTable(new ArrayList<Object>());
            BinaryPListUtils.ReferenceObjectVisitor visitor = new BinaryPListUtils.ReferenceObjectVisitor(objectTable){

                @Override
                protected Object adapt(Object value) {
                    return Writer.this.adapt(value);
                }
            };
            visitor.visit(object);
            log.debug(((Object)objectTable).toString());
        }

        public void flush() {
            if (this.output instanceof Flushable) {
                try {
                    ((Flushable)((Object)this.output)).flush();
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }
        }

        public void write(Object object) {
            if (this.writeCalled) {
                throw new IllegalStateException("Writing has already completed");
            }
            ArrayList refTable = new ArrayList();
            BinaryPListUtils.ReferenceObjectVisitor visitor = new BinaryPListUtils.ReferenceObjectVisitor(refTable){

                @Override
                protected Object adapt(Object value) {
                    return Writer.this.adapt(value);
                }
            };
            visitor.visit(object);
            try {
                this.writeCalled = true;
                long position = BinaryPListUtils.writeHeader(this.output);
                BinaryPListUtils.RefSize objectTypeRef = BinaryPListUtils.RefSize.forValue(refTable.size());
                ArrayList<Long> objectOffsets = new ArrayList<Long>(refTable.size());
                int i = 0;
                while (i < refTable.size()) {
                    Object obj = refTable.get(i);
                    objectOffsets.add(position);
                    position += (long)BinaryPListUtils.writeObject(this.output, obj, objectTypeRef);
                    ++i;
                }
                BinaryPListUtils.RefSize offsetTypeRef = BinaryPListUtils.RefSize.forValue(position);
                for (Long offset : objectOffsets) {
                    offsetTypeRef.write(this.output, offset);
                }
                BinaryPListUtils.writeTrailer(this.output, new BinaryPListUtils.Trailer(refTable.size(), position));
            }
            catch (IOException e) {
                throw NSForwardException._runtimeExceptionForThrowable(e);
            }
        }
    }
}

