/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.plist;

import com.webobjects.foundation.properties.NSBooleanProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.text.Normalizer;
import java.util.WeakHashMap;

public abstract class _PListParser {
    private static final NSBooleanProperty REUSE_SHARED_VALUES = new NSBooleanProperty("NSCheckFix.reusePropertyListValues", true);
    protected static final InternPool<Object> INTERN_POOL = new InternPool();
    protected static final int EOT = -1;
    protected static final String DefaultSimpleDateFormatPattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private InternPool<Object> _sharedPool = _PListParser._sharedValuePool();

    protected Object _sharedValue(Object value) {
        Object result = value;
        if (value instanceof String || value instanceof Number) {
            result = this._sharedPool.intern(value);
        }
        return result;
    }

    public abstract Object propertyListWithStream(InputStream var1, Normalizer.Form var2);

    public abstract void writePropertyListToStream(Object var1, OutputStream var2) throws IOException;

    public static InternPool<Object> _sharedValuePool() {
        return REUSE_SHARED_VALUES.value() != false ? INTERN_POOL : new InternPool();
    }

    public static class InternPool<T> {
        private final WeakHashMap<T, Reference<T>> map = new WeakHashMap();

        private T get(T object) {
            Reference<T> ref = this.map.get(object);
            return ref != null ? (T)ref.get() : null;
        }

        private void put(T object) {
            this.map.put(object, new WeakReference<T>(object));
        }

        public synchronized T intern(T object) {
            T result = this.get(object);
            if (result == null) {
                this.put(object);
                result = object;
            }
            return result;
        }
    }
}

