/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.plist;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation.plist._PListTextParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _JSONPListImpl
extends _PListTextParser {
    private int _lineNumber;
    private int _startOfLineCharIndex;
    private int _savedIndex;
    private int _savedLineNumber;
    private int _savedStartOfLineCharIndex;
    private SimpleDateFormat _dateFormat;
    private static final Logger log = LoggerFactory.getLogger(_JSONPListImpl.class);
    private static final int _C_NON_COMMENT_OR_SPACE = 1;
    private static final int _C_WHITESPACE = 2;
    private static final int _C_SINGLE_LINE_COMMENT = 3;
    private static final int _C_MULTI_LINE_COMMENT = 4;
    private static final int[] NSToPrecompUnicodeTable = new int[]{160, 192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 221, 222, 181, 215, 247, 169, 161, 162, 163, 8260, 165, 402, 167, 164, 8217, 8220, 171, 8249, 8250, 64257, 64258, 174, 8211, 8224, 8225, 183, 166, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 172, 191, 185, 715, 180, 710, 732, 175, 728, 729, 168, 178, 730, 184, 179, 733, 731, 711, 8212, 177, 188, 189, 190, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235, 236, 198, 237, 170, 238, 239, 240, 241, 321, 216, 338, 186, 242, 243, 244, 245, 246, 230, 249, 250, 251, 305, 252, 253, 322, 248, 339, 223, 254, 255, 65533, 65533};

    public _JSONPListImpl() {
        super(true);
        this._init();
    }

    public _JSONPListImpl(boolean indents) {
        super(indents);
        this._init();
    }

    private void _init() {
        this._dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this._dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this._dateFormat.setLenient(true);
    }

    private void _saveIndexes(int i, int j, int k) {
        this._savedIndex = i;
        this._savedLineNumber = j;
        this._savedStartOfLineCharIndex = k;
    }

    private String _savedIndexesAsString() {
        return "line number: " + this._savedLineNumber + ", column: " + (this._savedIndex - this._savedStartOfLineCharIndex);
    }

    public static boolean propertyListsAreEqual(Object obj, Object obj1) {
        if (obj == null && obj1 == null) {
            return true;
        }
        if ((obj instanceof String || obj instanceof StringBuffer || obj instanceof StringBuilder) && (obj1 instanceof String || obj1 instanceof StringBuffer || obj1 instanceof StringBuilder)) {
            return obj.toString().equals(obj1.toString());
        }
        if (obj instanceof NSData && obj1 instanceof NSData) {
            return ((NSData)obj).isEqualToData((NSData)obj1);
        }
        if (obj instanceof NSArray && obj1 instanceof NSArray) {
            int k;
            NSArray nsarray = (NSArray)obj;
            NSArray nsarray1 = (NSArray)obj1;
            int i = nsarray.count();
            if (i != (k = nsarray1.count())) {
                return false;
            }
            int i1 = 0;
            while (i1 < i) {
                if (!_JSONPListImpl.propertyListsAreEqual(nsarray.objectAtIndex(i1), nsarray1.objectAtIndex(i1))) {
                    return false;
                }
                ++i1;
            }
            return true;
        }
        if (obj instanceof NSDictionary && obj1 instanceof NSDictionary) {
            int l;
            NSDictionary nsdictionary = (NSDictionary)obj;
            NSDictionary nsdictionary1 = (NSDictionary)obj1;
            int j = nsdictionary.count();
            if (j != (l = nsdictionary1.count())) {
                return false;
            }
            Enumeration enumeration = nsdictionary.keyEnumerator();
            while (enumeration.hasMoreElements()) {
                Object obj2 = enumeration.nextElement();
                Object obj3 = nsdictionary1.objectForKey(obj2);
                if (obj3 == null) {
                    return false;
                }
                Object obj4 = nsdictionary.objectForKey(obj2);
                if (_JSONPListImpl.propertyListsAreEqual(obj4, obj3)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static Object copyPropertyList(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return obj;
        }
        if (obj instanceof StringBuffer) {
            return new String((StringBuffer)obj);
        }
        if (obj instanceof NSData) {
            return ((NSData)obj).clone();
        }
        if (obj instanceof NSArray) {
            NSArray array = (NSArray)obj;
            int i = array.count();
            NSMutableArray<int> newArray = new NSMutableArray<int>(i);
            int j = 0;
            while (j < i) {
                newArray.addObject((int)_JSONPListImpl.copyPropertyList(array.objectAtIndex(j)));
                ++j;
            }
            return newArray;
        }
        if (obj instanceof NSDictionary) {
            NSDictionary dictionary = (NSDictionary)obj;
            NSMutableDictionary<Object, Object> newDictionary = new NSMutableDictionary<Object, Object>(dictionary.count());
            for (Map.Entry entry : dictionary.entrySet()) {
                newDictionary.setObjectForKey(_JSONPListImpl.copyPropertyList(entry.getValue()), _JSONPListImpl.copyPropertyList(entry.getKey()));
            }
            return newDictionary;
        }
        throw new IllegalArgumentException("Property list copying failed while attempting to copy non property list type: " + obj.getClass().getName());
    }

    @Override
    public String stringFromPropertyList(Object plist, boolean suppressWhitespace) {
        if (plist == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(128);
        this._appendObjectToStringBuffer(plist, buffer, 0, suppressWhitespace);
        return buffer.toString();
    }

    @Override
    public Object propertyListFromString(String string, Normalizer.Form normalizerForm) {
        if (string == null) {
            return null;
        }
        char[] charArray = string.toCharArray();
        Object[] aobj = new Object[1];
        this._lineNumber = 1;
        this._startOfLineCharIndex = 0;
        aobj[0] = null;
        int i = 0;
        i = this._readObjectIntoObjectReference(charArray, i, aobj, 1000, normalizerForm);
        if ((i = this._skipWhitespaceAndComments(charArray, i)) != -1) {
            throw new IllegalArgumentException("parseStringIntoPlist parsed an object, but there's still more text in the string. A plist should contain only one top-level object. Line number: " + this._lineNumber + ", column: " + (i - this._startOfLineCharIndex) + ".");
        }
        return aobj[0];
    }

    @Override
    public Object propertyListWithStream(InputStream is, String encoding, Normalizer.Form normalizerForm) {
        return this.propertyListFromString(_NSStringUtilities.stringFromInputStream(is, encoding), normalizerForm);
    }

    @Override
    public void writePropertyListToStream(Object plist, String encoding, OutputStream out) throws IOException {
        String string = this.stringFromPropertyList(plist, false);
        byte[] bytes = string.getBytes(encoding);
        out.write(bytes);
    }

    protected void _appendObjectToStringBuffer(Object obj, StringBuffer stringbuffer, int i, boolean suppressWhitespace) {
        if (obj instanceof String && obj != "NULL") {
            this._appendStringToStringBuffer((String)obj, stringbuffer, i);
        } else if (obj instanceof StringBuffer) {
            this._appendStringToStringBuffer(((StringBuffer)obj).toString(), stringbuffer, i);
        } else if (obj instanceof StringBuilder) {
            this._appendStringToStringBuffer(((StringBuilder)obj).toString(), stringbuffer, i);
        } else if (obj instanceof NSData) {
            this._appendDataToStringBuffer((NSData)obj, stringbuffer, i);
        } else if (obj instanceof List) {
            this._appendListToStringBuffer((List)obj, stringbuffer, i, suppressWhitespace);
        } else if (obj instanceof Map) {
            this._appendMapToStringBuffer((Map)obj, stringbuffer, i, suppressWhitespace);
        } else if (obj instanceof Boolean) {
            stringbuffer.append((Boolean)obj != false ? "true" : "false");
        } else if (obj instanceof BigDecimal) {
            stringbuffer.append(((BigDecimal)obj).toPlainString());
        } else if (obj instanceof Number) {
            stringbuffer.append(((Number)obj).toString());
        } else if (obj instanceof NSTimestamp) {
            this._appendDateToStringBuffer((Date)obj, stringbuffer);
        } else if (obj != null && obj != "NULL") {
            this._appendStringToStringBuffer(obj.toString(), stringbuffer, i);
        } else {
            stringbuffer.append("null");
        }
    }

    private void _appendStringToStringBuffer(String s, StringBuffer stringbuffer, int i) {
        stringbuffer.append('\"');
        char[] ac = s.toCharArray();
        int j = 0;
        while (j < ac.length) {
            if (ac[j] < '\u0080') {
                if (ac[j] == '\n') {
                    stringbuffer.append("\\n");
                } else if (ac[j] == '\r') {
                    stringbuffer.append("\\r");
                } else if (ac[j] == '\t') {
                    stringbuffer.append("\\t");
                } else if (ac[j] == '\"') {
                    stringbuffer.append('\\');
                    stringbuffer.append('\"');
                } else if (ac[j] == '\\') {
                    stringbuffer.append("\\\\");
                } else if (ac[j] == '\f') {
                    stringbuffer.append("\\f");
                } else if (ac[j] == '\b') {
                    stringbuffer.append("\\b");
                } else if (ac[j] == '\u0007') {
                    stringbuffer.append("\\a");
                } else if (ac[j] == '\u000b') {
                    stringbuffer.append("\\v");
                } else {
                    stringbuffer.append(ac[j]);
                }
            } else {
                char c = ac[j];
                byte byte0 = (byte)(c & 0xF);
                c = (char)(c >> 4);
                byte byte1 = (byte)(c & 0xF);
                c = (char)(c >> 4);
                byte byte2 = (byte)(c & 0xF);
                c = (char)(c >> 4);
                byte byte3 = (byte)(c & 0xF);
                c = (char)(c >> 4);
                stringbuffer.append("\\U");
                stringbuffer.append(this._hexDigitForNibble(byte3));
                stringbuffer.append(this._hexDigitForNibble(byte2));
                stringbuffer.append(this._hexDigitForNibble(byte1));
                stringbuffer.append(this._hexDigitForNibble(byte0));
            }
            ++j;
        }
        stringbuffer.append('\"');
    }

    private void _appendDataToStringBuffer(NSData nsdata, StringBuffer stringbuffer, int i) {
        stringbuffer.append('\"');
        stringbuffer.append('<');
        byte[] abyte0 = nsdata.bytes();
        int j = 0;
        while (j < abyte0.length) {
            byte byte0 = abyte0[j];
            byte byte1 = (byte)(byte0 & 0xF);
            byte0 = (byte)(byte0 >> 4);
            byte byte2 = (byte)(byte0 & 0xF);
            stringbuffer.append(this._hexDigitForNibble(byte2));
            stringbuffer.append(this._hexDigitForNibble(byte1));
            ++j;
        }
        stringbuffer.append('>');
        stringbuffer.append('\"');
    }

    private void _appendDateToStringBuffer(Date date, StringBuffer stringbuffer) {
        stringbuffer.append('\"');
        stringbuffer.append(this._dateFormat.format(date));
        stringbuffer.append('\"');
    }

    private void _appendListToStringBuffer(List<?> nsarray, StringBuffer stringbuffer, int i, boolean suppressWhitespace) {
        stringbuffer.append('[');
        int j = nsarray.size();
        if (j > 0) {
            int k = 0;
            while (k < j) {
                if (k > 0) {
                    stringbuffer.append(',');
                }
                if (!suppressWhitespace) {
                    this._appendNewLineToStringBuffer(stringbuffer, i);
                    this._appendIndentationToStringBuffer(stringbuffer, i + 1);
                }
                this._appendObjectToStringBuffer(nsarray.get(k), stringbuffer, i + 1, suppressWhitespace);
                ++k;
            }
            if (!suppressWhitespace) {
                this._appendNewLineToStringBuffer(stringbuffer, i);
                this._appendIndentationToStringBuffer(stringbuffer, i);
            }
        }
        stringbuffer.append(']');
    }

    private void _appendMapToStringBuffer(Map<?, ?> map, StringBuffer stringbuffer, int i, boolean suppressWhitespace) {
        stringbuffer.append('{');
        int j = map.size();
        if (j > 0) {
            Iterator<?> iteration = map.keySet().iterator();
            while (iteration.hasNext()) {
                Object obj = iteration.next();
                if (!(obj instanceof String)) {
                    throw new IllegalArgumentException("JSON Property list generation failed while attempting to write hashtable. Non-String key found in Hashtable. Property list dictionaries must have String's as keys.");
                }
                if (!suppressWhitespace) {
                    this._appendNewLineToStringBuffer(stringbuffer, i);
                    this._appendIndentationToStringBuffer(stringbuffer, i + 1);
                }
                this._appendStringToStringBuffer((String)obj, stringbuffer, i + 1);
                stringbuffer.append(" : ");
                this._appendObjectToStringBuffer(map.get(obj), stringbuffer, i + 1, suppressWhitespace);
                if (!iteration.hasNext()) continue;
                stringbuffer.append(',');
            }
            if (!suppressWhitespace) {
                this._appendNewLineToStringBuffer(stringbuffer, i);
                this._appendIndentationToStringBuffer(stringbuffer, i);
            }
        }
        stringbuffer.append('}');
    }

    private final char _hexDigitForNibble(byte nibble) {
        char c = '\u0000';
        if (nibble >= 0 && nibble <= 9) {
            c = (char)(48 + (char)nibble);
        } else if (nibble >= 10 && nibble <= 15) {
            c = (char)(97 + (char)(nibble - 10));
        }
        return c;
    }

    private int _readObjectIntoObjectReference(char[] ac, int index, Object[] aobj, int depthLeft, Normalizer.Form normalizerForm) {
        if (depthLeft <= 0 && NSProperties.booleanForKeyWithDefault("NSPropertyListSerialization.CheckMaxDeepness", true)) {
            throw new RuntimeException("The provided property list was more than 1000 levels deep.");
        }
        int aBufferIndex = index;
        if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1 || aBufferIndex >= ac.length) {
            aobj[0] = null;
        } else if (ac[aBufferIndex] == '\"') {
            StringBuffer buffer = new StringBuffer(64);
            aBufferIndex = this._readQuotedStringIntoStringBuffer(ac, aBufferIndex, buffer);
            if (normalizerForm != null) {
                String temp = buffer.toString();
                if (!Normalizer.isNormalized(temp, normalizerForm)) {
                    temp = Normalizer.normalize(temp, normalizerForm);
                }
                aobj[0] = temp;
            } else {
                aobj[0] = buffer.toString();
            }
        } else if (ac[aBufferIndex] == '<') {
            NSMutableData data = new NSMutableData(this._lengthOfData(ac, aBufferIndex));
            aBufferIndex = this._readDataContentsIntoData(ac, aBufferIndex, data);
            aobj[0] = data;
        } else if (ac[aBufferIndex] == '[') {
            NSMutableArray<Object> array = new NSMutableArray<Object>();
            aBufferIndex = this._readArrayContentsIntoArray(ac, aBufferIndex, array, depthLeft, normalizerForm);
            aobj[0] = array;
        } else if (ac[aBufferIndex] == '{') {
            NSMutableDictionary<Object, Object> dictionary = new NSMutableDictionary<Object, Object>();
            aBufferIndex = this._readDictionaryContentsIntoDictionary(ac, aBufferIndex, dictionary, depthLeft, normalizerForm);
            aobj[0] = dictionary;
        } else {
            StringBuffer buffer = new StringBuffer(64);
            aBufferIndex = this._readUnquotedStringIntoStringBuffer(ac, aBufferIndex, buffer);
            String theString = buffer.toString();
            if ("true".equals(theString)) {
                aobj[0] = Boolean.TRUE;
            } else if ("false".equals(theString)) {
                aobj[0] = Boolean.FALSE;
            } else if ("null".equals(theString)) {
                aobj[0] = "NULL";
            } else {
                try {
                    aobj[0] = theString.indexOf(".") >= 0 ? new BigDecimal(theString) : new BigInteger(theString);
                }
                catch (Exception exception) {
                    log.error("Exception ", (Throwable)exception);
                    aobj[0] = theString;
                }
            }
        }
        return aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _readUnquotedStringIntoStringBuffer(char[] ac, int index, StringBuffer buffer) {
        int aBufferIndex;
        int j = aBufferIndex = index;
        buffer.setLength(0);
        while (aBufferIndex < ac.length && (ac[aBufferIndex] >= 'a' && ac[aBufferIndex] <= 'z' || ac[aBufferIndex] >= 'A' && ac[aBufferIndex] <= 'Z' || ac[aBufferIndex] >= '0' && ac[aBufferIndex] <= '9' || ac[aBufferIndex] == '_' || ac[aBufferIndex] == '$' || ac[aBufferIndex] == '.' || ac[aBufferIndex] == '/' || ac[aBufferIndex] == '-')) {
            ++aBufferIndex;
        }
        if (j >= aBufferIndex) {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read unquoted string. No allowable characters were found. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".  Current char is " + ac[j] + ".");
        }
        buffer.append(ac, j, aBufferIndex - j);
        return aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _readQuotedStringIntoStringBuffer(char[] ac, int index, StringBuffer stringbuffer) {
        int aBufferIndex = index;
        this._saveIndexes(aBufferIndex, this._lineNumber, this._startOfLineCharIndex);
        int j = ++aBufferIndex;
        while (aBufferIndex < ac.length && ac[aBufferIndex] != '\"') {
            if (ac[aBufferIndex] == '\\') {
                if (j < aBufferIndex) {
                    stringbuffer.append(ac, j, aBufferIndex - j);
                }
                if (++aBufferIndex >= ac.length) {
                    throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
                }
                if (ac[aBufferIndex] == 'n') {
                    stringbuffer.append('\n');
                } else if (ac[aBufferIndex] == 'r') {
                    stringbuffer.append('\r');
                    ++aBufferIndex;
                } else if (ac[aBufferIndex] == 't') {
                    stringbuffer.append('\t');
                    ++aBufferIndex;
                } else if (ac[aBufferIndex] == 'f') {
                    stringbuffer.append('\f');
                    ++aBufferIndex;
                } else if (ac[aBufferIndex] == 'b') {
                    stringbuffer.append('\b');
                    ++aBufferIndex;
                } else if (ac[aBufferIndex] == 'a') {
                    stringbuffer.append('\u0007');
                    ++aBufferIndex;
                } else if (ac[aBufferIndex] == 'v') {
                    stringbuffer.append('\u000b');
                    ++aBufferIndex;
                } else if (ac[aBufferIndex] == 'u' || ac[aBufferIndex] == 'U') {
                    if (aBufferIndex + 4 >= ac.length) {
                        throw new IllegalArgumentException("Property list parsing failed while attempting to read quoted string. Input exhausted before escape sequence was completed. Opening quote was at " + this._savedIndexesAsString() + ".");
                    }
                    if (!(this._isHexDigit(ac[++aBufferIndex]) && this._isHexDigit(ac[aBufferIndex + 1]) && this._isHexDigit(ac[aBufferIndex + 2]) && this._isHexDigit(ac[aBufferIndex + 3]))) {
                        throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read quoted string. Improperly formed \\U type escape sequence. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
                    }
                    byte byte0 = this._nibbleForHexDigit(ac[aBufferIndex]);
                    byte byte1 = this._nibbleForHexDigit(ac[aBufferIndex + 1]);
                    byte byte2 = this._nibbleForHexDigit(ac[aBufferIndex + 2]);
                    byte byte3 = this._nibbleForHexDigit(ac[aBufferIndex + 3]);
                    stringbuffer.append((char)((byte0 << 12) + (byte1 << 8) + (byte2 << 4) + byte3));
                    aBufferIndex += 4;
                } else if (ac[aBufferIndex] >= '0' && ac[aBufferIndex] <= '7') {
                    int k = 0;
                    int l = 1;
                    int[] ai = new int[3];
                    ai[0] = ac[aBufferIndex] - 48;
                    ++aBufferIndex;
                    while (l < 3 && aBufferIndex < ac.length && ac[aBufferIndex] >= '0' && ac[aBufferIndex] <= '7') {
                        ai[l++] = ac[aBufferIndex] - 48;
                        ++aBufferIndex;
                    }
                    if (l == 3 && ai[0] > 3) {
                        throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read quoted string. Octal escape sequence too large (bigger than octal 377). At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
                    }
                    int i1 = 0;
                    while (i1 < l) {
                        k *= 8;
                        k += ai[i1];
                        ++i1;
                    }
                    stringbuffer.append(this._nsToUnicode(k));
                } else {
                    stringbuffer.append(ac[aBufferIndex]);
                    if (ac[aBufferIndex] == '\n') {
                        ++this._lineNumber;
                        this._startOfLineCharIndex = aBufferIndex + 1;
                    }
                    ++aBufferIndex;
                }
                j = ++aBufferIndex;
                continue;
            }
            if (ac[aBufferIndex] == '\n') {
                ++this._lineNumber;
                this._startOfLineCharIndex = aBufferIndex + 1;
            }
            ++aBufferIndex;
        }
        if (j < aBufferIndex) {
            stringbuffer.append(ac, j, aBufferIndex - j);
        }
        if (aBufferIndex >= ac.length) {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".");
        }
        return ++aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _lengthOfData(char[] ac, int index) {
        boolean isHexDigit;
        int aBufferIndex = index;
        int j = 0;
        ++aBufferIndex;
        while (aBufferIndex < ac.length && ((isHexDigit = this._isHexDigit(ac[aBufferIndex])) || this._isWhitespace(ac[aBufferIndex]))) {
            if (isHexDigit) {
                ++j;
            }
            ++aBufferIndex;
        }
        if (aBufferIndex >= ac.length) {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read data. Input exhausted before data was terminated with '>'. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
        }
        if (ac[aBufferIndex] != '>') {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read data. Illegal character encountered in data: '" + ac[aBufferIndex] + "'. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
        }
        if (j % 2 != 0) {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read data. An odd number of half-bytes were specified. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
        }
        return j / 2;
    }

    private int _readDataContentsIntoData(char[] ac, int index, NSMutableData nsmutabledata) {
        int aBufferIndex = index;
        ++aBufferIndex;
        while (ac[aBufferIndex] != '>' && ac[aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)] != '>') {
            byte byte0 = this._nibbleForHexDigit(ac[aBufferIndex]);
            ++aBufferIndex;
            aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
            byte byte1 = this._nibbleForHexDigit(ac[aBufferIndex]);
            ++aBufferIndex;
            nsmutabledata.appendByte((byte)((byte0 << 4) + byte1));
        }
        return ++aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _readArrayContentsIntoArray(char[] ac, int index, NSMutableArray<Object> nsmutablearray, int depthLeft, Normalizer.Form normalizerForm) {
        int aBufferIndex = index;
        Object[] aobj = new Object[1];
        ++aBufferIndex;
        nsmutablearray.removeAllObjects();
        aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
        while (aBufferIndex != -1 && ac[aBufferIndex] != ']') {
            if (nsmutablearray.count() > 0) {
                if (ac[aBufferIndex] != ',') {
                    throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read array. No comma found between array elements. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
                }
                ++aBufferIndex;
                if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1) {
                    throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
                }
            }
            if (ac[aBufferIndex] == ']') continue;
            aobj[0] = null;
            aBufferIndex = this._readObjectIntoObjectReference(ac, aBufferIndex, aobj, depthLeft - 1, normalizerForm);
            if (aobj[0] == null) {
                throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read array. Failed to read content object. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
            }
            aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
            nsmutablearray.addObject(this._sharedValue(aobj[0]));
        }
        if (aBufferIndex == -1) {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
        }
        return ++aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _readDictionaryContentsIntoDictionary(char[] ac, int index, NSMutableDictionary<Object, Object> nsmutabledictionary, int depthLeft, Normalizer.Form normalizerForm) {
        int aBufferIndex = index;
        Object[] aobj = new Object[1];
        Object[] aobj1 = new Object[1];
        ++aBufferIndex;
        if (nsmutabledictionary.count() != 0) {
            nsmutabledictionary.removeAllObjects();
        }
        aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
        while (aBufferIndex != -1 && ac[aBufferIndex] != '}') {
            aBufferIndex = this._readObjectIntoObjectReference(ac, aBufferIndex, aobj, depthLeft - 1, normalizerForm);
            if (aobj[0] == null || !(aobj[0] instanceof String)) {
                throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read dictionary. Failed to read key or key is not a String. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
            }
            if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1 || ac[aBufferIndex] != ':') {
                log.info("Exception for key=" + aobj[0] + " with unparsed values=" + new StringBuilder().append(ac, aBufferIndex, ac.length - aBufferIndex));
                throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read dictionary. Read key " + aobj[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".  Parsed '" + ac[aBufferIndex] + "' instead.");
            }
            ++aBufferIndex;
            if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1) {
                throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read dictionary. Encountered unexpected end of file while reading key " + aobj[0] + " with no value. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
            }
            aBufferIndex = this._readObjectIntoObjectReference(ac, aBufferIndex, aobj1, depthLeft - 1, normalizerForm);
            if (aobj1[0] == null) {
                throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read dictionary. Failed to read value. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
            }
            if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1) {
                throw new IllegalArgumentException("Unexpected end of JSON string");
            }
            if (ac[aBufferIndex] == '}') {
                nsmutabledictionary.setObjectForKey(this._sharedValue(aobj1[0]), this._sharedValue(aobj[0]));
                break;
            }
            ++aBufferIndex;
            aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
            nsmutabledictionary.setObjectForKey(this._sharedValue(aobj1[0]), this._sharedValue(aobj[0]));
        }
        if (aBufferIndex >= ac.length) {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to read dictionary. Exhausted input before end of dictionary was found. At line number: " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
        }
        if (aBufferIndex == -1) {
            return aBufferIndex;
        }
        return ++aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _checkForWhitespaceOrComment(char[] ac, int index) {
        if (index == -1 || index >= ac.length) {
            return 1;
        }
        if (this._isWhitespace(ac[index])) {
            return 2;
        }
        if (index + 1 < ac.length) {
            if (ac[index] == '/' && ac[index + 1] == '/') {
                return 3;
            }
            if (ac[index] == '/' && ac[index + 1] == '*') {
                return 4;
            }
        }
        return 1;
    }

    private int _skipWhitespaceAndComments(char[] ac, int index) {
        int aBufferIndex = index;
        int j = this._checkForWhitespaceOrComment(ac, aBufferIndex);
        while (j != 1) {
            switch (j) {
                case 2: {
                    aBufferIndex = this._processWhitespace(ac, aBufferIndex);
                    break;
                }
                case 3: {
                    aBufferIndex = this._processSingleLineComment(ac, aBufferIndex);
                    break;
                }
                case 4: {
                    aBufferIndex = this._processMultiLineComment(ac, aBufferIndex);
                }
            }
            j = this._checkForWhitespaceOrComment(ac, aBufferIndex);
        }
        return aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _processWhitespace(char[] ac, int index) {
        int aBufferIndex = index;
        while (aBufferIndex < ac.length && this._isWhitespace(ac[aBufferIndex])) {
            if (ac[aBufferIndex] == '\n') {
                ++this._lineNumber;
                this._startOfLineCharIndex = aBufferIndex + 1;
            }
            ++aBufferIndex;
        }
        return aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _processSingleLineComment(char[] ac, int index) {
        int aBufferIndex = index;
        aBufferIndex += 2;
        while (aBufferIndex < ac.length && ac[aBufferIndex] != '\n') {
            ++aBufferIndex;
        }
        return aBufferIndex < ac.length ? aBufferIndex : -1;
    }

    private int _processMultiLineComment(char[] ac, int index) {
        int aBufferIndex = index;
        this._saveIndexes(aBufferIndex, this._lineNumber, this._startOfLineCharIndex);
        aBufferIndex += 2;
        while (aBufferIndex + 1 < ac.length && (ac[aBufferIndex] != '*' || ac[aBufferIndex + 1] != '/')) {
            if (ac[aBufferIndex] == '/' && ac[aBufferIndex + 1] == '*') {
                throw new IllegalArgumentException("JSON Property list parsing does not support embedded multi line comments.The first opening comment was at " + this._savedIndexesAsString() + ". A second opening comment was found at line " + this._lineNumber + ", column: " + (aBufferIndex - this._startOfLineCharIndex) + ".");
            }
            if (ac[aBufferIndex] == '\n') {
                ++this._lineNumber;
                this._startOfLineCharIndex = aBufferIndex + 1;
            }
            ++aBufferIndex;
        }
        if (aBufferIndex + 1 >= ac.length || ac[aBufferIndex] != '*' || ac[aBufferIndex + 1] != '/') {
            throw new IllegalArgumentException("JSON Property list parsing failed while attempting to find closing to comment that began at " + this._savedIndexesAsString() + ".");
        }
        return (aBufferIndex += 2) < ac.length ? aBufferIndex : -1;
    }

    private final byte _nibbleForHexDigit(char c) {
        byte i = 0;
        if (c >= '0' && c <= '9') {
            i = (byte)(c - 48);
        } else if (c >= 'a' && c <= 'f') {
            i = (byte)(c - 97 + 10);
        } else if (c >= 'A' && c <= 'F') {
            i = (byte)(c - 65 + 10);
        } else {
            throw new IllegalArgumentException("JSON Property list parsing found non-hex digit passed to _nibbleForHexDigit()");
        }
        return i;
    }

    private final boolean _isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    private final boolean _isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    private char _nsToUnicode(int i) {
        return i >= 128 ? (char)NSToPrecompUnicodeTable[i - 128] : (char)i;
    }
}

