/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.plist;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSBase64;
import com.webobjects.foundation.plist.PListType;
import com.webobjects.foundation.plist._PListParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class _BinaryPListImpl
extends _PListParser {
    private static final Logger log = LoggerFactory.getLogger(_BinaryPListImpl.class);
    private static final double kCFAbsoluteTimeIntervalSince1970 = 9.783072E8;
    private long sortVersion;
    private RefType objectRefType;
    private RefType offsetRefType;
    private long numObjects;
    private long topObject;
    private long offsetTableOffset;
    List<Object> objectTable;
    List<Long> objectIndexTable;
    private static final Charset US_ASCII = Charset.forName("US-ASCII");

    protected long encodeObject(Object object, List<EncodedObject> objectList, Map<Object, Long> uniquingTable) {
        if (uniquingTable.containsKey(object)) {
            return uniquingTable.get(object);
        }
        long objectIndex = objectList.size();
        uniquingTable.put(object, objectIndex);
        PListType type = PListType.valueOf(object);
        switch (type) {
            case STRING: {
                objectList.add(new EncodedObject(this.encodeString((String)object)));
                break;
            }
            case INTEGER: {
                objectList.add(new EncodedObject(this.encodeInt((Number)object)));
                break;
            }
            case FLOAT: {
                objectList.add(new EncodedObject(this.encodeReal((Number)object)));
                break;
            }
            case DATE: {
                objectList.add(new EncodedObject(this.encodeDate((Date)object)));
                break;
            }
            case BOOLEAN: {
                objectList.add(new EncodedObject(this.encodeBoolean((Boolean)object)));
                break;
            }
            case DATA: {
                byte[] theBytes = null;
                theBytes = object instanceof NSData ? ((NSData)object).bytes() : (byte[])object;
                objectList.add(new EncodedObject(this.encodeData(theBytes)));
                break;
            }
            case DICTIONARY: {
                Map dict = (Map)object;
                int count = dict.size();
                EncodedDictionary dictionary = new EncodedDictionary(this.encodeCount(count, Type.kCFBinaryPlistMarkerDict));
                objectList.add(dictionary);
                Map<Object, Long> newUniquingTable = uniquingTable;
                newUniquingTable = new NSMutableDictionary<Object, Long>(uniquingTable);
                for (Map.Entry entry : dict.entrySet()) {
                    dictionary.addKeyRef(this.encodeObject(entry.getKey(), objectList, newUniquingTable));
                    dictionary.addValueRef(this.encodeObject(entry.getValue(), objectList, newUniquingTable));
                }
                break;
            }
            case ARRAY: {
                Collection list = (Collection)object;
                int count = list.size();
                EncodedArray array = new EncodedArray(this.encodeCount(count, Type.kCFBinaryPlistMarkerArray));
                objectList.add(array);
                Map<Object, Long> newUniquingTable = uniquingTable;
                newUniquingTable = new NSMutableDictionary<Object, Long>(uniquingTable);
                for (Object aValue : list) {
                    array.addValueRef(this.encodeObject(aValue, objectList, newUniquingTable));
                }
                break;
            }
            case SET: {
                Collection list = (Collection)object;
                int count = list.size();
                EncodedSet set = new EncodedSet(this.encodeCount(count, Type.kCFBinaryPlistMarkerSet));
                objectList.add(set);
                Map<Object, Long> newUniquingTable = uniquingTable;
                newUniquingTable = new NSMutableDictionary<Object, Long>(uniquingTable);
                for (Object aValue : list) {
                    set.addValueRef(this.encodeObject(aValue, objectList, newUniquingTable));
                }
                break;
            }
            case NULL: {
                objectList.add(new EncodedObject(this.encodeNull()));
                break;
            }
            case UUID: {
                objectList.add(new EncodedObject(this.encodeUUID((UUID)object)));
                break;
            }
            case FILL: {
                objectList.add(new EncodedObject(this.encodeFillByte()));
                break;
            }
            default: {
                objectList.add(new EncodedObject(this.encodeString(object.toString())));
            }
        }
        return objectIndex;
    }

    @Override
    public void writePropertyListToStream(Object plist, OutputStream out) throws IOException {
        if (plist == null || out == null) {
            log.warn("Encountered empty plist or null outputstream, returning");
            return;
        }
        WritableByteChannel channel = Channels.newChannel(out);
        ByteBuffer buffer = ByteBuffer.allocate(1024).order(ByteOrder.BIG_ENDIAN);
        buffer.put("bplist00".getBytes());
        ArrayList<EncodedObject> objectList = new ArrayList<EncodedObject>(512);
        HashMap<Object, Long> uniquingTable = new HashMap<Object, Long>(2048);
        long theTopObject = this.encodeObject(plist, objectList, uniquingTable);
        long numberOfObjects = objectList.size();
        RefType reftype = RefType.forValue(numberOfObjects);
        ArrayList<Long> objectOffsets = new ArrayList<Long>(objectList.size());
        int length = 0;
        for (EncodedObject object : objectList) {
            objectOffsets.add(Long.valueOf(length + buffer.position()));
            int size = object.size(reftype);
            if (buffer.remaining() < size) {
                buffer = ByteBuffer.allocate(size).order(ByteOrder.BIG_ENDIAN);
            }
            object.appendToData(buffer, reftype);
            buffer.flip();
            length += channel.write(buffer);
            buffer.clear();
        }
        int offsetTableStart = length;
        RefType objtype = RefType.forValue(offsetTableStart);
        for (Long offset : objectOffsets) {
            buffer.put(objtype.encode(offset));
        }
        buffer.put(new byte[5]);
        buffer.put((byte)0);
        buffer.put((byte)objtype.size());
        buffer.put((byte)reftype.size());
        buffer.putLong(numberOfObjects);
        buffer.putLong(theTopObject);
        buffer.putLong(offsetTableStart);
        buffer.flip();
        channel.write(buffer);
        channel.close();
    }

    public Object propertyListWithURL(URL url, Normalizer.Form normalizerForm) throws IOException {
        Object object;
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        try {
            object = this._propertyListWithStream(is, normalizerForm);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw new NSForwardException("Failed to decode binary plist at " + url, e);
            }
        }
        is.close();
        return object;
    }

    @Override
    public Object propertyListWithStream(InputStream is, Normalizer.Form normalizerForm) {
        try {
            return this._propertyListWithStream(is, normalizerForm);
        }
        catch (RuntimeException e) {
            throw new NSForwardException("Failed to decode binary plist from the provided stream.", e);
        }
        catch (IOException e) {
            throw new NSForwardException("Failed to decode binary plist from the provided stream.", e);
        }
    }

    protected Object _propertyListWithStream(InputStream is, Normalizer.Form normalizerForm) throws IOException {
        if (is == null) {
            log.error("The stream paramenter cannot be null.");
            return null;
        }
        this._parseBinaryStream(is, normalizerForm);
        Object binaryObject = this.objectTable.get(0);
        Cloneable propertyListObject = null;
        if (binaryObject instanceof BinaryDict) {
            BinaryDict bDict = (BinaryDict)binaryObject;
            propertyListObject = bDict.toNSDictionary();
        } else if (binaryObject instanceof BinaryArray) {
            BinaryArray barray = (BinaryArray)binaryObject;
            propertyListObject = barray.toNSArray();
        } else if (binaryObject instanceof BinarySet) {
            BinarySet bset = (BinarySet)binaryObject;
            propertyListObject = bset.toNSSet();
        } else {
            propertyListObject = binaryObject;
        }
        return propertyListObject;
    }

    public Document propertyListDocumentWithURL(URL url, Normalizer.Form normalizerForm) {
        Document document;
        if (url == null) {
            log.error("URL paramenter cannot be null");
            return null;
        }
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        try {
            document = this.propertyListDocumentWithStream(is, normalizerForm);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (RuntimeException e) {
                throw new NSForwardException("Failed to decode binary plist at " + url, e);
            }
            catch (IOException e) {
                throw new NSForwardException("Failed to decode binary plist at " + url, e);
            }
        }
        is.close();
        return document;
    }

    public Document propertyListDocumentWithStream(InputStream is, Normalizer.Form normalizerForm) {
        if (is == null) {
            log.error("InputStream paramenter cannot be null");
            return null;
        }
        try {
            this._parseBinaryStream(is, normalizerForm);
            return this.toPropertyListDocument();
        }
        catch (ParserConfigurationException e) {
            throw new NSForwardException("Failed to parse binary plist.", e);
        }
        catch (IOException e) {
            throw new NSForwardException("Failed to parse binary plist.", e);
        }
    }

    protected Document toPropertyListDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document root = null;
        DocumentBuilder builder = factory.newDocumentBuilder();
        root = builder.newDocument();
        root.setXmlStandalone(true);
        Element elem = root.createElement("plist");
        elem.setAttribute("version", "1.0");
        root.appendChild(elem);
        this.convertObjectTableToXML(elem, root, this.objectTable.get(0));
        return root;
    }

    public static boolean isBinaryPList(byte[] theBytes) {
        ByteBuffer buffer = ByteBuffer.wrap(theBytes).order(ByteOrder.BIG_ENDIAN);
        return _BinaryPListImpl.isBinaryPList(buffer);
    }

    public static boolean isBinaryPList(ByteBuffer byteBuffer) {
        ByteBuffer buffer = byteBuffer.asReadOnlyBuffer();
        if (buffer.remaining() < 8) {
            return false;
        }
        int bpli = buffer.getInt();
        int st00 = buffer.getInt() & 0xFFFFFF00;
        return bpli == 1651534953 && (st00 &= 0xFFFFFF00) == 1936994304;
    }

    protected void _parseBinaryStream(InputStream is, Normalizer.Form normalizerForm) throws IOException {
        if (is == null) {
            throw new IOException("Property list input stream cannot be null");
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        NSData data = new NSData(bis, -1);
        ByteBuffer buffer = ByteBuffer.wrap(data._bytesNoCopy(), 0, data.length()).order(ByteOrder.BIG_ENDIAN);
        int bpli = buffer.getInt();
        int st00 = buffer.getInt() & 0xFFFFFF00;
        if (bpli != 1651534953 || st00 != 1936994304) {
            throw new IOException("Cannot parse binary property list.  Data does not start with 'bplist00' magic. Got " + bpli + " " + st00);
        }
        buffer.position(buffer.limit() - 27);
        this.sortVersion = buffer.get();
        this.offsetRefType = RefType.sizeOf(buffer.get());
        this.objectRefType = RefType.sizeOf(buffer.get());
        this.numObjects = buffer.getLong();
        this.topObject = buffer.getLong();
        this.offsetTableOffset = buffer.getLong();
        if (this.numObjects < 1L) {
            log.error("numObjects < 1");
            throw new IllegalStateException("Invalid plist content, numObjects < 1");
        }
        if (this.offsetTableOffset < 9L) {
            log.error("offsetTableOffset < 9");
            throw new IllegalStateException("Invalid plist content, offsetTableOffset < 9");
        }
        if (this.offsetRefType == null) {
            log.error("offsetIntSize < 1");
            throw new IllegalStateException("Invalid plist content, offsetIntSize < 1");
        }
        if (this.objectRefType == null) {
            log.error("objectRefSize < 1");
            throw new IllegalStateException("Invalid plist content, objectRefSize < 1");
        }
        if (this.offsetTableOffset < 1L) {
            log.error("offsetTableOffset < 1");
            throw new IllegalStateException("Invalid plist content, offsetTableOffset < 1");
        }
        int expectedLength = (int)(this.offsetTableOffset + this.numObjects * (long)this.offsetRefType.size() + 32L);
        if (buffer.limit() != expectedLength) {
            log.error("bytes read do not correspond to the expected: " + expectedLength + " got: " + buffer.limit());
            throw new IllegalStateException("Invalid plist content, bytes read do not correspond to the expected: " + expectedLength + " got: " + buffer.limit());
        }
        buffer.position((int)this.offsetTableOffset);
        this.objectIndexTable = new ArrayList<Long>((int)this.numObjects);
        long[] objs = this.offsetRefType.parse(buffer, (int)this.numObjects);
        int i = 0;
        while ((long)i < this.numObjects) {
            this.objectIndexTable.add(objs[i]);
            ++i;
        }
        this.objectTable = new ArrayList<Object>((int)this.numObjects);
        for (Long index : this.objectIndexTable) {
            buffer.position(index.intValue());
            this.parseObject(buffer, normalizerForm);
        }
    }

    private void convertObjectTableToXML(Element parent, Document doc, Object object) {
        Element elem = null;
        if (object instanceof BinaryDict) {
            BinaryDict dict = (BinaryDict)object;
            elem = doc.createElement("dict");
            int i = 0;
            while (i < dict.size()) {
                Element key = doc.createElement("key");
                key.setTextContent(dict.getKey(i));
                elem.appendChild(key);
                this.convertObjectTableToXML(elem, doc, dict.getValue(i));
                ++i;
            }
        } else if (object instanceof BinaryArray) {
            BinaryArray arr = (BinaryArray)object;
            elem = doc.createElement("array");
            int i = 0;
            while (i < arr.size()) {
                this.convertObjectTableToXML(elem, doc, arr.getValue(i));
                ++i;
            }
        } else if (object instanceof BinarySet) {
            BinarySet arr = (BinarySet)object;
            elem = doc.createElement("array");
            int i = 0;
            while (i < arr.size()) {
                this.convertObjectTableToXML(elem, doc, arr.getValue(i));
                ++i;
            }
        } else if (object instanceof String) {
            elem = doc.createElement("string");
            elem.setTextContent((String)object);
        } else if (object instanceof Integer) {
            elem = doc.createElement("integer");
            elem.setTextContent(object.toString());
        } else if (object instanceof Long) {
            elem = doc.createElement("integer");
            elem.setTextContent(object.toString());
        } else if (object instanceof Float) {
            elem = doc.createElement("real");
            elem.setTextContent(object.toString());
        } else if (object instanceof Double) {
            elem = doc.createElement("real");
            elem.setTextContent(object.toString());
        } else if (object instanceof Boolean) {
            Boolean b = Boolean.valueOf(object.toString());
            elem = b.booleanValue() ? doc.createElement("true") : doc.createElement("false");
        } else if (object instanceof byte[]) {
            elem = doc.createElement("data");
            elem.setTextContent(new String(_NSBase64.encode((byte[])object)));
        } else if (object instanceof NSData) {
            elem = doc.createElement("data");
            elem.setTextContent(new String(_NSBase64.encode(((NSData)object).bytes())));
        } else if (object instanceof Date) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            elem = doc.createElement("date");
            elem.setTextContent(format.format((Date)object));
        } else {
            elem = doc.createElement("unsupported");
            elem.setTextContent(object.toString());
        }
        parent.appendChild(elem);
    }

    private void parseObject(ByteBuffer buffer, Normalizer.Form normalizerForm) throws IOException {
        Type typeMarker;
        byte marker = buffer.get();
        if (log.isDebugEnabled()) {
            log.debug("Marker=" + marker + " marker & 0xf0=" + (marker & 0xF0) + " (marker & 0xf0) >> 4)=" + ((marker & 0xF0) >> 4));
        }
        if ((typeMarker = Type.typeForValue(marker & 0xF0)) == null) {
            log.warn("Failed to translate binary plist marker " + marker);
            return;
        }
        int count = marker & 0xF;
        if (!typeMarker.isFixedLength() && count == 15) {
            int countMarker = buffer.get() & 0xFF;
            if ((countMarker & 0xF0) != Type.kCFBinaryPlistMarkerInt.value()) {
                throw new IOException("variableLengthInt: Illegal marker " + Integer.toBinaryString(marker));
            }
            int countSize = 1 << (countMarker & 0xF);
            if (countSize > buffer.remaining()) {
                throw new IOException("variableLengthInt: Illegal count " + countSize + " for marker: " + marker + " of type: " + (Object)((Object)typeMarker));
            }
            long value = 0L;
            int i = 0;
            while (i < countSize) {
                value = value << 8 | (long)buffer.get() & 0xFFL;
                ++i;
            }
            count = (int)value;
        }
        switch (typeMarker) {
            case kCFBinaryPlistMarkerNull: {
                this.parsePrimitive(marker);
                break;
            }
            case kCFBinaryPlistMarkerInt: {
                this.parseInt(buffer, marker);
                break;
            }
            case kCFBinaryPlistMarkerReal: {
                this.parseReal(buffer, marker);
                break;
            }
            case kCFBinaryPlistMarkerDate: {
                this.parseDate(buffer, marker);
                break;
            }
            case kCFBinaryPlistMarkerData: {
                this.parseData(buffer, count);
                break;
            }
            case kCFBinaryPlistMarkerASCIIString: {
                this.parseAsciiString(buffer, count);
                break;
            }
            case kCFBinaryPlistMarkerUnicode16String: {
                this.parseUnicodeString(buffer, count, normalizerForm);
                break;
            }
            case kCFBinaryPlistMarkerUID: {
                this.parseUUID(buffer, marker);
                break;
            }
            case kCFBinaryPlistMarkerArray: {
                this.parseArray(buffer, count);
                break;
            }
            case kCFBinaryPlistMarkerSet: {
                this.parseSet(buffer, count);
                break;
            }
            case kCFBinaryPlistMarkerDict: {
                this.parseDictionary(buffer, count);
                break;
            }
            default: {
                log.debug("Fall through: Marker=" + marker + " marker & 0xf0=" + (marker & 0xF0) + " (marker & 0xf0) >> 4)=" + ((marker & 0xF0) >> 4));
                log.warn("Failed to translate binary plist marker " + (Object)((Object)typeMarker));
            }
        }
    }

    static void debugLog(String logMessage) {
        log.info(logMessage);
    }

    private void parsePrimitive(int marker) throws IOException {
        Type primitive = Type.typeForValue(marker);
        if (primitive == null) {
            throw new IOException("parsePrimitive: illegal primitive " + marker);
        }
        switch (primitive) {
            case kCFBinaryPlistMarkerNull: {
                this.objectTable.add(null);
                break;
            }
            case kCFBinaryPlistMarkerFalse: {
                this.objectTable.add(Boolean.FALSE);
                break;
            }
            case kCFBinaryPlistMarkerTrue: {
                this.objectTable.add(Boolean.TRUE);
                break;
            }
            case kCFBinaryPlistMarkerFill: {
                break;
            }
            default: {
                throw new IOException("parsePrimitive: illegal primitive " + marker);
            }
        }
    }

    private void parseArray(ByteBuffer buffer, int count) throws IOException {
        BinaryArray arr = new BinaryArray(this.objectTable, count);
        arr.parse(buffer, this.objectRefType);
        this.objectTable.add(arr);
    }

    private void parseSet(ByteBuffer buffer, int count) throws IOException {
        BinarySet set = new BinarySet(this.objectTable, count);
        set.parse(buffer, this.objectRefType);
        this.objectTable.add(set);
    }

    private void parseDictionary(ByteBuffer buffer, int count) throws IOException {
        BinaryDict dict = new BinaryDict(this.objectTable, count);
        dict.parse(buffer, this.objectRefType);
        this.objectTable.add(dict);
    }

    private void parseData(ByteBuffer buffer, int count) throws IOException {
        ByteBuffer data = (ByteBuffer)buffer.duplicate().limit(buffer.position() + count);
        this.objectTable.add(new NSData(data));
    }

    private void parseAsciiString(ByteBuffer buffer, int count) throws IOException {
        byte[] bytes = new byte[count];
        buffer.get(bytes);
        this.objectTable.add(new String(bytes, US_ASCII));
    }

    private void parseInt(ByteBuffer buffer, int marker) throws IOException {
        BigInteger value;
        int count = 1 << (marker & 0xF);
        if (count > 16) {
            throw new IllegalArgumentException("parseInt: unsupported byte count:" + count);
        }
        byte[] array = new byte[count];
        buffer.get(array);
        BigInteger bigInteger = value = count < 8 ? new BigInteger(1, array) : new BigInteger(array);
        if (value.bitLength() < 64) {
            this.objectTable.add(value.longValue());
        } else {
            this.objectTable.add(value);
        }
    }

    private void parseReal(ByteBuffer buffer, int marker) throws IOException {
        int count = marker & 0xF;
        switch (count) {
            case 2: {
                this.objectTable.add(Float.valueOf(buffer.getFloat()));
                break;
            }
            case 3: {
                this.objectTable.add(buffer.getDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException("parseReal: unsupported byte count:" + count);
            }
        }
    }

    private void parseDate(ByteBuffer buffer, int marker) throws IOException {
        double date = buffer.getDouble();
        NSTimestamp ts = new NSTimestamp((long)((date + 9.783072E8) * 1000.0));
        this.objectTable.add(ts);
        if (log.isDebugEnabled()) {
            log.info("parseDate double=" + date + " long date=" + (long)date + " timestamp=" + ts + " converted=" + new Date(ts.getTime()));
        }
    }

    private void parseUUID(ByteBuffer buffer, int marker) throws IOException {
        int count = (marker & 0xF) + 1;
        if (count > 16) {
            throw new IllegalArgumentException("parseUUID: unsupported byte count:" + count);
        }
        long mostSigBits = buffer.getLong();
        long leastSigBits = buffer.getLong();
        this.objectTable.add(new UUID(mostSigBits, leastSigBits));
    }

    private void parseUnicodeString(ByteBuffer buffer, int count, Normalizer.Form normalizerForm) throws IOException {
        Charset charSet = Charset.forName("UTF-16BE");
        byte[] bytes = new byte[count * 2];
        buffer.get(bytes);
        if (normalizerForm != null) {
            String temp = new String(bytes, charSet);
            if (!Normalizer.isNormalized(temp, normalizerForm)) {
                temp = Normalizer.normalize(temp, normalizerForm);
            }
            this.objectTable.add(temp);
        } else {
            this.objectTable.add(new String(bytes, charSet));
        }
    }

    private static double _convertDate(Date date) {
        NSTimestamp ts = null;
        ts = date instanceof NSTimestamp ? (NSTimestamp)date : new NSTimestamp(date);
        return (double)(ts.getTime() / 1000L) - 9.783072E8;
    }

    private int typeMarker(Type type, int length) {
        return type.value() | (length < 15 ? length : 15);
    }

    private byte[] encodeBoolean(boolean b) {
        byte[] value = new byte[]{b ? (byte)Type.kCFBinaryPlistMarkerTrue.value() : (byte)Type.kCFBinaryPlistMarkerFalse.value()};
        return value;
    }

    private byte[] encodeNull() {
        byte[] value = new byte[]{(byte)Type.kCFBinaryPlistMarkerNull.value()};
        return value;
    }

    private byte[] encodeFillByte() {
        byte[] value = new byte[]{(byte)Type.kCFBinaryPlistMarkerFill.value()};
        return value;
    }

    private ByteBuffer encodeCount(long value, Type marker) {
        ByteBuffer data = ByteBuffer.allocate(17).order(ByteOrder.BIG_ENDIAN);
        if (value < 15L) {
            data.put((byte)this.typeMarker(marker, (byte)(value & 0xFL)));
        } else {
            data.put((byte)this.typeMarker(marker, 15));
            BigInteger bigint = BigInteger.valueOf(value);
            byte[] bytes = bigint.toByteArray();
            int length = 32 - Integer.numberOfLeadingZeros(bytes.length - 1);
            data.put((byte)this.typeMarker(Type.kCFBinaryPlistMarkerInt, length));
            int byteCount = 1 << length;
            while (byteCount-- > bytes.length) {
                data.put((byte)0);
            }
            data.put(bytes);
        }
        data.flip();
        return data;
    }

    private ByteBuffer encodeInt(Number num) {
        BigInteger bigint = num instanceof BigInteger ? (BigInteger)num : BigInteger.valueOf(num.longValue());
        byte[] bytes = bigint.toByteArray();
        if (bytes.length > 16) {
            throw new IllegalArgumentException("encodeInt: unsupported large number value: " + num);
        }
        int length = 32 - Integer.numberOfLeadingZeros(bytes.length - 1);
        if (bigint.signum() == -1 && length < 3) {
            length = 4;
        }
        ByteBuffer data = ByteBuffer.allocate(17).order(ByteOrder.BIG_ENDIAN);
        data.put((byte)this.typeMarker(Type.kCFBinaryPlistMarkerInt, length));
        int byteCount = 1 << length;
        byte padding = (byte)(bytes[0] < 0 ? 255 : 0);
        while (byteCount-- > bytes.length) {
            data.put(padding);
        }
        data.put(bytes);
        data.flip();
        return data;
    }

    private ByteBuffer encodeUUID(UUID value) {
        long mostSigBits = value.getMostSignificantBits();
        long leastSigBits = value.getLeastSignificantBits();
        ByteBuffer data = ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN);
        data.put((byte)this.typeMarker(Type.kCFBinaryPlistMarkerUID, 15));
        data.putLong(mostSigBits);
        data.putLong(leastSigBits);
        data.flip();
        return data;
    }

    private ByteBuffer encodeReal(Number value) {
        ByteBuffer data = ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN);
        if (value instanceof Float) {
            data.put((byte)this.typeMarker(Type.kCFBinaryPlistMarkerReal, 2));
            data.putFloat(((Float)value).floatValue());
        } else {
            data.put((byte)this.typeMarker(Type.kCFBinaryPlistMarkerReal, 3));
            data.putDouble(value.doubleValue());
        }
        data.flip();
        return data;
    }

    private ByteBuffer encodeString(String value) {
        byte[] theBytes;
        ByteBuffer data = ByteBuffer.allocate(9 + value.length() * 2).order(ByteOrder.BIG_ENDIAN);
        if (Charset.forName("US-ASCII").newEncoder().canEncode(value)) {
            theBytes = value.getBytes(Charset.forName("US-ASCII"));
            data.put(this.encodeCount(value.length(), Type.kCFBinaryPlistMarkerASCIIString));
        } else {
            theBytes = value.getBytes(Charset.forName("UTF-16BE"));
            data.put(this.encodeCount(value.length(), Type.kCFBinaryPlistMarkerUnicode16String));
        }
        data.put(theBytes);
        data.flip();
        return data;
    }

    private ByteBuffer encodeDate(Date value) {
        ByteBuffer data = ByteBuffer.allocate(9).order(ByteOrder.BIG_ENDIAN);
        double convertedDate = _BinaryPListImpl._convertDate(value);
        data.put((byte)this.typeMarker(Type.kCFBinaryPlistMarkerDate, 3));
        data.putLong(Double.doubleToRawLongBits(convertedDate));
        data.flip();
        return data;
    }

    private ByteBuffer encodeData(byte[] theData) {
        ByteBuffer data = ByteBuffer.allocate(theData.length + 9).order(ByteOrder.BIG_ENDIAN);
        data.put(this.encodeCount(theData.length, Type.kCFBinaryPlistMarkerData));
        data.put(theData);
        data.flip();
        return data;
    }

    protected static class BinaryArray
    extends BinaryCollection {
        private final int[] _objref;
        private final List<Object> _objectTable;

        public BinaryArray(List<Object> objectTable, int count) {
            this._objectTable = objectTable;
            this._objref = new int[count];
        }

        public int size() {
            return this._objref.length;
        }

        public void addValueRef(int index, long ref) {
            this._objref[index] = (int)ref;
        }

        public Object getValue(int i) {
            return this._objectTable.get(this._objref[i]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("BinaryArray{");
            int i = 0;
            while (i < this._objref.length) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this._objectTable.size() > this._objref[i] && this._objectTable.get(this._objref[i]) != this) {
                    buf.append(this._objectTable.get(this._objref[i]));
                } else {
                    buf.append("*" + this._objref[i]);
                }
                ++i;
            }
            buf.append('}');
            return buf.toString();
        }

        public NSArray<Object> toNSArray() {
            NSMutableArray<Object> anArray = new NSMutableArray<Object>();
            int i = 0;
            while (i < this._objref.length) {
                Object ref = this._objectTable.get(this._objref[i]);
                if (ref instanceof BinaryArray) {
                    anArray.addObject(((BinaryArray)ref).toNSArray());
                } else if (ref instanceof BinarySet) {
                    anArray.addObject(((BinarySet)ref).toNSSet());
                } else if (ref instanceof BinaryDict) {
                    anArray.addObject(((BinaryDict)ref).toNSDictionary());
                } else {
                    anArray.addObject(ref);
                }
                ++i;
            }
            return anArray.immutableClone();
        }

        @Override
        public void parse(ByteBuffer buffer, RefType objectRefType) {
            long[] refs = objectRefType.parse(buffer, this._objref.length);
            int i = 0;
            while (i < this._objref.length) {
                this.addValueRef(i, refs[i]);
                ++i;
            }
        }
    }

    protected static abstract class BinaryCollection {
        protected BinaryCollection() {
        }

        public abstract void parse(ByteBuffer var1, RefType var2);
    }

    protected static class BinaryDict
    extends BinaryCollection {
        private final int[] _keyref;
        private final int[] _objref;
        private final List<Object> _objectTable;

        public BinaryDict(List<Object> objectTable, int count) {
            this._objectTable = objectTable;
            this._keyref = new int[count];
            this._objref = new int[count];
        }

        public int size() {
            return this._objref.length;
        }

        public void addKeyRef(int index, long ref) {
            this._keyref[index] = (int)ref;
        }

        public void addValueRef(int index, long ref) {
            this._objref[index] = (int)ref;
        }

        public String getKey(int i) {
            return this._objectTable.get(this._keyref[i]).toString();
        }

        public Object getValue(int i) {
            return this._objectTable.get(this._objref[i]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("BinaryDict{");
            int i = 0;
            while (i < this._keyref.length) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this._keyref[i] < 0 || this._keyref[i] >= this._objectTable.size()) {
                    buf.append("#" + this._keyref[i]);
                } else if (this._objectTable.get(this._keyref[i]) == this) {
                    buf.append("*" + this._keyref[i]);
                } else {
                    buf.append(this._objectTable.get(this._keyref[i]));
                }
                buf.append(":");
                if (this._objref[i] < 0 || this._objref[i] >= this._objectTable.size()) {
                    buf.append("#" + this._objref[i]);
                } else if (this._objectTable.get(this._objref[i]) == this) {
                    buf.append("*" + this._objref[i]);
                } else {
                    buf.append(this._objectTable.get(this._objref[i]));
                }
                ++i;
            }
            buf.append('}');
            return buf.toString();
        }

        public NSDictionary<String, ?> toNSDictionary() {
            NSMutableDictionary aDict = new NSMutableDictionary(this._keyref.length);
            int i = 0;
            while (i < this._keyref.length) {
                Object value;
                if (this._keyref[i] < 0 || this._keyref[i] >= this._objectTable.size()) {
                    log.error("Object table is in illegal state.  The key reference " + i + " is larger than the object table size " + this._objectTable.size());
                } else if (this._objectTable.get(this._keyref[i]) == this) {
                    log.warn("Encountered reference to 'self' in object table.");
                }
                String key = (String)this._objectTable.get(this._keyref[i]);
                if (this._objref[i] < 0 || this._objref[i] >= this._objectTable.size()) {
                    log.error("Object table is in illegal state.  The object reference " + i + " is larger than the object table size " + this._objectTable.size());
                }
                if ((value = this._objectTable.get(this._objref[i])) instanceof BinaryArray) {
                    aDict.takeValueForKey(((BinaryArray)value).toNSArray(), key);
                } else if (value instanceof BinarySet) {
                    aDict.takeValueForKey(((BinarySet)value).toNSSet(), key);
                } else if (value instanceof BinaryDict) {
                    aDict.takeValueForKey(((BinaryDict)value).toNSDictionary(), key);
                } else {
                    aDict.takeValueForKey(value, key);
                }
                ++i;
            }
            return aDict.immutableClone();
        }

        @Override
        public void parse(ByteBuffer buffer, RefType objectRefType) {
            long[] refs = objectRefType.parse(buffer, this._objref.length);
            int i = 0;
            while (i < this._objref.length) {
                this.addKeyRef(i, refs[i]);
                ++i;
            }
            refs = objectRefType.parse(buffer, this._objref.length);
            i = 0;
            while (i < this._objref.length) {
                this.addValueRef(i, refs[i]);
                ++i;
            }
        }
    }

    protected static class BinarySet
    extends BinaryCollection {
        private final int[] _objref;
        private final List<Object> _objectTable;

        public BinarySet(List<Object> objectTable, int count) {
            this._objectTable = objectTable;
            this._objref = new int[count];
        }

        public int size() {
            return this._objref.length;
        }

        public void addValueRef(int index, long ref) {
            this._objref[index] = (int)ref;
        }

        public Object getValue(int i) {
            return this._objectTable.get(this._objref[i]);
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("BinarySet{");
            int i = 0;
            while (i < this._objref.length) {
                if (i > 0) {
                    buf.append(',');
                }
                if (this._objectTable.size() > this._objref[i] && this._objectTable.get(this._objref[i]) != this) {
                    buf.append(this._objectTable.get(this._objref[i]));
                } else {
                    buf.append("*" + this._objref[i]);
                }
                ++i;
            }
            buf.append('}');
            return buf.toString();
        }

        public NSSet<Object> toNSSet() {
            NSMutableSet<Object> aSet = new NSMutableSet<Object>();
            int i = 0;
            while (i < this._objref.length) {
                Object ref = this._objectTable.get(this._objref[i]);
                if (ref instanceof BinaryArray) {
                    aSet.addObject(((BinaryArray)ref).toNSArray());
                } else if (ref instanceof BinarySet) {
                    aSet.addObject(((BinarySet)ref).toNSSet());
                } else if (ref instanceof BinaryDict) {
                    aSet.addObject(((BinaryDict)ref).toNSDictionary());
                } else {
                    aSet.addObject(ref);
                }
                ++i;
            }
            return aSet.immutableClone();
        }

        @Override
        public void parse(ByteBuffer buffer, RefType objectRefType) {
            long[] refs = objectRefType.parse(buffer, this._objref.length);
            int i = 0;
            while (i < this._objref.length) {
                this.addValueRef(i, refs[i]);
                ++i;
            }
        }
    }

    protected static class EncodedArray
    extends EncodedObject {
        protected List<Long> _valueRefs = new ArrayList<Long>();

        public EncodedArray(NSData data) {
            this(data.bytes());
        }

        public EncodedArray(ByteBuffer data) {
            this(EncodedArray._bytes(data));
        }

        public EncodedArray(byte[] data) {
            super(data);
        }

        public void addValueRef(long ref) {
            this._valueRefs.add(ref);
        }

        @Override
        public void appendToData(NSMutableData data, RefType objectRefType) {
            super.appendToData(data, objectRefType);
            for (Long ref : this._valueRefs) {
                data.appendBytes(objectRefType.encode(ref));
            }
        }

        @Override
        public void appendToData(ByteBuffer data, RefType objectRefType) {
            super.appendToData(data, objectRefType);
            for (Long ref : this._valueRefs) {
                data.put(objectRefType.encode(ref));
            }
        }

        @Override
        public int size(RefType objectRefType) {
            return super.size(objectRefType) + this._valueRefs.size() * objectRefType.size();
        }
    }

    protected static class EncodedDictionary
    extends EncodedObject {
        protected List<Long> _keyRefs = new ArrayList<Long>();
        protected List<Long> _valueRefs = new ArrayList<Long>();

        public EncodedDictionary(NSData data) {
            this(data.bytes());
        }

        public EncodedDictionary(ByteBuffer data) {
            this(EncodedDictionary._bytes(data));
        }

        public EncodedDictionary(byte[] data) {
            super(data);
        }

        public void addKeyRef(long ref) {
            this._keyRefs.add(ref);
        }

        public void addValueRef(long ref) {
            this._valueRefs.add(ref);
        }

        @Override
        public void appendToData(NSMutableData data, RefType objectRefType) {
            super.appendToData(data, objectRefType);
            for (Long ref : this._keyRefs) {
                data.appendBytes(objectRefType.encode(ref));
            }
            for (Long ref : this._valueRefs) {
                data.appendBytes(objectRefType.encode(ref));
            }
        }

        @Override
        public void appendToData(ByteBuffer data, RefType objectRefType) {
            super.appendToData(data, objectRefType);
            for (Long ref : this._keyRefs) {
                data.put(objectRefType.encode(ref));
            }
            for (Long ref : this._valueRefs) {
                data.put(objectRefType.encode(ref));
            }
        }

        @Override
        public int size(RefType objectRefType) {
            return super.size(objectRefType) + this._keyRefs.size() * objectRefType.size() * 2;
        }
    }

    protected static class EncodedObject {
        protected byte[] _bytes;

        private EncodedObject() {
        }

        public EncodedObject(NSData data) {
            this();
            this._bytes = data.bytes();
        }

        public EncodedObject(ByteBuffer data) {
            this(EncodedObject._bytes(data));
        }

        public EncodedObject(byte[] data) {
            this();
            this._bytes = data;
        }

        public void appendToData(NSMutableData data, RefType objectRefType) {
            data.appendBytes(this._bytes);
        }

        public void appendToData(ByteBuffer data, RefType objectRefType) {
            data.put(this._bytes);
        }

        public int size(RefType objectRefType) {
            return this._bytes.length;
        }

        protected static byte[] _bytes(ByteBuffer buffer) {
            byte[] bytes = new byte[buffer.remaining()];
            buffer.get(bytes);
            return bytes;
        }

        public String toString() {
            return this.toString(RefType.sizeOf(2));
        }

        public String toString(RefType objectRef) {
            NSMutableData data = new NSMutableData(1024);
            this.appendToData(data, objectRef);
            return "[" + data.length() + "] " + data._hexString();
        }
    }

    protected static class EncodedSet
    extends EncodedObject {
        protected List<Long> _valueRefs = new ArrayList<Long>();

        public EncodedSet(NSData data) {
            this(data.bytes());
        }

        public EncodedSet(ByteBuffer data) {
            this(EncodedSet._bytes(data));
        }

        public EncodedSet(byte[] data) {
            super(data);
        }

        public void addValueRef(long ref) {
            this._valueRefs.add(ref);
        }

        @Override
        public void appendToData(NSMutableData data, RefType objectRefType) {
            super.appendToData(data, objectRefType);
            for (Long ref : this._valueRefs) {
                data.appendBytes(objectRefType.encode(ref));
            }
        }

        @Override
        public void appendToData(ByteBuffer data, RefType objectRefType) {
            super.appendToData(data, objectRefType);
            for (Long ref : this._valueRefs) {
                data.put(objectRefType.encode(ref));
            }
        }

        @Override
        public int size(RefType objectRefType) {
            return super.size(objectRefType) + this._valueRefs.size() * objectRefType.size();
        }
    }

    private static class RefType {
        private static final RefType[] RefTypes = new RefType[17];
        private int _size;

        private RefType(int size) {
            this._size = size;
        }

        public int size() {
            return this._size;
        }

        public static RefType sizeOf(int value) {
            if (value >= 0 && value <= 16) {
                RefType type = RefTypes[value];
                if (type == null) {
                    type = RefType.RefTypes[value] = new RefType(value);
                }
                return type;
            }
            return new RefType(value);
        }

        public static RefType forValue(long value) {
            int bits = value == 0L ? 0 : 63 - Long.numberOfLeadingZeros(value);
            int refsize = 1 << (bits >> 3);
            return RefType.sizeOf(refsize);
        }

        public long[] parse(ByteBuffer buffer, int count) {
            long[] result = new long[count];
            byte[] b = new byte[this.size()];
            int i = 0;
            while (i < count) {
                buffer.get(b);
                long ref = 0L;
                int j = 0;
                while (j < b.length) {
                    ref = ref << 8 | (long)(b[j] & 0xFF);
                    ++j;
                }
                result[i] = ref;
                ++i;
            }
            return result;
        }

        public byte[] encode(Long ref) {
            long aRef = ref;
            byte[] result = new byte[this.size()];
            int i = this.size();
            while (i > 0) {
                result[i - 1] = (byte)(aRef & 0xFFL);
                aRef >>= 8;
                --i;
            }
            return result;
        }
    }

    public static enum Type {
        kCFBinaryPlistMarkerNull(0, "kCFBinaryPlistMarkerNull", true),
        kCFBinaryPlistMarkerFalse(8, "kCFBinaryPlistMarkerFalse", true),
        kCFBinaryPlistMarkerTrue(9, "kCFBinaryPlistMarkerTrue", true),
        kCFBinaryPlistMarkerFill(15, "kCFBinaryPlistMarkerFill", true),
        kCFBinaryPlistMarkerInt(16, "kCFBinaryPlistMarkerInt", true),
        kCFBinaryPlistMarkerReal(32, "kCFBinaryPlistMarkerReal", true),
        kCFBinaryPlistMarkerDate(48, "kCFBinaryPlistMarkerDate", true),
        kCFBinaryPlistMarkerData(64, "kCFBinaryPlistMarkerData", false),
        kCFBinaryPlistMarkerASCIIString(80, "kCFBinaryPlistMarkerASCIIString", false),
        kCFBinaryPlistMarkerUnicode16String(96, "kCFBinaryPlistMarkerUnicode16String", false),
        kCFBinaryPlistMarkerUID(128, "kCFBinaryPlistMarkerUID", true),
        kCFBinaryPlistMarkerArray(160, "kCFBinaryPlistMarkerArray", false),
        kCFBinaryPlistMarkerSet(192, "kCFBinaryPlistMarkerSet", false),
        kCFBinaryPlistMarkerDict(208, "kCFBinaryPlistMarkerDict", false);

        String _name;
        int _value;
        boolean _fixedLength;

        private Type(int value, String name, boolean fixedLength) {
            this._value = value;
            this._name = name;
            this._fixedLength = fixedLength;
        }

        public static Type typeForValue(int type) {
            if (type > -1) {
                Type[] typeArray = Type.values();
                int n = typeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Type aType = typeArray[n2];
                    if (aType._value == type) {
                        return aType;
                    }
                    ++n2;
                }
            }
            return null;
        }

        public int value() {
            return this._value;
        }

        public boolean isFixedLength() {
            return this._fixedLength;
        }

        public String toString() {
            return this._name;
        }
    }
}

