/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.plist;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.plist._JSONPListImpl;
import com.webobjects.foundation.plist._PListBinaryParser;
import com.webobjects.foundation.plist._PListParser;
import com.webobjects.foundation.plist._PListTextParser;
import com.webobjects.foundation.plist.impl.NSPListBinaryImpl;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class NSPList {
    private static final Logger log = LoggerFactory.getLogger(NSPList.class);

    private NSPList() {
    }

    public static NSPListBuilder.NSPListEncodedReaderFormat read(byte[] bytes) {
        return new NSPListBuilder.NSPListReaderImpl(bytes);
    }

    public static NSPListBuilder.NSPListEncodedReaderFormat read(ByteBuffer buffer) {
        return new NSPListBuilder.NSPListReaderImpl(buffer);
    }

    public static NSPListBuilder.NSPListNormalizableCharReaderFormat read(CharSequence buffer) {
        return new NSPListBuilder.NSPListReaderImpl(buffer);
    }

    public static Object read(Document doc) {
        return new NSPListBuilder.NSPListDocumentReaderImpl(doc).read();
    }

    public static NSPListBuilder.NSPListEncodedReaderFormat read(File file) {
        return new NSPListBuilder.NSPListReaderImpl(file);
    }

    public static NSPListBuilder.NSPListEncodedReaderFormat read(InputStream is) {
        return new NSPListBuilder.NSPListReaderImpl(is);
    }

    public static NSPListBuilder.NSPListEncodedReaderFormat read(NSData data) {
        return new NSPListBuilder.NSPListReaderImpl(data);
    }

    public static NSPListBuilder.NSPListEncodedReaderFormat read(ReadableByteChannel channel) {
        return new NSPListBuilder.NSPListReaderImpl(channel);
    }

    public static NSPListBuilder.NSPListEncodedReaderFormat read(URL url) {
        return new NSPListBuilder.NSPListReaderImpl(url);
    }

    public static NSPListBuilder.NSPListWriter write(Object plist) {
        return new NSPListBuilder.NSPListWriterImpl(plist);
    }

    private static class NSPListBuilder {
        private NSPListBuilder() {
        }

        private static class ByteBufferInputStream
        extends InputStream {
            private ByteBuffer byteBuffer;

            ByteBufferInputStream(ByteBuffer buffer) {
                this.byteBuffer = buffer;
            }

            private static <T> T checkNotNull(T obj) {
                if (obj == null) {
                    throw new NullPointerException();
                }
                return obj;
            }

            private void checkClosed() throws IOException {
                if (this.byteBuffer == null) {
                    throw new IOException("InputStream is closed");
                }
            }

            @Override
            public int available() throws IOException {
                this.checkClosed();
                return this.byteBuffer.remaining();
            }

            @Override
            public void close() throws IOException {
                this.byteBuffer = null;
            }

            @Override
            public synchronized void mark(int readlimit) {
                this.byteBuffer.mark();
                this.byteBuffer.limit(this.byteBuffer.capacity() >= readlimit ? readlimit : this.byteBuffer.capacity());
            }

            @Override
            public boolean markSupported() {
                return true;
            }

            @Override
            public int read() throws IOException {
                this.checkClosed();
                return this.byteBuffer.hasRemaining() ? (int)this.byteBuffer.get() : -1;
            }

            @Override
            public int read(byte[] b) throws IOException {
                this.checkClosed();
                return this.read(b, 0, b.length);
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                this.checkClosed();
                ByteBufferInputStream.checkNotNull(bytes);
                if (!this.byteBuffer.hasRemaining()) {
                    return -1;
                }
                int count = len > this.byteBuffer.remaining() ? this.byteBuffer.remaining() : len;
                this.byteBuffer.get(bytes, off, count);
                return count;
            }

            @Override
            public synchronized void reset() throws IOException {
                this.byteBuffer.reset();
                this.byteBuffer.limit(this.byteBuffer.capacity());
            }

            @Override
            public long skip(long len) throws IOException {
                this.checkClosed();
                if (len <= 0L) {
                    return 0L;
                }
                int count = (int)len;
                int skip = count > this.byteBuffer.remaining() ? this.byteBuffer.remaining() : count;
                this.byteBuffer.position(this.byteBuffer.position() + skip);
                return count;
            }
        }

        public static interface NSPListCharReaderFormat {
            public Object asAny();

            public Object asASCII();

            public Object asJSON();

            public Object asXML();
        }

        public static interface NSPListCharWriterOutput
        extends NSPListWriterOutput {
            public void to(Appendable var1) throws IOException;

            public void to(StringBuffer var1);

            public void to(StringBuilder var1);

            public String toString();
        }

        private static class NSPListDocumentReaderImpl {
            private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
            private final Document document;

            NSPListDocumentReaderImpl(Document doc) {
                this.document = doc;
            }

            private String stringValue() {
                if (this.document == null) {
                    return null;
                }
                try {
                    Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    DOMSource source = new DOMSource(this.document);
                    StreamResult result = new StreamResult(new StringWriter());
                    transformer.transform(source, result);
                    return result.getWriter().toString();
                }
                catch (TransformerException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }

            Object read() {
                if (this.document == null) {
                    return null;
                }
                String xml = this.stringValue();
                return new NSPropertyListSerialization._XML().parseStringIntoPlist(xml);
            }
        }

        public static interface NSPListEncodedReaderFormat
        extends NSPListNormalizableReaderFormat {
            public NSPListNormalizableCharReaderFormat withEncoding(Charset var1);

            public NSPListNormalizableCharReaderFormat withEncoding(String var1);
        }

        public static interface NSPListNormalizableCharReaderFormat
        extends NSPListCharReaderFormat {
            public NSPListCharReaderFormat normalizedTo(Normalizer.Form var1);
        }

        public static interface NSPListNormalizableReaderFormat
        extends NSPListReaderFormat {
            public NSPListReaderFormat normalizedTo(Normalizer.Form var1);
        }

        public static interface NSPListReaderFormat
        extends NSPListCharReaderFormat {
            public Object asBinary();
        }

        private static class NSPListReaderImpl
        implements NSPListEncodedReaderFormat,
        NSPListReaderFormat,
        NSPListNormalizableCharReaderFormat {
            private static final int READ_AHEAD_SIZE = 256;
            private static final String JSON_REGEX = "\\s*\\{\\s*(?:\".*?[^\\\\]\"|\\w*[^:])\\s*:\\s*[^=].*";
            private static final Pattern JSON_PATTERN = Pattern.compile("\\s*\\{\\s*(?:\".*?[^\\\\]\"|\\w*[^:])\\s*:\\s*[^=].*", 32);
            private static final List<String> CHARSET_CANDIDATES = Arrays.asList("UTF-8", "UTF-16", "UTF-16LE", "UTF16-BE", "UTF-32");
            private final AbstractDataSource dataSource;
            private Object plist;

            NSPListReaderImpl(final byte[] bytes) {
                this.dataSource = bytes == null ? null : new AbstractDataSource(bytes){

                    @Override
                    public InputStream createStream() {
                        return new ByteArrayInputStream(bytes);
                    }
                };
            }

            NSPListReaderImpl(final ByteBuffer buffer) {
                this.dataSource = buffer == null ? null : new AbstractDataSource(buffer){

                    @Override
                    public InputStream createStream() {
                        return new ByteBufferInputStream(buffer);
                    }
                };
            }

            NSPListReaderImpl(CharSequence buffer) {
                this.dataSource = buffer == null ? null : new AbstractDataSource(buffer){

                    @Override
                    public InputStream createStream() {
                        return new ByteArrayInputStream(this.asString().getBytes());
                    }
                };
            }

            NSPListReaderImpl(final File file) {
                this.dataSource = file == null ? null : new AbstractDataSource(file){

                    @Override
                    public InputStream createStream() {
                        try {
                            return new FileInputStream(file);
                        }
                        catch (IOException e) {
                            log.error("Error opening file {}", (Object)file, (Object)e);
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                };
            }

            NSPListReaderImpl(final InputStream is) {
                this.dataSource = is == null ? null : new AbstractDataSource(is){

                    @Override
                    public InputStream createStream() {
                        return is;
                    }
                };
            }

            NSPListReaderImpl(final NSData data) {
                this.dataSource = data == null ? null : new AbstractDataSource(data){

                    @Override
                    public InputStream createStream() {
                        return data.stream();
                    }
                };
            }

            NSPListReaderImpl(final ReadableByteChannel channel) {
                this.dataSource = channel == null ? null : new AbstractDataSource(channel){

                    @Override
                    public InputStream createStream() {
                        return Channels.newInputStream(channel);
                    }
                };
            }

            NSPListReaderImpl(final URL url) {
                this.dataSource = url == null ? null : new AbstractDataSource(url){

                    @Override
                    public InputStream createStream() {
                        try {
                            return url.openStream();
                        }
                        catch (IOException e) {
                            log.error("Error opening URL {}", (Object)url, (Object)e);
                            throw NSForwardException._runtimeExceptionForThrowable(e);
                        }
                    }
                };
            }

            private static NSPropertyListSerialization.PListFormat identifyFormat(AbstractDataSource dataSource) {
                if (!dataSource.hasString()) {
                    try {
                        ByteBuffer buffer = NSPListReaderImpl.sampleStream(dataSource.asStream());
                        if (NSPListBinaryImpl.isBinaryPList(buffer)) {
                            return NSPropertyListSerialization.PListFormat.NSPropertyListBinaryFormat_v1_0;
                        }
                        return NSPListReaderImpl.identifyFormat(new String(buffer.array(), dataSource.charset()));
                    }
                    catch (IOException e) {
                        throw NSForwardException._runtimeExceptionForThrowable(e);
                    }
                }
                return NSPListReaderImpl.identifyFormat(dataSource.asString());
            }

            private static NSPropertyListSerialization.PListFormat identifyFormat(String sample) {
                if (sample.trim().startsWith("<?xml")) {
                    return NSPropertyListSerialization.PListFormat.NSPropertyListXMLFormat_v1_0;
                }
                if (JSON_PATTERN.matcher(sample).matches()) {
                    return NSPropertyListSerialization.PListFormat.NSPropertyListJsonFormat_v1_0;
                }
                return NSPropertyListSerialization.PListFormat.NSPropertyListOpenStepFormat;
            }

            private static Object read(_PListParser parser, AbstractDataSource dataSource) {
                if (parser instanceof _PListTextParser) {
                    _PListTextParser textParser = (_PListTextParser)parser;
                    if (dataSource.hasString()) {
                        return textParser.propertyListFromString(dataSource.asString(), dataSource.normalizerForm);
                    }
                    return textParser.propertyListWithStream(dataSource.asStream(), dataSource.charset().name(), dataSource.normalizerForm);
                }
                if (parser instanceof _PListBinaryParser) {
                    _PListBinaryParser bpparser = (_PListBinaryParser)((Object)parser);
                    Object data = dataSource.source;
                    if (data instanceof byte[]) {
                        return bpparser.propertyListWithData((byte[])data);
                    }
                    if (data instanceof ByteBuffer) {
                        return bpparser.propertyListWithData((ByteBuffer)data);
                    }
                    if (data instanceof NSData) {
                        return bpparser.propertyListWithData((NSData)data);
                    }
                }
                return parser.propertyListWithStream(dataSource.asStream(), dataSource.normalizerForm);
            }

            private static Object read(NSPropertyListSerialization._PListParser parser, AbstractDataSource dataSource) {
                return parser.parseStringIntoPlist(dataSource.asString());
            }

            private static ByteBuffer sampleStream(InputStream is) throws IOException {
                is.mark(256);
                ByteBuffer buffer = ByteBuffer.allocate(256);
                ReadableByteChannel channel = Channels.newChannel(is);
                while (buffer.hasRemaining() && channel.read(buffer) > 0) {
                }
                buffer.flip();
                is.reset();
                return buffer;
            }

            private Object read() {
                if (this.dataSource == null || this.plist != null) {
                    return this.plist;
                }
                return this.read(NSPListReaderImpl.identifyFormat(this.dataSource));
            }

            private Object read(NSPropertyListSerialization.PListFormat format) {
                if (this.dataSource == null || this.plist != null) {
                    return this.plist;
                }
                switch (format) {
                    case NSPropertyListBinaryFormat_v1_0: {
                        this.plist = NSPListReaderImpl.read(new NSPListBinaryImpl(), this.dataSource);
                        break;
                    }
                    case NSPropertyListJsonFormat_v1_0: {
                        this.plist = NSPListReaderImpl.read(new _JSONPListImpl(), this.dataSource);
                        break;
                    }
                    case NSPropertyListOpenStepFormat: {
                        this.plist = NSPListReaderImpl.read(new NSPropertyListSerialization._ApplePList(), this.dataSource);
                        break;
                    }
                    case NSPropertyListXMLFormat_v1_0: {
                        this.plist = NSPListReaderImpl.read(new NSPropertyListSerialization._XML(), this.dataSource);
                    }
                }
                return this.plist;
            }

            @Override
            public Object asAny() {
                return this.read();
            }

            @Override
            public Object asASCII() {
                return this.read(NSPropertyListSerialization.PListFormat.NSPropertyListOpenStepFormat);
            }

            @Override
            public Object asBinary() {
                return this.read(NSPropertyListSerialization.PListFormat.NSPropertyListBinaryFormat_v1_0);
            }

            @Override
            public Object asJSON() {
                return this.read(NSPropertyListSerialization.PListFormat.NSPropertyListJsonFormat_v1_0);
            }

            @Override
            public Object asXML() {
                return this.read(NSPropertyListSerialization.PListFormat.NSPropertyListXMLFormat_v1_0);
            }

            @Override
            public NSPListReaderImpl normalizedTo(Normalizer.Form form) {
                this.dataSource.normalizerForm = form;
                return this;
            }

            public String toString() {
                String value = new NSPropertyListSerialization._ApplePList().stringFromPropertyList(this.read());
                return value == null ? "" : value;
            }

            @Override
            public NSPListReaderImpl withEncoding(Charset charset) {
                this.dataSource.charset = charset;
                return this;
            }

            @Override
            public NSPListReaderImpl withEncoding(String encoding) {
                this.dataSource.charset = Charset.forName(encoding);
                return this;
            }

            private static abstract class AbstractDataSource {
                private final CharSequence chars;
                private Charset charset;
                private InputStream stream;
                private final Object source;
                private String string;
                private Normalizer.Form normalizerForm;

                AbstractDataSource(Object input) {
                    this.source = input;
                    this.chars = null;
                }

                AbstractDataSource(CharSequence charSeq) {
                    this.source = charSeq;
                    this.chars = charSeq;
                }

                private static Charset identifyCharset(ByteBuffer buffer) {
                    Charset cs = AbstractDataSource.identifyCharset(buffer, CHARSET_CANDIDATES);
                    if (cs == null) {
                        cs = AbstractDataSource.identifyCharset(buffer, Charset.availableCharsets().keySet());
                    }
                    if (cs == null) {
                        cs = Charset.defaultCharset();
                    }
                    return cs;
                }

                private static Charset identifyCharset(ByteBuffer buffer, Iterable<String> names) {
                    for (String name : names) {
                        Charset cs = Charset.forName(name);
                        if (!AbstractDataSource.isValidCharset(buffer, cs)) continue;
                        return cs;
                    }
                    return null;
                }

                private static Charset identifyCharset(InputStream inputStream) {
                    try {
                        ByteBuffer buffer = NSPListReaderImpl.sampleStream(inputStream);
                        return AbstractDataSource.identifyCharset(buffer);
                    }
                    catch (IOException e) {
                        log.error("Error reading from stream", (Throwable)e);
                        return Charset.defaultCharset();
                    }
                }

                private static boolean isValidCharset(ByteBuffer buffer, Charset charset) {
                    if (charset == null) {
                        return false;
                    }
                    try {
                        charset.newDecoder().decode(buffer.duplicate());
                        return true;
                    }
                    catch (CharacterCodingException characterCodingException) {
                        return false;
                    }
                }

                private Charset charset() {
                    if (this.charset != null) {
                        return this.charset;
                    }
                    this.charset = AbstractDataSource.identifyCharset(this.asStream());
                    return this.charset;
                }

                private String stringFromStream(InputStream is, Charset charset) {
                    try (Scanner scan = new Scanner(is, charset.name()).useDelimiter("\\A");){
                        String result;
                        String string = result = scan.hasNext() ? scan.next() : "";
                        if (this.normalizerForm != null) {
                            result = Normalizer.normalize(result, this.normalizerForm);
                        }
                        String string2 = result;
                        return string2;
                    }
                }

                final InputStream asStream() {
                    if (this.stream == null) {
                        this.stream = this.createStream();
                    }
                    if (!this.stream.markSupported()) {
                        this.stream = new BufferedInputStream(this.stream);
                    }
                    return this.stream;
                }

                final String asString() {
                    if (this.string == null) {
                        this.string = this.chars == null ? this.stringFromStream(this.asStream(), this.charset()) : this.chars.toString();
                    }
                    return this.string;
                }

                abstract InputStream createStream();

                final boolean hasString() {
                    return this.chars != null || this.string != null;
                }
            }
        }

        public static interface NSPListWriter {
            public NSPListCharWriterOutput asASCII();

            public NSPListWriterOutput asBinary();

            public NSPListCharWriterOutput asJSON();

            public NSPListCharWriterOutput asXML();

            public Document toDOM();
        }

        private static class NSPListWriterImpl
        implements NSPListWriter,
        NSPListCharWriterOutput {
            private static final DocumentBuilderFactory DOC_FACTORY = DocumentBuilderFactory.newInstance();
            private final Object plist;
            private NSPropertyListSerialization.PListFormat format = NSPropertyListSerialization.PListFormat.NSPropertyListOpenStepFormat;

            NSPListWriterImpl(Object aPlist) {
                this.plist = aPlist;
            }

            private static Document plistToDOM(Object plist) {
                if (plist == null) {
                    return null;
                }
                NSPropertyListSerialization._XML parser = new NSPropertyListSerialization._XML();
                String xmlString = parser.stringFromPropertyList(plist);
                ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes());
                try {
                    DocumentBuilder builder = DOC_FACTORY.newDocumentBuilder();
                    return builder.parse(is);
                }
                catch (ParserConfigurationException e) {
                    log.error("Error configurating XML parser", (Throwable)e);
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
                catch (SAXException e) {
                    log.error("Error parsing content", (Throwable)e);
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
                catch (IOException e) {
                    log.error("Error parsing content", (Throwable)e);
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }

            private static String stringFromPlist(_PListParser parser, Object plist) {
                if (parser instanceof _PListTextParser) {
                    _PListTextParser textParser = (_PListTextParser)parser;
                    return textParser.stringFromPropertyList(plist, false);
                }
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    parser.writePropertyListToStream(plist, out);
                    return new NSData(out.toByteArray()).toString();
                }
                catch (IOException e) {
                    log.error("Error writing content", (Throwable)e);
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }

            private String stringValue() {
                String result = null;
                switch (this.format) {
                    case NSPropertyListJsonFormat_v1_0: {
                        result = NSPListWriterImpl.stringFromPlist(new _JSONPListImpl(), this.plist);
                        break;
                    }
                    case NSPropertyListXMLFormat_v1_0: {
                        result = new NSPropertyListSerialization._XML().stringFromPropertyList(this.plist);
                        break;
                    }
                    case NSPropertyListOpenStepFormat: {
                        result = new NSPropertyListSerialization._ApplePList().stringFromPropertyList(this.plist);
                        break;
                    }
                    case NSPropertyListBinaryFormat_v1_0: {
                        result = NSPListWriterImpl.stringFromPlist(new NSPListBinaryImpl(), this.plist);
                    }
                }
                return result;
            }

            @Override
            public NSPListWriterImpl asASCII() {
                this.format = NSPropertyListSerialization.PListFormat.NSPropertyListOpenStepFormat;
                return this;
            }

            @Override
            public NSPListWriterImpl asBinary() {
                this.format = NSPropertyListSerialization.PListFormat.NSPropertyListBinaryFormat_v1_0;
                return this;
            }

            @Override
            public NSPListWriterImpl asJSON() {
                this.format = NSPropertyListSerialization.PListFormat.NSPropertyListJsonFormat_v1_0;
                return this;
            }

            @Override
            public NSPListWriterImpl asXML() {
                this.format = NSPropertyListSerialization.PListFormat.NSPropertyListXMLFormat_v1_0;
                return this;
            }

            @Override
            public void to(Appendable buffer) throws IOException {
                buffer.append(this.stringValue());
            }

            @Override
            public void to(File file) throws IOException {
                this.to(new FileOutputStream(file));
            }

            @Override
            public void to(OutputStream os) throws IOException {
                switch (this.format) {
                    case NSPropertyListBinaryFormat_v1_0: {
                        new NSPListBinaryImpl().writePropertyListToStream(this.plist, os);
                        break;
                    }
                    case NSPropertyListOpenStepFormat: 
                    case NSPropertyListXMLFormat_v1_0: 
                    case NSPropertyListJsonFormat_v1_0: {
                        String plistString = this.stringValue();
                        PrintStream printStream = new PrintStream(os);
                        printStream.print(plistString);
                        printStream.close();
                    }
                }
            }

            @Override
            public void to(StringBuffer buffer) {
                buffer.append(this.stringValue());
            }

            @Override
            public void to(StringBuilder buffer) {
                buffer.append(this.stringValue());
            }

            @Override
            public void to(URI uri) throws IOException {
                if ("file".equals(uri.getScheme())) {
                    File file = new File(uri);
                    this.to(file);
                } else {
                    URLConnection connection = uri.toURL().openConnection();
                    connection.setDoOutput(true);
                    this.to(connection.getOutputStream());
                }
            }

            @Override
            public void to(URL url) throws IOException {
                try {
                    this.to(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }

            @Override
            public void to(WritableByteChannel channel) throws IOException {
                this.to(Channels.newOutputStream(channel));
            }

            @Override
            public byte[] toBytes() {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try {
                    this.to(os);
                    return os.toByteArray();
                }
                catch (IOException e) {
                    throw NSForwardException._runtimeExceptionForThrowable(e);
                }
            }

            @Override
            public NSData toData() {
                return new NSData(this.toBytes());
            }

            @Override
            public Document toDOM() {
                return NSPListWriterImpl.plistToDOM(this.plist);
            }

            @Override
            public String toString() {
                String value = this.stringValue();
                return value == null ? "" : value;
            }
        }

        public static interface NSPListWriterOutput {
            public void to(File var1) throws IOException;

            public void to(OutputStream var1) throws IOException;

            public void to(URI var1) throws IOException;

            public void to(URL var1) throws IOException;

            public void to(WritableByteChannel var1) throws IOException;

            public byte[] toBytes();

            public NSData toData();
        }
    }
}

